/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.database;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import com.zefir.servercosmetics.ServerCosmetics;
import com.zefir.servercosmetics.data.CustomItemEntry;
import com.zefir.servercosmetics.data.CustomItemRegistry;
import com.zefir.servercosmetics.data.ItemType;
import com.zefir.servercosmetics.database.CosmeticTable;
import java.sql.SQLException;
import java.util.HashMap;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class DatabaseManager {
    private static final String DATABASE_URL = "jdbc:sqlite:cosmetics.db";
    private static final Dao<CosmeticTable, Integer> cosmeticDao;

    public static void init() {
    }

    public static void setCosmetic(class_3222 player, ItemType type, class_1799 itemStack) {
        try {
            CosmeticTable existingEntry = DatabaseManager.findEntry(player.method_5845(), type);
            if (itemStack == null || itemStack.method_7960()) {
                if (existingEntry != null) {
                    cosmeticDao.delete((Object)existingEntry);
                }
                return;
            }
            String cosmeticId = DatabaseManager.getCosmeticIdFromStack(itemStack);
            if (cosmeticId == null) {
                ServerCosmetics.LOGGER.warn("Attempted to set a cosmetic with an ItemStack lacking a 'cosmeticItemId' for player {}", (Object)player.method_5845());
                if (existingEntry != null) {
                    cosmeticDao.delete((Object)existingEntry);
                }
                return;
            }
            Integer dyedColor = DatabaseManager.getDyedColorFromStack(itemStack);
            if (existingEntry != null) {
                existingEntry.setCosmeticId(cosmeticId);
                existingEntry.setDyedColor(dyedColor);
                cosmeticDao.update((Object)existingEntry);
            } else {
                CosmeticTable newEntry = new CosmeticTable();
                newEntry.setUuid(player.method_5845());
                newEntry.setCosmeticType(type.toString());
                newEntry.setCosmeticId(cosmeticId);
                newEntry.setDyedColor(dyedColor);
                cosmeticDao.create((Object)newEntry);
            }
        }
        catch (SQLException e) {
            ServerCosmetics.LOGGER.error("Error saving cosmetic data for player {} and type {}", new Object[]{player.method_5845(), type, e});
            throw new RuntimeException("Error saving cosmetic data", e);
        }
    }

    public static class_1799 getCosmeticItemStack(class_3222 player, ItemType type) {
        try {
            CosmeticTable cosmeticData = DatabaseManager.findEntry(player.method_5845(), type);
            if (cosmeticData == null || cosmeticData.getCosmeticId() == null) {
                return class_1799.field_8037;
            }
            CustomItemEntry cosmeticDefinition = CustomItemRegistry.getCosmetic(cosmeticData.getCosmeticId());
            if (cosmeticDefinition == null) {
                ServerCosmetics.LOGGER.warn("Player {} has cosmetic '{}' equipped, but it's no longer registered.", (Object)player.method_5477().getString(), (Object)cosmeticData.getCosmeticId());
                return class_1799.field_8037;
            }
            if (!Permissions.check((class_1297)player, (String)cosmeticDefinition.permission(), (int)4)) {
                return class_1799.field_8037;
            }
            class_1799 cosmeticStack = cosmeticDefinition.itemStack().method_7972();
            if (cosmeticData.getDyedColor() != null) {
                cosmeticStack.method_57379(class_9334.field_49644, (Object)new class_9282(cosmeticData.getDyedColor().intValue(), true));
            }
            return cosmeticStack;
        }
        catch (SQLException e) {
            ServerCosmetics.LOGGER.error("Error loading cosmetic data for player {} and type {}", new Object[]{player.method_5845(), type, e});
            throw new RuntimeException("Error loading cosmetic data", e);
        }
    }

    public static CustomItemEntry getCosmeticEntry(class_3222 player, ItemType type) {
        try {
            CosmeticTable cosmeticData = DatabaseManager.findEntry(player.method_5845(), type);
            if (cosmeticData == null || cosmeticData.getCosmeticId() == null) {
                return null;
            }
            return CustomItemRegistry.getCosmetic(cosmeticData.getCosmeticId());
        }
        catch (SQLException e) {
            ServerCosmetics.LOGGER.error("Error loading cosmetic data for player {} and type {}", new Object[]{player.method_5845(), type, e});
            throw new RuntimeException("Error loading cosmetic data", e);
        }
    }

    private static CosmeticTable findEntry(String playerUUID, ItemType type) throws SQLException {
        HashMap<String, String> queryFields = new HashMap<String, String>();
        queryFields.put("uuid", playerUUID);
        queryFields.put("cosmetic_type", type.toString());
        return cosmeticDao.queryForFieldValues(queryFields).stream().findFirst().orElse(null);
    }

    private static String getCosmeticIdFromStack(class_1799 stack) {
        class_2487 nbt;
        class_9279 customData = (class_9279)stack.method_57824(class_9334.field_49628);
        if (customData != null && (nbt = customData.method_57461()).method_10573("cosmeticItemId", 8)) {
            return nbt.method_10558("cosmeticItemId");
        }
        return null;
    }

    private static Integer getDyedColorFromStack(class_1799 stack) {
        class_9282 dyedColor = (class_9282)stack.method_57824(class_9334.field_49644);
        return dyedColor != null ? Integer.valueOf(dyedColor.comp_2384()) : null;
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(DATABASE_URL);
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, CosmeticTable.class);
            cosmeticDao = DaoManager.createDao((ConnectionSource)connectionSource, CosmeticTable.class);
        }
        catch (Exception e) {
            ServerCosmetics.LOGGER.error("Failed to initialize database", (Throwable)e);
            throw new RuntimeException("Error initializing database", e);
        }
    }
}

