/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1802;
import net.minecraft.class_6880;

public class ArmorModelGenerator {
    private static final List<TrimMaterial> ALL_TRIM_MATERIALS = ArmorModelGenerator.createTrimMaterials();

    private static List<TrimMaterial> createTrimMaterials() {
        return List.of(new TrimMaterial("quartz", 0.1f, Map.of(), TrimMaterialSource.VANILLA), new TrimMaterial("iron", 0.2f, Map.of(class_1740.field_7892, "iron_darker"), TrimMaterialSource.VANILLA), new TrimMaterial("netherite", 0.3f, Map.of(class_1740.field_21977, "netherite_darker"), TrimMaterialSource.VANILLA), new TrimMaterial("redstone", 0.4f, Map.of(), TrimMaterialSource.VANILLA), new TrimMaterial("copper", 0.5f, Map.of(), TrimMaterialSource.VANILLA), new TrimMaterial("gold", 0.6f, Map.of(class_1740.field_7895, "gold_darker"), TrimMaterialSource.VANILLA), new TrimMaterial("emerald", 0.7f, Map.of(), TrimMaterialSource.VANILLA), new TrimMaterial("diamond", 0.8f, Map.of(class_1740.field_7889, "diamond_darker"), TrimMaterialSource.VANILLA), new TrimMaterial("lapis", 0.9f, Map.of(), TrimMaterialSource.VANILLA), new TrimMaterial("amethyst", 1.0f, Map.of(), TrimMaterialSource.VANILLA));
    }

    public static Map<String, byte[]> generateModels(String cosmeticId, class_1738.class_8051 armorType) {
        HashMap<String, byte[]> generatedModels = new HashMap<String, byte[]>();
        class_1738 dummyArmorItem = ArmorModelGenerator.getDummyArmorItem(armorType);
        String modelName = cosmeticId + "_" + armorType.method_48400().toLowerCase();
        String baseModelPath = "assets/servercosmetics/models/item/armor/" + modelName + ".json";
        String baseTexturePath = "servercosmetics:item/armor/" + modelName;
        JsonObject baseModel = ArmorModelGenerator.createArmorJsonWithOverrides(dummyArmorItem, cosmeticId);
        generatedModels.put(baseModelPath, baseModel.toString().getBytes(StandardCharsets.UTF_8));
        for (TrimMaterial trimMaterial : ALL_TRIM_MATERIALS) {
            String appliedTrimName = trimMaterial.getAppliedName((class_6880<class_1741>)dummyArmorItem.method_7686());
            String trimModelName = modelName + "_" + appliedTrimName + "_trim";
            String trimModelPath = "assets/servercosmetics/models/item/armor/" + trimModelName + ".json";
            String trimTexturePath = "minecraft:trims/items/" + armorType.method_48400() + "_trim_" + appliedTrimName;
            JsonObject trimModelJson = ArmorModelGenerator.createTrimmedArmorJson(baseTexturePath, trimTexturePath);
            generatedModels.put(trimModelPath, trimModelJson.toString().getBytes(StandardCharsets.UTF_8));
        }
        return generatedModels;
    }

    private static class_1738 getDummyArmorItem(class_1738.class_8051 armorType) {
        return switch (armorType) {
            case class_1738.class_8051.field_41934 -> (class_1738)class_1802.field_8267;
            case class_1738.class_8051.field_41935 -> (class_1738)class_1802.field_8577;
            case class_1738.class_8051.field_41936 -> (class_1738)class_1802.field_8570;
            case class_1738.class_8051.field_41937 -> (class_1738)class_1802.field_8370;
            default -> throw new IllegalStateException("Unsupported armor type for model generation: " + String.valueOf(armorType));
        };
    }

    private static JsonObject createArmorJsonWithOverrides(class_1738 armor, String cosmeticId) {
        JsonObject root = new JsonObject();
        String modelName = cosmeticId + "_" + armor.method_48398().method_48400().toLowerCase();
        root.addProperty("parent", "minecraft:item/generated");
        JsonObject textures = new JsonObject();
        textures.addProperty("layer0", "servercosmetics:item/armor/" + modelName);
        root.add("textures", (JsonElement)textures);
        JsonArray overrides = new JsonArray();
        for (TrimMaterial trimMaterial : ALL_TRIM_MATERIALS) {
            JsonObject override = new JsonObject();
            JsonObject predicate = new JsonObject();
            predicate.addProperty("trim_type", (Number)Float.valueOf(trimMaterial.itemModelIndex()));
            override.add("predicate", (JsonElement)predicate);
            String appliedTrimName = trimMaterial.getAppliedName((class_6880<class_1741>)armor.method_7686());
            String trimModelId = "servercosmetics:item/armor/" + modelName + "_" + appliedTrimName + "_trim";
            override.addProperty("model", trimModelId);
            overrides.add((JsonElement)override);
        }
        root.add("overrides", (JsonElement)overrides);
        return root;
    }

    private static JsonObject createTrimmedArmorJson(String layer0, String layer1) {
        JsonObject root = new JsonObject();
        root.addProperty("parent", "minecraft:item/generated");
        JsonObject textures = new JsonObject();
        textures.addProperty("layer0", layer0);
        textures.addProperty("layer1", layer1);
        root.add("textures", (JsonElement)textures);
        return root;
    }

    private record TrimMaterial(String name, float itemModelIndex, Map<class_6880<class_1741>, String> overrideArmorMaterials, TrimMaterialSource source) {
        public String getAppliedName(class_6880<class_1741> armorMaterial) {
            return this.overrideArmorMaterials.getOrDefault(armorMaterial, this.name);
        }
    }

    public static enum TrimMaterialSource {
        VANILLA("minecraft");

        private final String namespace;

        private TrimMaterialSource(String namespace) {
            this.namespace = namespace;
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }
    }
}

