/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.mixin;

import com.zefir.servercosmetics.data.ItemType;
import com.zefir.servercosmetics.ext.ICosmetic;
import com.zefir.servercosmetics.ext.ICosmetics;
import com.zefir.servercosmetics.util.ArmorCosmetic;
import com.zefir.servercosmetics.util.BodyCosmetic;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin_cosmetics
implements ICosmetics {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerPlayerEntityMixin_cosmetics.class);
    @Unique
    private final List<ICosmetic> cosmeticsList = new ArrayList<ICosmetic>();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        this.cosmeticsList.addAll(List.of(new BodyCosmetic(player, ItemType.BODY_COSMETIC), new ArmorCosmetic(player, ItemType.HAT), new ArmorCosmetic(player, ItemType.CHESTPLATE), new ArmorCosmetic(player, ItemType.LEGGINGS), new ArmorCosmetic(player, ItemType.BOOTS)));
    }

    @Inject(method={"playerTick"}, at={@At(value="TAIL")})
    private void sendBackpackCosmeticPacket(CallbackInfo ci) {
        this.tickArmor();
    }

    @Override
    public void tickArmor() {
        this.cosmeticsList.forEach(ICosmetic::tick);
    }

    @Override
    public void initCosmetics() {
        this.cosmeticsList.forEach(ICosmetic::init);
    }

    @Override
    public void removeCosmetics() {
        this.cosmeticsList.forEach(ICosmetic::onUnload);
    }

    @Override
    public List<ICosmetic> getCosmeticsList() {
        return this.cosmeticsList;
    }

    @Override
    public ICosmetic getCosmeticFor(ItemType type) {
        ItemType primaryType = switch (type) {
            case ItemType.HELMET, ItemType.HAT_BODY_COSMETIC -> ItemType.HAT;
            case ItemType.CHESTPLATE_BODY_COSMETIC -> ItemType.CHESTPLATE;
            case ItemType.LEGGINGS_BODY_COSMETIC -> ItemType.LEGGINGS;
            case ItemType.BOOTS_BODY_COSMETIC -> ItemType.BOOTS;
            default -> type;
        };
        for (ICosmetic cosmetic : this.cosmeticsList) {
            if (cosmetic.getItemType() != primaryType) continue;
            return cosmetic;
        }
        throw new IllegalArgumentException("No cosmetic found for type: " + String.valueOf((Object)type));
    }
}

