/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.villagertrades.gui;

import io.github.flemmli97.villagertrades.gui.inv.SeparateInvImpl;
import io.github.flemmli97.villagertrades.gui.inv.SlotDelegate;
import io.github.flemmli97.villagertrades.mixin.AbstractContainerAccessor;
import java.util.function.IntPredicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class EditableServerOnlyScreenHandler
extends AbstractContainerMenu {
    protected final int size;
    private final SeparateInvImpl inventory;
    private final IntPredicate allowed;

    protected EditableServerOnlyScreenHandler(int syncId, Inventory playerInventory, int rows, final boolean canMoveItems, IntPredicate allowedSlots) {
        super(EditableServerOnlyScreenHandler.fromRows(rows), syncId);
        int m;
        int n;
        int i = (rows - 4) * 18;
        this.allowed = allowedSlots;
        this.inventory = new SeparateInvImpl(rows * 9, allowedSlots);
        this.size = this.inventory.getContainerSize();
        for (n = 0; n < rows; ++n) {
            for (m = 0; m < 9; ++m) {
                this.addSlot(new SlotDelegate(this, this.inventory, m + n * 9, 8 + m * 18, 18 + n * 18){

                    @Override
                    public boolean mayPlace(ItemStack stack) {
                        return canMoveItems;
                    }

                    @Override
                    public boolean mayPickup(Player playerEntity) {
                        return canMoveItems;
                    }
                });
            }
        }
        for (n = 0; n < 3; ++n) {
            for (m = 0; m < 9; ++m) {
                this.addSlot(new Slot((Container)playerInventory, m + n * 9 + 9, 8 + m * 18, 103 + n * 18 + i));
            }
        }
        for (n = 0; n < 9; ++n) {
            this.addSlot(new Slot((Container)playerInventory, n, 8 + n * 18, 161 + i));
        }
    }

    private static MenuType<ChestMenu> fromRows(int rows) {
        return switch (rows) {
            case 2 -> MenuType.GENERIC_9x2;
            case 3 -> MenuType.GENERIC_9x3;
            case 4 -> MenuType.GENERIC_9x4;
            case 5 -> MenuType.GENERIC_9x5;
            case 6 -> MenuType.GENERIC_9x6;
            default -> MenuType.GENERIC_9x1;
        };
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clicked(int i, int mouse, ClickType clickType, Player playerEntity) {
        if (i == -999) {
            super.clicked(i, mouse, clickType, playerEntity);
            this.onDrag(mouse, clickType, playerEntity);
            return;
        }
        if (i < 0) {
            return;
        }
        if (i > 54 || this.allowed.test(i)) {
            super.clicked(i, mouse, clickType, playerEntity);
        }
        Slot slot = (Slot)this.slots.get(i);
        if (this.isRightSlot(i, clickType)) {
            if (((AbstractContainerAccessor)((Object)this)).containerSync() != null) {
                ((AbstractContainerAccessor)((Object)this)).containerSync().sendCarriedChange((AbstractContainerMenu)this, this.getCarried().copy());
            }
            this.handleSlotClicked((ServerPlayer)playerEntity, i, slot, mouse);
        }
        ItemStack stack = slot.getItem().copy();
        for (ContainerListener listener : ((AbstractContainerAccessor)((Object)this)).listeners()) {
            listener.slotChanged((AbstractContainerMenu)this, i, stack);
        }
    }

    protected void onDrag(int mouse, ClickType clickType, Player playerEntity) {
    }

    public ItemStack quickMoveStack(Player player, int index) {
        if (index < 0) {
            return ItemStack.EMPTY;
        }
        if (index < 54 && !this.allowed.test(index)) {
            Slot slot = (Slot)this.slots.get(index);
            if (this.isRightSlot(index, null)) {
                this.handleSlotClicked((ServerPlayer)player, index, slot, 0);
            }
            return slot.getItem().copy();
        }
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < 54 ? !this.moveItemStackTo(itemStack2, 54, this.slots.size(), true) : !this.moveToExceptAndUpdate((ServerPlayer)player, itemStack2, 18, 54, false, idx -> {
                int modI = idx % 9;
                return modI == 2 || modI == 4 || modI == 7;
            })) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        if (this.isRightSlot(index, null)) {
            this.handleSlotClicked((ServerPlayer)player, index, slot, 0);
        }
        return itemStack;
    }

    private boolean moveToExceptAndUpdate(ServerPlayer player, ItemStack stack, int startIndex, int endIndex, boolean reverseDirection, IntPredicate excluded) {
        Slot slot;
        ItemStack itemStack;
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                if (!excluded.test(i) && !(itemStack = (slot = (Slot)this.slots.get(i)).getItem()).isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack)) {
                    int j = itemStack.getCount() + stack.getCount();
                    if (j <= stack.getMaxStackSize()) {
                        stack.setCount(0);
                        itemStack.setCount(j);
                        slot.setChanged();
                        this.handleSlotClicked(player, i, slot, 0);
                        bl = true;
                    } else if (itemStack.getCount() < stack.getMaxStackSize()) {
                        stack.shrink(stack.getMaxStackSize() - itemStack.getCount());
                        itemStack.setCount(stack.getMaxStackSize());
                        slot.setChanged();
                        this.handleSlotClicked(player, i, slot, 0);
                        bl = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                if (!excluded.test(i) && (itemStack = (slot = (Slot)this.slots.get(i)).getItem()).isEmpty() && slot.mayPlace(stack)) {
                    if (stack.getCount() > slot.getMaxStackSize()) {
                        slot.setByPlayer(stack.split(slot.getMaxStackSize()));
                    } else {
                        slot.setByPlayer(stack.split(stack.getCount()));
                    }
                    slot.setChanged();
                    this.handleSlotClicked(player, i, slot, 0);
                    bl = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }

    protected abstract boolean isRightSlot(int var1, @Nullable ClickType var2);

    protected abstract boolean handleSlotClicked(ServerPlayer var1, int var2, Slot var3, int var4);
}

