/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.villagertrades.gui;

import io.github.flemmli97.villagertrades.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.villagertrades.gui.StringResultScreenHandler;
import io.github.flemmli97.villagertrades.gui.TradeEditor;
import io.github.flemmli97.villagertrades.helper.MerchantOfferMixinInterface;
import io.github.flemmli97.villagertrades.mixin.MerchantOfferAccessor;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class OfferEditor
extends ServerOnlyScreenHandler
implements TradeEditor.MerchantDataBacktrack {
    public final AbstractVillager villager;
    public final MerchantOffer offer;
    public final int page;
    public final List<MerchantOffer> currentOffers;
    private boolean changed;

    protected OfferEditor(int syncId, Inventory playerInventory, AbstractVillager villager, MerchantOffer offer, int page, List<MerchantOffer> currentOffers, boolean changed) {
        super(syncId, playerInventory, 4);
        this.villager = villager;
        this.offer = offer;
        this.page = page;
        this.currentOffers = currentOffers;
        this.changed = changed;
        this.update();
    }

    public static void openGui(ServerPlayer player, final AbstractVillager villager, final MerchantOffer offer, final int page, final List<MerchantOffer> currentOffers, final boolean changed) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new OfferEditor(syncId, inv, villager, offer, page, currentOffers, changed);
            }

            public Component getDisplayName() {
                return Component.translatable((String)"villagertrades.gui.offer.edit");
            }
        };
        player.openMenu(fac);
    }

    private void update() {
        for (int i = 0; i < 36; ++i) {
            if (i == 0) {
                ItemStack stack = new ItemStack((ItemLike)Items.RED_TERRACOTTA);
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.back").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i >= 9 && i <= 27 && i % 9 != 0 && i % 9 != 8) continue;
            ((Slot)this.slots.get(i)).set(TradeEditor.emptyFiller());
        }
        ItemStack stack = new ItemStack((ItemLike)Items.WHEAT);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.offer.edit.uses").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"villagertrades.gui.offer.tooltip.uses", (Object[])new Object[]{this.offer.getUses()}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)))));
        ((Slot)this.slots.get(10)).set(stack);
        stack = new ItemStack((ItemLike)Items.EMERALD_ORE);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.offer.edit.maxUses").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"villagertrades.gui.offer.tooltip.maxUses", (Object[])new Object[]{this.offer.getMaxUses()}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)))));
        ((Slot)this.slots.get(19)).set(stack);
        stack = new ItemStack((ItemLike)(((MerchantOfferMixinInterface)this.offer).isInfinite() ? Items.EMERALD_BLOCK : Items.REDSTONE_BLOCK));
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.offer.edit.infinite").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"villagertrades.gui.offer.tooltip.infinite", (Object[])new Object[]{Component.translatable((String)(stack.is(Items.EMERALD_BLOCK) ? "villagertrades.gui.true" : "villagertrades.gui.false"))}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)))));
        ((Slot)this.slots.get(12)).set(stack);
        stack = new ItemStack((ItemLike)Items.LAPIS_LAZULI);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.offer.edit.rewardExp").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
        if (this.offer.shouldRewardExp()) {
            stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        }
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"villagertrades.gui.offer.tooltip.rewardExp", (Object[])new Object[]{Component.translatable((String)(this.offer.shouldRewardExp() ? "villagertrades.gui.true" : "villagertrades.gui.false"))}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)))));
        ((Slot)this.slots.get(21)).set(stack);
        stack = new ItemStack((ItemLike)Items.BOOK);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.offer.edit.xp").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"villagertrades.gui.offer.tooltip.xp", (Object[])new Object[]{this.offer.getXp()}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)))));
        ((Slot)this.slots.get(14)).set(stack);
        stack = new ItemStack((ItemLike)Items.IRON_INGOT);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.offer.edit.specialPriceDiff").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"villagertrades.gui.offer.tooltip.specialPriceDiff", (Object[])new Object[]{this.offer.getSpecialPriceDiff()}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)))));
        ((Slot)this.slots.get(23)).set(stack);
        stack = new ItemStack((ItemLike)Items.LECTERN);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.offer.edit.demand").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"villagertrades.gui.offer.tooltip.demand", (Object[])new Object[]{this.offer.getDemand()}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)))));
        ((Slot)this.slots.get(16)).set(stack);
        stack = new ItemStack((ItemLike)Items.DIAMOND);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.offer.edit.priceMultiplier").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"villagertrades.gui.offer.tooltip.priceMultiplier", (Object[])new Object[]{Float.valueOf(this.offer.getPriceMultiplier())}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)))));
        ((Slot)this.slots.get(25)).set(stack);
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int mouse) {
        if (index == 0) {
            TradeEditor.openFrom(player, this);
            TradeEditor.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        switch (index) {
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 23: {
                StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                    try {
                        int amount = Integer.parseInt(s);
                        switch (index) {
                            case 10: {
                                ((MerchantOfferAccessor)this.offer).setUses(amount);
                                break;
                            }
                            case 19: {
                                ((MerchantOfferAccessor)this.offer).setMaxUses(amount);
                                break;
                            }
                            case 23: {
                                ((MerchantOfferAccessor)this.offer).setSpecialPriceDiff(amount);
                                break;
                            }
                            case 16: {
                                ((MerchantOfferAccessor)this.offer).setDemand(amount);
                                break;
                            }
                            case 14: {
                                ((MerchantOfferAccessor)this.offer).setXp(amount);
                            }
                        }
                        this.changed = true;
                        TradeEditor.playSongToPlayer(player, SoundEvents.ANVIL_USE, 1.0f, 1.0f);
                    }
                    catch (NumberFormatException e) {
                        TradeEditor.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                    }
                    player.closeContainer();
                    player.getServer().execute(() -> OfferEditor.openGui(player, this.villager, this.offer, this.page, this.currentOffers, this.changed));
                }, () -> {
                    player.closeContainer();
                    player.getServer().execute(() -> OfferEditor.openGui(player, this.villager, this.offer, this.page, this.currentOffers, this.changed));
                    TradeEditor.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                });
                return true;
            }
            case 25: {
                StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                    try {
                        float amount = Float.parseFloat(s);
                        ((MerchantOfferAccessor)this.offer).setPriceMultiplier(amount);
                        this.changed = true;
                        TradeEditor.playSongToPlayer(player, SoundEvents.ANVIL_USE, 1.0f, 1.0f);
                    }
                    catch (NumberFormatException e) {
                        TradeEditor.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                    }
                    player.closeContainer();
                    player.getServer().execute(() -> OfferEditor.openGui(player, this.villager, this.offer, this.page, this.currentOffers, this.changed));
                }, () -> {
                    player.closeContainer();
                    player.getServer().execute(() -> OfferEditor.openGui(player, this.villager, this.offer, this.page, this.currentOffers, this.changed));
                    TradeEditor.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                });
                return true;
            }
            case 12: {
                ((MerchantOfferMixinInterface)this.offer).setInfinite(!((MerchantOfferMixinInterface)this.offer).isInfinite());
                this.changed = true;
                TradeEditor.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
                break;
            }
            case 21: {
                ((MerchantOfferAccessor)this.offer).setRewardExp(!this.offer.shouldRewardExp());
                this.changed = true;
                TradeEditor.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        }
        this.update();
        return true;
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot > 9 && slot < 27;
    }

    @Override
    public TradeEditor.MerchantData getMerchantData() {
        return new TradeEditor.MerchantData(this.villager, this.currentOffers, this.page, this.changed);
    }
}

