/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.villagertrades.gui;

import io.github.flemmli97.villagertrades.gui.inv.SeparateInvImpl;
import io.github.flemmli97.villagertrades.gui.inv.SlotDelegate;
import io.github.flemmli97.villagertrades.mixin.AbstractContainerAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class ServerOnlyScreenHandler
extends AbstractContainerMenu {
    protected final int size;
    private final SeparateInvImpl inventory;

    protected ServerOnlyScreenHandler(int syncId, Inventory playerInventory, int rows) {
        super(ServerOnlyScreenHandler.fromRows(rows), syncId);
        int m;
        int n;
        int i = (rows - 4) * 18;
        this.inventory = new SeparateInvImpl(rows * 9, e -> false);
        this.size = this.inventory.getContainerSize();
        for (n = 0; n < rows; ++n) {
            for (m = 0; m < 9; ++m) {
                this.addSlot(new SlotDelegate(this.inventory, m + n * 9, 8 + m * 18, 18 + n * 18));
            }
        }
        for (n = 0; n < 3; ++n) {
            for (m = 0; m < 9; ++m) {
                this.addSlot(new Slot(this, (Container)playerInventory, m + n * 9 + 9, 8 + m * 18, 103 + n * 18 + i){

                    public boolean mayPlace(ItemStack stack) {
                        return false;
                    }

                    public boolean mayPickup(Player playerEntity) {
                        return false;
                    }
                });
            }
        }
        for (n = 0; n < 9; ++n) {
            this.addSlot(new Slot(this, (Container)playerInventory, n, 8 + n * 18, 161 + i){

                public boolean mayPlace(ItemStack stack) {
                    return false;
                }

                public boolean mayPickup(Player playerEntity) {
                    return false;
                }
            });
        }
    }

    private static MenuType<ChestMenu> fromRows(int rows) {
        return switch (rows) {
            case 2 -> MenuType.GENERIC_9x2;
            case 3 -> MenuType.GENERIC_9x3;
            case 4 -> MenuType.GENERIC_9x4;
            case 5 -> MenuType.GENERIC_9x5;
            case 6 -> MenuType.GENERIC_9x6;
            default -> MenuType.GENERIC_9x1;
        };
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clicked(int i, int mouse, ClickType clickType, Player playerEntity) {
        if (i < 0) {
            return;
        }
        Slot slot = (Slot)this.slots.get(i);
        if (clickType != ClickType.PICKUP_ALL && this.isRightSlot(i)) {
            if (((AbstractContainerAccessor)((Object)this)).containerSync() != null) {
                ((AbstractContainerAccessor)((Object)this)).containerSync().sendCarriedChange((AbstractContainerMenu)this, this.getCarried().copy());
            }
            this.handleSlotClicked((ServerPlayer)playerEntity, i, slot, mouse);
        }
        ItemStack stack = slot.getItem().copy();
        for (ContainerListener listener : ((AbstractContainerAccessor)((Object)this)).listeners()) {
            listener.slotChanged((AbstractContainerMenu)this, i, stack);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        if (index < 0) {
            return ItemStack.EMPTY;
        }
        Slot slot = (Slot)this.slots.get(index);
        if (this.isRightSlot(index)) {
            this.handleSlotClicked((ServerPlayer)player, index, slot, 0);
        }
        return slot.getItem().copy();
    }

    protected abstract boolean isRightSlot(int var1);

    protected abstract boolean handleSlotClicked(ServerPlayer var1, int var2, Slot var3, int var4);
}

