/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.villagertrades.gui;

import io.github.flemmli97.villagertrades.mixin.AbstractContainerAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;

public class StringResultScreenHandler
extends AnvilMenu {
    private final List<ContainerListener> listeners = new ArrayList<ContainerListener>();
    private final Consumer<String> cons;
    private final Runnable ret;
    private boolean init;
    private String name;

    private StringResultScreenHandler(int syncId, Inventory playerInventory, Consumer<String> cons, Runnable ret) {
        super(syncId, playerInventory);
        ItemStack stack = new ItemStack((ItemLike)Items.PAPER);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)""));
        this.inputSlots.setItem(0, stack);
        ItemStack out = new ItemStack((ItemLike)Items.BOOK);
        out.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.string.result").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false))));
        this.resultSlots.setItem(0, out);
        this.cons = cons;
        this.ret = ret;
    }

    public static void createNewStringResult(Player player, final Consumer<String> cons, final Runnable ret) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new StringResultScreenHandler(syncId, inv, cons, ret);
            }

            public Component getDisplayName() {
                return Component.literal((String)"");
            }
        };
        player.openMenu(fac);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    protected boolean mayPickup(Player player, boolean present) {
        return true;
    }

    public void clicked(int i, int j, ClickType actionType, Player playerEntity) {
        if (i < 0 || !(playerEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)playerEntity;
        Slot slot = (Slot)this.slots.get(i);
        if (((AbstractContainerAccessor)((Object)this)).containerSync() != null) {
            ((AbstractContainerAccessor)((Object)this)).containerSync().sendCarriedChange((AbstractContainerMenu)this, this.getCarried().copy());
        }
        if (i == 0) {
            this.ret.run();
        } else if (i == 2) {
            String s;
            String string = s = slot.getItem().has(DataComponents.CUSTOM_NAME) ? ((Component)slot.getItem().get(DataComponents.CUSTOM_NAME)).getString() : "";
            if (!s.isEmpty() && !s.equals("stringScreenReturn")) {
                this.cons.accept(s);
            }
            player.connection.send((Packet)new ClientboundSetExperiencePacket(player.experienceProgress, player.totalExperience, player.experienceLevel));
        }
        this.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        if (!(player instanceof ServerPlayer)) {
            return ItemStack.EMPTY;
        }
        if (index == 0) {
            this.ret.run();
        } else if (index == 2) {
            String s;
            Slot slot = (Slot)this.slots.get(index);
            String string = s = slot.getItem().has(DataComponents.CUSTOM_NAME) ? ((Component)slot.getItem().get(DataComponents.CUSTOM_NAME)).getString() : "";
            if (!s.isEmpty() && !s.equals("villagertrades.gui.string.result")) {
                this.cons.accept(s);
            }
            ((ServerPlayer)player).connection.send((Packet)new ClientboundSetExperiencePacket(player.experienceProgress, player.totalExperience, player.experienceLevel));
        }
        this.broadcastChanges();
        return ItemStack.EMPTY;
    }

    public void broadcastChanges() {
        for (int j = 0; j < this.slots.size(); ++j) {
            ItemStack itemStack = ((Slot)this.slots.get(j)).getItem();
            for (ContainerListener screenHandlerListener : this.listeners) {
                screenHandlerListener.slotChanged((AbstractContainerMenu)this, j, itemStack.copy());
            }
        }
    }

    public void createResultInternal() {
        if (!this.init) {
            this.init = true;
        } else {
            ItemStack out = ((Slot)this.slots.get(2)).getItem();
            if (StringUtils.isBlank((CharSequence)this.name)) {
                out.remove(DataComponents.CUSTOM_NAME);
            } else if (!this.name.equals(out.getHoverName().getString())) {
                out.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.name));
            }
        }
        this.broadcastChanges();
    }

    public boolean setItemName(String string) {
        this.name = string;
        this.createResult();
        return true;
    }
}

