/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.villagertrades.gui;

import io.github.flemmli97.villagertrades.gui.EditableServerOnlyScreenHandler;
import io.github.flemmli97.villagertrades.gui.OfferEditor;
import io.github.flemmli97.villagertrades.gui.VillagerDataEditor;
import io.github.flemmli97.villagertrades.helper.MerchantOfferMixinInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.IntPredicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;

public class TradeEditor
extends EditableServerOnlyScreenHandler {
    public static int OFFERS_PER_PAGE = 8;
    private static final IntPredicate IS_TRADE_SLOT = index -> {
        int mod = index % 9;
        return index <= 54 && index > 17 && mod != 2 && mod != 4 && mod != 7;
    };
    private static final IntPredicate IS_EDIT_SLOT = index -> {
        int mod = index % 9;
        return index > 17 && index < 54 && (mod == 2 || mod == 7);
    };
    private int page;
    private int maxPages;
    private final AbstractVillager villager;
    private List<MerchantOffer> currentOffers;
    private boolean changed;

    protected TradeEditor(int syncId, Inventory playerInventory, AbstractVillager villager) {
        super(syncId, playerInventory, 6, true, IS_TRADE_SLOT);
        this.villager = villager;
        this.updatePage(true);
    }

    public static void openGui(ServerPlayer player, final AbstractVillager villager) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new TradeEditor(syncId, inv, villager);
            }

            public Component getDisplayName() {
                return villager.getDisplayName();
            }
        };
        player.openMenu(fac);
    }

    public static void openFrom(ServerPlayer player, final MerchantDataBacktrack offerEditor) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                MerchantData data = offerEditor.getMerchantData();
                TradeEditor editor = new TradeEditor(syncId, inv, data.villager());
                editor.page = data.page();
                editor.currentOffers = data.currentOffers();
                editor.changed = data.changed;
                editor.updateOfferSlots();
                return editor;
            }

            public Component getDisplayName() {
                return offerEditor.getMerchantData().villager().getDisplayName();
            }
        };
        player.openMenu(fac);
    }

    public static ItemStack emptyFiller() {
        ItemStack stack = new ItemStack((ItemLike)Items.GRAY_STAINED_GLASS_PANE);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)""));
        return stack;
    }

    public static ItemStack tradingFiller() {
        ItemStack stack = new ItemStack((ItemLike)Items.YELLOW_STAINED_GLASS_PANE);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)""));
        return stack;
    }

    public static void playSongToPlayer(ServerPlayer player, SoundEvent event, float vol, float pitch) {
        player.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)event), SoundSource.PLAYERS, player.position().x, player.position().y, player.position().z, vol, pitch, player.level().getRandom().nextLong()));
    }

    public static void playSongToPlayer(ServerPlayer player, Holder<SoundEvent> event, float vol, float pitch) {
        player.connection.send((Packet)new ClientboundSoundPacket(event, SoundSource.PLAYERS, player.position().x, player.position().y, player.position().z, vol, pitch, player.level().getRandom().nextLong()));
    }

    public static OfferState validateTrade(MerchantOffer offer) {
        if (offer == null) {
            return OfferState.NONE;
        }
        return !offer.getBaseCostA().isEmpty() && !offer.getResult().isEmpty() ? OfferState.VALID : OfferState.INVALID;
    }

    public static boolean offerEq(MerchantOffer first, MerchantOffer sec) {
        if (first != null && sec != null) {
            return first.getItemCostA() == sec.getItemCostA() && first.getItemCostB() == sec.getItemCostB() && ItemStack.isSameItemSameComponents((ItemStack)first.getResult(), (ItemStack)sec.getResult());
        }
        return false;
    }

    private static ItemStack offerEditStack(MerchantOffer offer, RegistryAccess registryAccess, OfferState valid) {
        ItemStack stack = new ItemStack((ItemLike)(valid == OfferState.VALID ? Items.LIME_STAINED_GLASS_PANE : Items.ORANGE_STAINED_GLASS_PANE));
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.trade.edit").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.AQUA)));
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        if (valid == OfferState.INVALID) {
            lore.add(Component.translatable((String)"villagertrades.gui.offer.tooltip.invalid").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.DARK_RED)));
        }
        lore.addAll(List.of(((MerchantOfferMixinInterface)offer).isInfinite() ? Component.translatable((String)"villagertrades.gui.trade.edit.infinite").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)) : Component.translatable((String)"villagertrades.gui.trade.edit.uses", (Object[])new Object[]{offer.getUses(), offer.getMaxUses()}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)), Component.translatable((String)"villagertrades.gui.trade.edit.xp", (Object[])new Object[]{offer.shouldRewardExp(), offer.getXp()}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)), Component.translatable((String)"villagertrades.gui.trade.edit.demand", (Object[])new Object[]{offer.getDemand()}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY)), Component.translatable((String)"villagertrades.gui.trade.edit.price", (Object[])new Object[]{Float.valueOf(offer.getPriceMultiplier()), offer.getSpecialPriceDiff()}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY))));
        stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
        stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        return stack;
    }

    private static ItemCost costOf(ItemStack stack) {
        return new ItemCost(stack.getItemHolder(), stack.getCount(), DataComponentExactPredicate.allOf((DataComponentMap)PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)stack.getComponentsPatch())));
    }

    private void updatePage(boolean init) {
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack stack = new ItemStack((ItemLike)Items.BARRIER);
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.close").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i == 4 && this.villager instanceof Villager) {
                ItemStack stack = new ItemStack((ItemLike)Items.SUNFLOWER);
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.villager.edit.data").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i / 9 == 1) {
                ((Slot)this.slots.get(i)).set(TradeEditor.emptyFiller());
                continue;
            }
            if (i <= 17) continue;
            int modI = i % 9;
            if (modI == 4) {
                ((Slot)this.slots.get(i)).set(TradeEditor.emptyFiller());
                continue;
            }
            if (modI == 2 || modI == 7) {
                ((Slot)this.slots.get(i)).set(TradeEditor.tradingFiller());
                continue;
            }
            ((Slot)this.slots.get(i)).set(ItemStack.EMPTY);
        }
        if (init) {
            MerchantOffers offers = this.villager.getOffers();
            this.currentOffers = new ArrayList<MerchantOffer>();
            for (MerchantOffer offer : offers) {
                this.currentOffers.add(offer.copy());
            }
        }
        this.updatePageInfo();
        this.updateOfferSlots();
        this.broadcastChanges();
    }

    protected void updatePageInfo() {
        int offerIdx;
        this.maxPages = this.currentOffers.size() / OFFERS_PER_PAGE - 1;
        int currentEntries = 0;
        for (int i = 0; i < OFFERS_PER_PAGE && (offerIdx = i + OFFERS_PER_PAGE * this.page) < this.currentOffers.size(); ++i) {
            if (TradeEditor.validateTrade(this.currentOffers.get(offerIdx)) != OfferState.VALID) continue;
            ++currentEntries;
        }
        if (currentEntries >= OFFERS_PER_PAGE) {
            ++this.maxPages;
        }
        ItemStack stack = ItemStack.EMPTY;
        if (this.page > 0) {
            stack = new ItemStack((ItemLike)Items.ARROW);
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.previous").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
        }
        ((Slot)this.slots.get(1)).set(stack);
        ItemStack next = ItemStack.EMPTY;
        if (this.page < this.maxPages) {
            next = new ItemStack((ItemLike)Items.ARROW);
            next.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.next").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
        }
        ((Slot)this.slots.get(8)).set(next);
    }

    private void updateOfferSlots() {
        int offerIdx;
        for (int i = 0; i < OFFERS_PER_PAGE && (offerIdx = i + OFFERS_PER_PAGE * this.page) < this.currentOffers.size(); ++i) {
            int firstIdx = this.getTradeStartSlotIndex(i);
            MerchantOffer offer = this.currentOffers.get(offerIdx);
            if (offer != null) {
                ((Slot)this.slots.get(firstIdx)).set(offer.getBaseCostA());
                ((Slot)this.slots.get(firstIdx + 1)).set(offer.getCostB());
                ((Slot)this.slots.get(firstIdx + 2)).set(TradeEditor.offerEditStack(offer, this.villager.level().registryAccess(), TradeEditor.validateTrade(offer)));
                ((Slot)this.slots.get(firstIdx + 3)).set(offer.getResult());
                continue;
            }
            ((Slot)this.slots.get(firstIdx + 2)).set(TradeEditor.tradingFiller());
        }
    }

    public int getTradeStartSlotIndex(int index) {
        int firstIdx = 18 + index * 9;
        if (index > 3) {
            firstIdx = 18 + (index - 4) * 9 + 5;
        }
        return firstIdx;
    }

    private int getOfferIndex(int slotIdx) {
        if (slotIdx < 18) {
            return -1;
        }
        int idx = (slotIdx -= 18) / 9 + OFFERS_PER_PAGE * this.page;
        if (slotIdx % 9 > 4) {
            idx += 4;
        }
        return idx;
    }

    public MerchantOffer getOfferFromSlot(int slotIdx) {
        int offerIndex = this.getOfferIndex(slotIdx);
        if (offerIndex == -1) {
            return null;
        }
        if (offerIndex < this.currentOffers.size()) {
            return this.currentOffers.get(offerIndex);
        }
        return null;
    }

    public void updateOffers() {
        for (int i = 0; i < OFFERS_PER_PAGE; ++i) {
            MerchantOffer offer;
            int offerIdx = i + OFFERS_PER_PAGE * this.page;
            MerchantOffer current = offerIdx >= this.currentOffers.size() ? null : this.currentOffers.get(offerIdx);
            int firstIdx = this.getTradeStartSlotIndex(i);
            ItemStack first = ((Slot)this.slots.get(firstIdx)).getItem();
            ItemStack second = ((Slot)this.slots.get(firstIdx + 1)).getItem();
            ItemStack result = ((Slot)this.slots.get(firstIdx + 3)).getItem();
            if (first.isEmpty() && second.isEmpty() && result.isEmpty()) {
                offer = null;
            } else {
                ItemCost firstCost;
                ItemCost secondCost = null;
                if (!first.isEmpty()) {
                    firstCost = TradeEditor.costOf(first);
                    secondCost = second.isEmpty() ? null : TradeEditor.costOf(second);
                } else {
                    firstCost = TradeEditor.costOf(second);
                }
                offer = current != null ? new MerchantOffer(firstCost, Optional.ofNullable(secondCost), result, current.getUses(), current.getMaxUses(), current.getXp(), current.getPriceMultiplier(), current.getDemand()) : new MerchantOffer(firstCost, Optional.ofNullable(secondCost), result, 0, 4, 0, 0.0f, 0);
            }
            OfferState state = TradeEditor.validateTrade(offer);
            if (state == OfferState.NONE) {
                ((Slot)this.slots.get(firstIdx + 2)).set(TradeEditor.tradingFiller());
            } else {
                ((Slot)this.slots.get(firstIdx + 2)).set(TradeEditor.offerEditStack(offer, this.villager.level().registryAccess(), state));
            }
            if (offerIdx >= this.currentOffers.size()) {
                if (offer == null) continue;
                this.currentOffers.add(offer);
                continue;
            }
            this.currentOffers.set(offerIdx, offer);
        }
        this.updatePageInfo();
        this.broadcastChanges();
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.closeContainer();
            TradeEditor.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (index == 1) {
            --this.page;
            this.updatePage(false);
            TradeEditor.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (index == 8) {
            ++this.page;
            this.updatePage(false);
            TradeEditor.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            VillagerDataEditor.openGui(player, this.villager, this.page, this.currentOffers, this.changed);
            TradeEditor.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (IS_EDIT_SLOT.test(index)) {
            MerchantOffer offer = this.getOfferFromSlot(index);
            if (offer != null) {
                OfferEditor.openGui(player, this.villager, offer, this.page, this.currentOffers, this.changed);
                TradeEditor.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        this.updateOffers();
        return true;
    }

    @Override
    public void onDrag(int mouse, ClickType clickType, Player playerEntity) {
        this.updateOffers();
    }

    public void removed(Player player) {
        super.removed(player);
        this.saveOffers();
    }

    private void saveOffers() {
        MerchantOffers current = this.villager.getOffers();
        MerchantOffers offers = new MerchantOffers();
        for (int i = 0; i < this.currentOffers.size(); ++i) {
            MerchantOffer offer = this.currentOffers.get(i);
            if (i < current.size() && !TradeEditor.offerEq(offer, (MerchantOffer)current.get(i))) {
                this.changed = true;
            }
            if (TradeEditor.validateTrade(offer) != OfferState.VALID) continue;
            offers.add((Object)offer);
        }
        boolean bl = this.changed = this.changed || current.size() != offers.size();
        if (this.changed) {
            this.changed = false;
            AbstractVillager abstractVillager = this.villager;
            if (abstractVillager instanceof Villager) {
                Villager v = (Villager)abstractVillager;
                if (v.getVillagerXp() == 0) {
                    v.setVillagerXp(1);
                }
                if (v.getVillagerData().profession() == VillagerProfession.NONE || v.getVillagerData().profession() == VillagerProfession.NITWIT) {
                    v.setVillagerData(v.getVillagerData().withProfession((HolderGetter.Provider)this.villager.registryAccess(), VillagerProfession.FARMER));
                }
                this.villager.getOffers().clear();
                this.villager.getOffers().addAll((Collection)offers);
            }
        }
    }

    @Override
    protected boolean isRightSlot(int slot, ClickType clickType) {
        if (clickType == ClickType.PICKUP_ALL) {
            return true;
        }
        return slot == 0 || slot == 4 || this.page > 0 && slot == 1 || this.page < this.maxPages && slot == 8 || IS_TRADE_SLOT.test(slot) || IS_EDIT_SLOT.test(slot);
    }

    public static interface MerchantDataBacktrack {
        public MerchantData getMerchantData();
    }

    public static enum OfferState {
        NONE,
        INVALID,
        VALID;

    }

    public record MerchantData(AbstractVillager villager, List<MerchantOffer> currentOffers, int page, boolean changed) {
    }
}

