/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.villagertrades.gui;

import io.github.flemmli97.villagertrades.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.villagertrades.gui.TradeEditor;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class VillagerDataEditor
extends ServerOnlyScreenHandler
implements TradeEditor.MerchantDataBacktrack {
    private static final Comparator<ResourceLocation> RESOURCE_LOCATION_COMPARATOR = (f, s) -> {
        if (f.getNamespace().equals(s.getNamespace())) {
            return f.getPath().compareTo(s.getPath());
        }
        if (f.getNamespace().equals("minecraft")) {
            return -1;
        }
        return f.getNamespace().compareTo(s.getNamespace());
    };
    private final AbstractVillager villager;
    private final int page;
    private final List<MerchantOffer> currentOffers;
    private final boolean changed;
    private int professionIdx = -1;
    private final List<Holder.Reference<VillagerProfession>> professions;

    protected VillagerDataEditor(int syncId, Inventory playerInventory, AbstractVillager villager, int page, List<MerchantOffer> currentOffers, boolean changed) {
        super(syncId, playerInventory, 1);
        this.villager = villager;
        this.page = page;
        this.currentOffers = currentOffers;
        this.changed = changed;
        this.professions = BuiltInRegistries.VILLAGER_PROFESSION.listElements().filter(profession -> !profession.is(VillagerProfession.NONE) && !profession.is(VillagerProfession.NITWIT)).sorted(Comparator.comparing(h -> h.key().location(), RESOURCE_LOCATION_COMPARATOR)).toList();
        AbstractVillager abstractVillager = this.villager;
        if (abstractVillager instanceof Villager) {
            Villager v = (Villager)abstractVillager;
            for (int i = 0; i < this.professions.size(); ++i) {
                if (!this.professions.get(i).is(v.getVillagerData().profession())) continue;
                this.professionIdx = i;
                break;
            }
        }
        this.update();
    }

    public static void openGui(ServerPlayer player, final AbstractVillager villager, final int page, final List<MerchantOffer> currentOffers, final boolean changed) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new VillagerDataEditor(syncId, inv, villager, page, currentOffers, changed);
            }

            public Component getDisplayName() {
                return Component.translatable((String)"villagertrades.gui.villager.edit.data");
            }
        };
        player.openMenu(fac);
    }

    private void update() {
        ItemStack stack = new ItemStack((ItemLike)Items.RED_TERRACOTTA);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.back").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
        ((Slot)this.slots.get(0)).set(stack);
        AbstractVillager abstractVillager = this.villager;
        if (abstractVillager instanceof Villager) {
            Villager v = (Villager)abstractVillager;
            stack = new ItemStack((ItemLike)Items.LECTERN);
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.villager.edit.profession").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GOLD)));
            stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(VillagerDataEditor.with(((VillagerProfession)v.getVillagerData().profession().value()).name(), m -> m.setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GRAY))))));
            ((Slot)this.slots.get(3)).set(stack);
        }
        stack = new ItemStack((ItemLike)Items.REDSTONE_BLOCK);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"villagertrades.gui.villager.edit.reset").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.DARK_RED)));
        ((Slot)this.slots.get(5)).set(stack);
    }

    private static Component with(Component comp, Function<MutableComponent, Component> cons) {
        if (comp instanceof MutableComponent) {
            MutableComponent mut = (MutableComponent)comp;
            return cons.apply(mut);
        }
        return comp;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int mouse) {
        if (index == 0) {
            TradeEditor.openFrom(player, this);
            TradeEditor.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        switch (index) {
            case 3: {
                AbstractVillager abstractVillager = this.villager;
                if (!(abstractVillager instanceof Villager)) break;
                Villager villager = (Villager)abstractVillager;
                TradeEditor.playSongToPlayer(player, SoundEvents.VILLAGER_YES, 1.0f, 1.0f);
                this.professionIdx = (this.professionIdx + 1) % this.professions.size();
                villager.setVillagerData(villager.getVillagerData().withProfession((Holder)this.professions.get(this.professionIdx)));
                villager.setVillagerXp(1);
                this.update();
                return true;
            }
            case 5: {
                this.villager.getOffers().clear();
                AbstractVillager abstractVillager = this.villager;
                if (abstractVillager instanceof Villager) {
                    Villager villager = (Villager)abstractVillager;
                    villager.releasePoi(MemoryModuleType.JOB_SITE);
                    villager.setVillagerData(villager.getVillagerData().withProfession((HolderGetter.Provider)villager.registryAccess(), VillagerProfession.NONE).withLevel(0));
                    villager.setVillagerXp(0);
                    villager.refreshBrain((ServerLevel)villager.level());
                }
                player.closeContainer();
                TradeEditor.playSongToPlayer(player, SoundEvents.VILLAGER_YES, 1.0f, 1.0f);
                return true;
            }
        }
        return true;
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 5;
    }

    @Override
    public TradeEditor.MerchantData getMerchantData() {
        return new TradeEditor.MerchantData(this.villager, this.currentOffers, this.page, this.changed);
    }
}

