/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.villagertrades.gui.inv;

import io.github.flemmli97.villagertrades.gui.inv.SeparateInv;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SeparateInvImpl
extends SimpleContainer
implements SeparateInv {
    private final IntPredicate allowedSlots;

    public SeparateInvImpl(int size, IntPredicate allowedSlots) {
        super(size);
        this.allowedSlots = allowedSlots;
    }

    public ItemStack getItem(int slot) {
        if (this.allowedSlots.test(slot)) {
            return super.getItem(slot);
        }
        return ItemStack.EMPTY;
    }

    public List<ItemStack> removeAllItems() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack removeItem(int slot, int amount) {
        if (this.allowedSlots.test(slot)) {
            return super.removeItem(slot, amount);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemType(Item item, int count) {
        return ItemStack.EMPTY;
    }

    public ItemStack addItem(ItemStack stack) {
        return super.addItem(stack);
    }

    public boolean canAddItem(ItemStack stack) {
        return true;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        if (this.allowedSlots.test(slot)) {
            return super.removeItemNoUpdate(slot);
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
        if (this.allowedSlots.test(slot)) {
            super.setItem(slot, stack);
        }
    }

    public boolean stillValid(Player player) {
        return false;
    }

    @Override
    public void updateStack(int slot, ItemStack stack) {
        super.setItem(slot, stack);
    }

    @Override
    public ItemStack getActualStack(int slot) {
        return super.getItem(slot);
    }
}

