/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.villagertrades.neoforge.data;

import io.github.flemmli97.linguabib.api.ServerLangGen;
import io.github.flemmli97.villagertrades.VillagerTrades;
import io.github.flemmli97.villagertrades.neoforge.data.ENLangGen;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.data.PackOutput;

public abstract class TranslationLangGen
extends ServerLangGen {
    private final Set<String> keys = new HashSet<String>();
    private final ENLangGen enLang;

    public TranslationLangGen(PackOutput output, String locale, ENLangGen enLang) {
        super(output, "villagertrades", locale);
        this.enLang = enLang;
    }

    protected abstract void addTranslationsFor();

    protected final void addTranslations() {
        this.addTranslationsFor();
        this.verify();
    }

    public void add(String key, String value) {
        super.add(key, value);
        this.keys.add(key);
    }

    public void add(String key, String ... lines) {
        super.add(key, lines);
        this.keys.add(key);
    }

    protected void verify() {
        HashSet missing = new HashSet();
        this.enLang.allKeys().forEach(key -> {
            if (!this.keys.contains(key)) {
                missing.add(key);
            }
        });
        if (!missing.isEmpty()) {
            VillagerTrades.LOGGER.error("Missing translation for {}", missing);
        }
    }
}

