/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.villagertrades.gui;

import io.github.flemmli97.villagertrades.gui.EditableServerOnlyScreenHandler;
import io.github.flemmli97.villagertrades.gui.OfferEditor;
import io.github.flemmli97.villagertrades.gui.VillagerDataEditor;
import io.github.flemmli97.villagertrades.helper.MerchantOfferMixinInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.IntPredicate;
import net.minecraft.class_124;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3852;
import net.minecraft.class_3908;
import net.minecraft.class_3988;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9306;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9329;
import net.minecraft.class_9334;
import net.minecraft.class_9335;

public class TradeEditor
extends EditableServerOnlyScreenHandler {
    public static int OFFERS_PER_PAGE = 8;
    private static final IntPredicate IS_TRADE_SLOT = index -> {
        int mod = index % 9;
        return index <= 54 && index > 17 && mod != 2 && mod != 4 && mod != 7;
    };
    private static final IntPredicate IS_EDIT_SLOT = index -> {
        int mod = index % 9;
        return index > 17 && index < 54 && (mod == 2 || mod == 7);
    };
    private int page;
    private int maxPages;
    private final class_3988 villager;
    private List<class_1914> currentOffers;
    private boolean changed;

    protected TradeEditor(int syncId, class_1661 playerInventory, class_3988 villager) {
        super(syncId, playerInventory, 6, true, IS_TRADE_SLOT);
        this.villager = villager;
        this.updatePage(true);
    }

    public static void openGui(class_3222 player, final class_3988 villager) {
        class_3908 fac = new class_3908(){

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new TradeEditor(syncId, inv, villager);
            }

            public class_2561 method_5476() {
                return villager.method_5476();
            }
        };
        player.method_17355(fac);
    }

    public static void openFrom(class_3222 player, final MerchantDataBacktrack offerEditor) {
        class_3908 fac = new class_3908(){

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                MerchantData data = offerEditor.getMerchantData();
                TradeEditor editor = new TradeEditor(syncId, inv, data.villager());
                editor.page = data.page();
                editor.currentOffers = data.currentOffers();
                editor.changed = data.changed;
                editor.updateOfferSlots();
                return editor;
            }

            public class_2561 method_5476() {
                return offerEditor.getMerchantData().villager().method_5476();
            }
        };
        player.method_17355(fac);
    }

    public static class_1799 emptyFiller() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8871);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)""));
        return stack;
    }

    public static class_1799 tradingFiller() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8703);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)""));
        return stack;
    }

    public static void playSongToPlayer(class_3222 player, class_3414 event, float vol, float pitch) {
        player.field_13987.method_14364((class_2596)new class_2767(class_7923.field_41172.method_47983((Object)event), class_3419.field_15248, player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350, vol, pitch, player.method_51469().method_8409().method_43055()));
    }

    public static void playSongToPlayer(class_3222 player, class_6880<class_3414> event, float vol, float pitch) {
        player.field_13987.method_14364((class_2596)new class_2767(event, class_3419.field_15248, player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350, vol, pitch, player.method_51469().method_8409().method_43055()));
    }

    public static OfferState validateTrade(class_1914 offer) {
        if (offer == null) {
            return OfferState.NONE;
        }
        return !offer.method_8246().method_7960() && !offer.method_8250().method_7960() ? OfferState.VALID : OfferState.INVALID;
    }

    public static boolean offerEq(class_1914 first, class_1914 sec) {
        if (first != null && sec != null) {
            return first.method_57556() == sec.method_57556() && first.method_57557() == sec.method_57557() && class_1799.method_31577((class_1799)first.method_8250(), (class_1799)sec.method_8250());
        }
        return false;
    }

    private static class_1799 offerEditStack(class_1914 offer, class_5455 registryAccess, OfferState valid) {
        class_1799 stack = new class_1799((class_1935)(valid == OfferState.VALID ? class_1802.field_8581 : class_1802.field_8761));
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"villagertrades.gui.trade.edit").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1075)));
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        if (valid == OfferState.INVALID) {
            lore.add(class_2561.method_43471((String)"villagertrades.gui.offer.tooltip.invalid").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1079)));
        }
        lore.addAll(List.of(((MerchantOfferMixinInterface)offer).isInfinite() ? class_2561.method_43471((String)"villagertrades.gui.trade.edit.infinite").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1080)) : class_2561.method_43469((String)"villagertrades.gui.trade.edit.uses", (Object[])new Object[]{offer.method_8249(), offer.method_8248()}).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1080)), class_2561.method_43469((String)"villagertrades.gui.trade.edit.xp", (Object[])new Object[]{offer.method_8256(), offer.method_19279()}).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1080)), class_2561.method_43469((String)"villagertrades.gui.trade.edit.demand", (Object[])new Object[]{offer.method_21725()}).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1080)), class_2561.method_43469((String)"villagertrades.gui.trade.edit.price", (Object[])new Object[]{Float.valueOf(offer.method_19278()), offer.method_19277()}).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1080))));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
        stack.method_57379(class_9334.field_49641, (Object)true);
        return stack;
    }

    private static class_9306 costOf(class_1799 stack) {
        return new class_9306(stack.method_41409(), stack.method_7947(), class_9329.method_57865((class_9323)class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)stack.method_57380())));
    }

    private void updatePage(boolean init) {
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8077);
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"villagertrades.gui.close").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (i == 4 && this.villager instanceof class_1646) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_17525);
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"villagertrades.gui.villager.edit.data").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (i / 9 == 1) {
                ((class_1735)this.field_7761.get(i)).method_7673(TradeEditor.emptyFiller());
                continue;
            }
            if (i <= 17) continue;
            int modI = i % 9;
            if (modI == 4) {
                ((class_1735)this.field_7761.get(i)).method_7673(TradeEditor.emptyFiller());
                continue;
            }
            if (modI == 2 || modI == 7) {
                ((class_1735)this.field_7761.get(i)).method_7673(TradeEditor.tradingFiller());
                continue;
            }
            ((class_1735)this.field_7761.get(i)).method_7673(class_1799.field_8037);
        }
        if (init) {
            class_1916 offers = this.villager.method_8264();
            this.currentOffers = new ArrayList<class_1914>();
            for (class_1914 offer : offers) {
                this.currentOffers.add(offer.method_53881());
            }
        }
        this.updatePageInfo();
        this.updateOfferSlots();
        this.method_7623();
    }

    protected void updatePageInfo() {
        int offerIdx;
        this.maxPages = this.currentOffers.size() / OFFERS_PER_PAGE - 1;
        int currentEntries = 0;
        for (int i = 0; i < OFFERS_PER_PAGE && (offerIdx = i + OFFERS_PER_PAGE * this.page) < this.currentOffers.size(); ++i) {
            if (TradeEditor.validateTrade(this.currentOffers.get(offerIdx)) != OfferState.VALID) continue;
            ++currentEntries;
        }
        if (currentEntries >= OFFERS_PER_PAGE) {
            ++this.maxPages;
        }
        class_1799 stack = class_1799.field_8037;
        if (this.page > 0) {
            stack = new class_1799((class_1935)class_1802.field_8107);
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"villagertrades.gui.previous").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
        }
        ((class_1735)this.field_7761.get(1)).method_7673(stack);
        class_1799 next = class_1799.field_8037;
        if (this.page < this.maxPages) {
            next = new class_1799((class_1935)class_1802.field_8107);
            next.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"villagertrades.gui.next").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
        }
        ((class_1735)this.field_7761.get(8)).method_7673(next);
    }

    private void updateOfferSlots() {
        int offerIdx;
        for (int i = 0; i < OFFERS_PER_PAGE && (offerIdx = i + OFFERS_PER_PAGE * this.page) < this.currentOffers.size(); ++i) {
            int firstIdx = this.getTradeStartSlotIndex(i);
            class_1914 offer = this.currentOffers.get(offerIdx);
            if (offer != null) {
                ((class_1735)this.field_7761.get(firstIdx)).method_7673(offer.method_8246());
                ((class_1735)this.field_7761.get(firstIdx + 1)).method_7673(offer.method_8247());
                ((class_1735)this.field_7761.get(firstIdx + 2)).method_7673(TradeEditor.offerEditStack(offer, this.villager.method_37908().method_30349(), TradeEditor.validateTrade(offer)));
                ((class_1735)this.field_7761.get(firstIdx + 3)).method_7673(offer.method_8250());
                continue;
            }
            ((class_1735)this.field_7761.get(firstIdx + 2)).method_7673(TradeEditor.tradingFiller());
        }
    }

    public int getTradeStartSlotIndex(int index) {
        int firstIdx = 18 + index * 9;
        if (index > 3) {
            firstIdx = 18 + (index - 4) * 9 + 5;
        }
        return firstIdx;
    }

    private int getOfferIndex(int slotIdx) {
        if (slotIdx < 18) {
            return -1;
        }
        int idx = (slotIdx -= 18) / 9 + OFFERS_PER_PAGE * this.page;
        if (slotIdx % 9 > 4) {
            idx += 4;
        }
        return idx;
    }

    public class_1914 getOfferFromSlot(int slotIdx) {
        int offerIndex = this.getOfferIndex(slotIdx);
        if (offerIndex == -1) {
            return null;
        }
        if (offerIndex < this.currentOffers.size()) {
            return this.currentOffers.get(offerIndex);
        }
        return null;
    }

    public void updateOffers() {
        for (int i = 0; i < OFFERS_PER_PAGE; ++i) {
            class_1914 offer;
            int offerIdx = i + OFFERS_PER_PAGE * this.page;
            class_1914 current = offerIdx >= this.currentOffers.size() ? null : this.currentOffers.get(offerIdx);
            int firstIdx = this.getTradeStartSlotIndex(i);
            class_1799 first = ((class_1735)this.field_7761.get(firstIdx)).method_7677();
            class_1799 second = ((class_1735)this.field_7761.get(firstIdx + 1)).method_7677();
            class_1799 result = ((class_1735)this.field_7761.get(firstIdx + 3)).method_7677();
            if (first.method_7960() && second.method_7960() && result.method_7960()) {
                offer = null;
            } else {
                class_9306 firstCost;
                class_9306 secondCost = null;
                if (!first.method_7960()) {
                    firstCost = TradeEditor.costOf(first);
                    secondCost = second.method_7960() ? null : TradeEditor.costOf(second);
                } else {
                    firstCost = TradeEditor.costOf(second);
                }
                offer = current != null ? new class_1914(firstCost, Optional.ofNullable(secondCost), result, current.method_8249(), current.method_8248(), current.method_19279(), current.method_19278(), current.method_21725()) : new class_1914(firstCost, Optional.ofNullable(secondCost), result, 0, 4, 0, 0.0f, 0);
            }
            OfferState state = TradeEditor.validateTrade(offer);
            if (state == OfferState.NONE) {
                ((class_1735)this.field_7761.get(firstIdx + 2)).method_7673(TradeEditor.tradingFiller());
            } else {
                ((class_1735)this.field_7761.get(firstIdx + 2)).method_7673(TradeEditor.offerEditStack(offer, this.villager.method_37908().method_30349(), state));
            }
            if (offerIdx >= this.currentOffers.size()) {
                if (offer == null) continue;
                this.currentOffers.add(offer);
                continue;
            }
            this.currentOffers.set(offerIdx, offer);
        }
        this.updatePageInfo();
        this.method_7623();
    }

    @Override
    protected boolean handleSlotClicked(class_3222 player, int index, class_1735 slot, int clickType) {
        if (index == 0) {
            player.method_7346();
            TradeEditor.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 1) {
            --this.page;
            this.updatePage(false);
            TradeEditor.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 8) {
            ++this.page;
            this.updatePage(false);
            TradeEditor.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            VillagerDataEditor.openGui(player, this.villager, this.page, this.currentOffers, this.changed);
            TradeEditor.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (IS_EDIT_SLOT.test(index)) {
            class_1914 offer = this.getOfferFromSlot(index);
            if (offer != null) {
                OfferEditor.openGui(player, this.villager, offer, this.page, this.currentOffers, this.changed);
                TradeEditor.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        this.updateOffers();
        return true;
    }

    @Override
    public void onDrag(int mouse, class_1713 clickType, class_1657 playerEntity) {
        this.updateOffers();
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.saveOffers();
    }

    private void saveOffers() {
        class_1916 current = this.villager.method_8264();
        class_1916 offers = new class_1916();
        for (int i = 0; i < this.currentOffers.size(); ++i) {
            class_1914 offer = this.currentOffers.get(i);
            if (i < current.size() && !TradeEditor.offerEq(offer, (class_1914)current.get(i))) {
                this.changed = true;
            }
            if (TradeEditor.validateTrade(offer) != OfferState.VALID) continue;
            offers.add((Object)offer);
        }
        boolean bl = this.changed = this.changed || current.size() != offers.size();
        if (this.changed) {
            this.changed = false;
            class_3988 class_39882 = this.villager;
            if (class_39882 instanceof class_1646) {
                class_1646 v = (class_1646)class_39882;
                if (v.method_19269() == 0) {
                    v.method_19625(1);
                }
                if (v.method_7231().comp_3521() == class_3852.field_17051 || v.method_7231().comp_3521() == class_3852.field_17062) {
                    v.method_7195(v.method_7231().method_66688((class_7871.class_7872)this.villager.method_56673(), class_3852.field_17056));
                }
                this.villager.method_8264().clear();
                this.villager.method_8264().addAll((Collection)offers);
            }
        }
    }

    @Override
    protected boolean isRightSlot(int slot, class_1713 clickType) {
        if (clickType == class_1713.field_7793) {
            return true;
        }
        return slot == 0 || slot == 4 || this.page > 0 && slot == 1 || this.page < this.maxPages && slot == 8 || IS_TRADE_SLOT.test(slot) || IS_EDIT_SLOT.test(slot);
    }

    public static interface MerchantDataBacktrack {
        public MerchantData getMerchantData();
    }

    public static enum OfferState {
        NONE,
        INVALID,
        VALID;

    }

    public record MerchantData(class_3988 villager, List<class_1914> currentOffers, int page, boolean changed) {
    }
}

