{
  onStart(pokemon) {
    const foeActive = pokemon.side.foe.active;
    for (const target of foeActive) {
      if (!target || !target.isActive || target.fainted) continue;

      this.add("-activate", pokemon, "ability: Divine Dragon’s Aura");
      this.add("-message", "The divine dragon's pressure is too much to bear!");

      const statDrops = ["atk", "def", "spa", "spd", "spe", "accuracy", "evasion"];
      for (const stat of statDrops) {
        this.boost({ [stat]: -1 }, target, pokemon, null, true);
      }

      if (!target.volatiles['trapped']) {
        target.addVolatile('trapped');
        this.add("-message", "The divine pressure prevents escape!");
      }
    }
  },

  onDeductPP(target, source) {
    if (target.isAlly(source)) return;
    return 1;
  },

  onImmunity(type, pokemon) {
    if (type === 'Ground') {
      this.add('-immune', pokemon, '[from] ability: Divine Dragon’s Aura');
      return false;
    }
  },

  onUpdate(pokemon) {
    pokemon.isGrounded = () => false;
  },

  flags: { breakable: 1 },
  name: "Divine Dragon’s Aura",
  rating: 6,
  num: -501
}
