{
  num: 9012,
  accuracy: 100,
  basePower: 30,
  category: "Physical",
  name: "Tri-Head Destruction",
  pp: 5,
  priority: 0,
  flags: { contact: 1, protect: 1, mirror: 1, metronome: 1 },
  type: "Steel",
  target: "normal",
  multihit: [1, 3],
  multiaccuracy: true,

  onPrepareHit(target, source, move) {
    source.addVolatile('triheaddestruction');
    source.volatiles.triheaddestruction.landedHits = 0;
  },

  onHit(target, source, move) {
    if (source.volatiles?.triheaddestruction) {
      source.volatiles.triheaddestruction.landedHits++;
    }
  },

  onAfterMove(source, target, move) {
    const tracker = source.volatiles?.triheaddestruction;
    if (tracker && tracker.landedHits === 3 && !target.fainted) {
      this.add('-message', `${source.name}'s three heads roar in unison! The enemy is annihilated!`);
      target.faint();
    }
    source.removeVolatile('triheaddestruction');
  },

  shortDesc: "Hits 1–3×. If all 3 land, the target faints.",
  desc: "Strikes 1–3 times with brutal steel force. If all three heads land a blow, the opponent is immediately annihilated.",
  contestType: "Tough"
}
