/*
 * Decompiled with CFR 0.152.
 */
package com.tradepinner;

import com.tradepinner.TradeManager;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9306;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class TradeHudRenderer
implements HudRenderCallback {
    private static int closeButtonX;
    private static int closeButtonY;
    private static int closeButtonWidth;
    private static int closeButtonHeight;
    private static int minimizeButtonX;
    private static int minimizeButtonY;
    private static int minimizeButtonWidth;
    private static int minimizeButtonHeight;
    private static int hudX;
    private static int hudY;
    private static class_1799 firstBuyItem;
    private static class_1799 secondBuyItem;
    private static class_1799 sellItem;
    private static int firstItemX;
    private static int firstItemY;
    private static int secondItemX;
    private static int secondItemY;
    private static int sellItemX;
    private static int sellItemY;
    private static int indicatorX;
    private static int indicatorY;
    private static int indicatorWidth;
    private static int indicatorHeight;
    private static boolean isMinimized;

    public void onHudRender(class_332 context, class_9779 tickCounter) {
        class_1914 trade = TradeManager.getPinnedTrade();
        if (trade == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (isMinimized) {
            this.renderMinimizedIndicator(context, client);
        } else {
            this.renderFullHud(context, client, trade);
        }
    }

    private void renderMinimizedIndicator(class_332 context, class_310 client) {
        indicatorX = 10;
        indicatorY = 10;
        indicatorWidth = 80;
        indicatorHeight = 20;
        double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
        double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
        boolean isHovered = mouseX >= (double)indicatorX && mouseX <= (double)(indicatorX + indicatorWidth) && mouseY >= (double)indicatorY && mouseY <= (double)(indicatorY + indicatorHeight);
        int bgColor = isHovered ? -584965598 : -587202560;
        context.method_25294(indicatorX, indicatorY, indicatorX + indicatorWidth, indicatorY + indicatorHeight, bgColor);
        context.method_25294(indicatorX, indicatorY, indicatorX + indicatorWidth, indicatorY + 1, -11184811);
        context.method_25294(indicatorX, indicatorY + indicatorHeight - 1, indicatorX + indicatorWidth, indicatorY + indicatorHeight, -11184811);
        context.method_25294(indicatorX, indicatorY, indicatorX + 1, indicatorY + indicatorHeight, -11184811);
        context.method_25294(indicatorX + indicatorWidth - 1, indicatorY, indicatorX + indicatorWidth, indicatorY + indicatorHeight, -11184811);
        String text = "Trade [+]";
        int textX = indicatorX + (indicatorWidth - client.field_1772.method_1727(text)) / 2;
        Objects.requireNonNull(client.field_1772);
        int textY = indicatorY + (indicatorHeight - 9) / 2;
        context.method_51433(client.field_1772, text, textX, textY, 0xFFFFFF, true);
    }

    private void renderFullHud(class_332 context, class_310 client, class_1914 trade) {
        hudX = 10;
        hudY = 10;
        int width = 200;
        int height = 65;
        context.method_25294(hudX, hudY, hudX + width, hudY + height, -587202560);
        context.method_25294(hudX, hudY, hudX + width, hudY + 1, -11184811);
        context.method_25294(hudX, hudY + height - 1, hudX + width, hudY + height, -11184811);
        context.method_25294(hudX, hudY, hudX + 1, hudY + height, -11184811);
        context.method_25294(hudX + width - 1, hudY, hudX + width, hudY + height, -11184811);
        context.method_51433(client.field_1772, "Pinned Trade", hudX + 5, hudY + 5, 0xFFFFFF, true);
        String minimizeText = "[-]";
        minimizeButtonWidth = client.field_1772.method_1727(minimizeText);
        Objects.requireNonNull(client.field_1772);
        minimizeButtonHeight = 9;
        minimizeButtonX = hudX + width - minimizeButtonWidth - client.field_1772.method_1727("[X]") - 10;
        minimizeButtonY = hudY + 5;
        context.method_51433(client.field_1772, minimizeText, minimizeButtonX, minimizeButtonY, 0xFFAA00, true);
        String closeText = "[X]";
        closeButtonWidth = client.field_1772.method_1727(closeText);
        Objects.requireNonNull(client.field_1772);
        closeButtonHeight = 9;
        closeButtonX = hudX + width - closeButtonWidth - 5;
        closeButtonY = hudY + 5;
        context.method_51433(client.field_1772, closeText, closeButtonX, closeButtonY, 0xFF5555, true);
        firstBuyItem = trade.method_8246();
        firstItemX = hudX + 5;
        firstItemY = hudY + 22;
        context.method_51427(firstBuyItem, firstItemX, firstItemY);
        context.method_51431(client.field_1772, firstBuyItem, firstItemX, firstItemY);
        int firstCount = client.field_1724.method_31548().method_18861(firstBuyItem.method_7909());
        String firstText = firstCount + "/" + firstBuyItem.method_7947();
        int firstColor = firstCount >= firstBuyItem.method_7947() ? 0x55FF55 : 0xFF5555;
        context.method_51433(client.field_1772, firstText, hudX + 25, hudY + 26, firstColor, true);
        int offset = 60;
        boolean secondBuyItemBool = trade.method_57557().isPresent();
        secondBuyItem = secondBuyItemBool ? ((class_9306)trade.method_57557().get()).comp_2427() : null;
        if (secondBuyItemBool) {
            secondItemX = hudX + offset;
            secondItemY = hudY + 22;
            context.method_51427(secondBuyItem, secondItemX, secondItemY);
            context.method_51431(client.field_1772, secondBuyItem, secondItemX, secondItemY);
            int secondCount = client.field_1724.method_31548().method_18861(secondBuyItem.method_7909());
            String secondText = secondCount + "/" + secondBuyItem.method_7947();
            int secondColor = secondCount >= secondBuyItem.method_7947() ? 0x55FF55 : 0xFF5555;
            context.method_51433(client.field_1772, secondText, hudX + offset + 20, hudY + 26, secondColor, true);
            offset += 60;
        } else {
            secondItemX = -1;
            secondItemY = -1;
        }
        context.method_51433(client.field_1772, "->", hudX + offset - 5, hudY + 26, 0xAAAAAA, true);
        sellItem = trade.method_8250();
        sellItemX = hudX + offset + 15;
        sellItemY = hudY + 22;
        context.method_51427(sellItem, sellItemX, sellItemY);
        context.method_51431(client.field_1772, sellItem, sellItemX, sellItemY);
        boolean hasSufficient = TradeManager.hasSufficientItems(trade);
        String statusText = hasSufficient ? "Ready to trade!" : "Need more items";
        int statusColor = hasSufficient ? 0x55FF55 : 0xFF5555;
        context.method_51433(client.field_1772, statusText, hudX + 5, hudY + 48, statusColor, false);
        double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
        double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
        if (this.isMouseOverItem(mouseX, mouseY, firstItemX, firstItemY)) {
            context.method_51446(client.field_1772, firstBuyItem, (int)mouseX, (int)mouseY);
        } else if (secondItemX > 0 && this.isMouseOverItem(mouseX, mouseY, secondItemX, secondItemY)) {
            context.method_51446(client.field_1772, secondBuyItem, (int)mouseX, (int)mouseY);
        } else if (this.isMouseOverItem(mouseX, mouseY, sellItemX, sellItemY)) {
            context.method_51446(client.field_1772, sellItem, (int)mouseX, (int)mouseY);
        }
    }

    private boolean isMouseOverItem(double mouseX, double mouseY, int itemX, int itemY) {
        return mouseX >= (double)itemX && mouseX <= (double)(itemX + 16) && mouseY >= (double)itemY && mouseY <= (double)(itemY + 16);
    }

    public static boolean isMouseOverCloseButton(double mouseX, double mouseY) {
        if (isMinimized) {
            return false;
        }
        return mouseX >= (double)closeButtonX && mouseX <= (double)(closeButtonX + closeButtonWidth) && mouseY >= (double)closeButtonY && mouseY <= (double)(closeButtonY + closeButtonHeight);
    }

    public static boolean isMouseOverMinimizeButton(double mouseX, double mouseY) {
        if (isMinimized) {
            return false;
        }
        return mouseX >= (double)minimizeButtonX && mouseX <= (double)(minimizeButtonX + minimizeButtonWidth) && mouseY >= (double)minimizeButtonY && mouseY <= (double)(minimizeButtonY + minimizeButtonHeight);
    }

    public static boolean isMouseOverIndicator(double mouseX, double mouseY) {
        if (!isMinimized) {
            return false;
        }
        return mouseX >= (double)indicatorX && mouseX <= (double)(indicatorX + indicatorWidth) && mouseY >= (double)indicatorY && mouseY <= (double)(indicatorY + indicatorHeight);
    }

    public static void toggleMinimize() {
        isMinimized = !isMinimized;
    }

    public static void setMinimized(boolean minimized) {
        isMinimized = minimized;
    }

    public static boolean isMinimized() {
        return isMinimized;
    }

    static {
        isMinimized = false;
    }
}

