/*
 * Decompiled with CFR 0.152.
 */
package com.tradepinner;

import com.mojang.serialization.DynamicOps;
import com.tradepinner.TradePinnerClient;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1914;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9306;

@Environment(value=EnvType.CLIENT)
public class TradeManager {
    private static class_1914 pinnedTrade = null;
    private static final String SAVE_FILE = "tradepinner_data.dat";

    public static void pinTrade(class_1914 trade) {
        pinnedTrade = trade;
        if (trade != null) {
            TradePinnerClient.LOGGER.info("Trade pinned!");
            TradeManager.savePinnedTrade();
        }
    }

    public static class_1914 getPinnedTrade() {
        return pinnedTrade;
    }

    public static void clearPinnedTrade() {
        pinnedTrade = null;
        TradeManager.deleteSavedTrade();
    }

    public static boolean hasSufficientItems(class_1914 trade) {
        boolean hasFirst;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || trade == null) {
            return false;
        }
        int firstCount = client.field_1724.method_31548().method_18861(trade.method_8246().method_7909());
        boolean bl = hasFirst = firstCount >= trade.method_8246().method_7947();
        if (trade.method_57557().isEmpty()) {
            return hasFirst;
        }
        int secondCount = client.field_1724.method_31548().method_18861(((class_9306)trade.method_57557().get()).comp_2427().method_7909());
        boolean hasSecond = secondCount >= ((class_9306)trade.method_57557().get()).comp_2425();
        return hasFirst && hasSecond;
    }

    private static void savePinnedTrade() {
        if (pinnedTrade == null) {
            return;
        }
        try {
            class_310 client = class_310.method_1551();
            File saveFile = new File(client.field_1697, SAVE_FILE);
            Path path = saveFile.toPath();
            class_2487 nbt = new class_2487();
            if (client.field_1687 != null) {
                class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)client.field_1687.method_30349());
                class_2520 tradeElement = (class_2520)class_1914.field_48849.encodeStart((DynamicOps)ops, (Object)pinnedTrade).getOrThrow();
                nbt.method_10566("Trade", tradeElement);
            }
            class_2507.method_30614((class_2487)nbt, (Path)path);
            TradePinnerClient.LOGGER.info("Saved pinned trade to file");
        }
        catch (IOException e) {
            TradePinnerClient.LOGGER.error("Failed to save pinned trade", (Throwable)e);
        }
    }

    public static void loadPinnedTrade() {
        try {
            class_310 client = class_310.method_1551();
            File saveFile = new File(client.field_1697, SAVE_FILE);
            if (!saveFile.exists()) {
                return;
            }
            class_2487 nbt = class_2507.method_30613((Path)saveFile.toPath(), (class_2505)class_2505.method_53898());
            if (nbt.method_10545("Trade")) {
                class_2520 tradeElement = nbt.method_10580("Trade");
                if (tradeElement != null && client.field_1687 != null) {
                    class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)client.field_1687.method_30349());
                    pinnedTrade = class_1914.field_48849.parse((DynamicOps)ops, (Object)tradeElement).result().orElse(null);
                }
                TradePinnerClient.LOGGER.info("Loaded pinned trade from file");
            }
        }
        catch (IOException e) {
            TradePinnerClient.LOGGER.error("Failed to load pinned trade", (Throwable)e);
        }
    }

    private static void deleteSavedTrade() {
        try {
            class_310 client = class_310.method_1551();
            File saveFile = new File(client.field_1697, SAVE_FILE);
            if (saveFile.exists()) {
                saveFile.delete();
                TradePinnerClient.LOGGER.info("Deleted saved trade file");
            }
        }
        catch (Exception e) {
            TradePinnerClient.LOGGER.error("Failed to delete saved trade", (Throwable)e);
        }
    }
}

