/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.magmacore.compat;

import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import xxrexraptorxx.magmacore.compat.EMIIntegrationHelper;
import xxrexraptorxx.magmacore.compat.JEIIntegrationHelper;
import xxrexraptorxx.magmacore.compat.REIIntegrationHelper;
import xxrexraptorxx.magmacore.content.ItemHelper;
import xxrexraptorxx.magmacore.main.MagmaCore;
import xxrexraptorxx.magmacore.utils.FormattingHelper;
import xxrexraptorxx.magmacore.utils.MiscUtils;

public class RecipeViewerUtils {
    public static void registerItemInfo(String modId, ItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("ItemStack cannot be empty");
        }
        String name = ItemHelper.getName(stack);
        RecipeViewerUtils.registerListInfo(modId, Collections.singletonList(stack), name);
    }

    public static void registerItemInfo(String modId, Item item) {
        if (item == null) {
            throw new IllegalArgumentException("Item cannot be null");
        }
        RecipeViewerUtils.registerItemInfo(modId, new ItemStack((ItemLike)item));
    }

    public static void registerItemInfo(String modId, Block block) {
        if (block == null) {
            throw new IllegalArgumentException("Block cannot be null");
        }
        RecipeViewerUtils.registerItemInfo(modId, new ItemStack((ItemLike)block));
    }

    public static void registerListInfo(String modId, List<ItemStack> list, String name) {
        if (list.stream().anyMatch(ItemStack::isEmpty)) {
            throw new IllegalArgumentException("List contains empty ItemStacks");
        }
        MutableComponent description = FormattingHelper.setModLangComponent("message", modId, name + ".jei_desc");
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)modId, (String)("info/" + name));
        try {
            if (MiscUtils.isModLoaded("jei")) {
                JEIIntegrationHelper.enqueue(list, (Component)description);
            }
        }
        catch (Exception e) {
            MagmaCore.LOGGER.error("JEI Integration failed: " + e.getMessage());
        }
        try {
            if (MiscUtils.isModLoaded("roughlyenoughitems")) {
                REIIntegrationHelper.enqueue(list, (Component)description);
            }
        }
        catch (Exception e) {
            MagmaCore.LOGGER.error("REI Integration failed: " + e.getMessage());
        }
        try {
            if (MiscUtils.isModLoaded("emi")) {
                EMIIntegrationHelper.enqueue(list, (Component)description, recipeId);
            }
        }
        catch (Exception e) {
            MagmaCore.LOGGER.error("EMI Integration failed: " + e.getMessage());
        }
    }
}

