/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.magmacore.config;

import javax.annotation.Nullable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import xxrexraptorxx.magmacore.config.Config;
import xxrexraptorxx.magmacore.config.ConfigCategories;
import xxrexraptorxx.magmacore.main.MagmaCore;

public class ConfigHelper {
    public static void setCategory(ModConfigSpec.Builder builder, String name) {
        builder.push(name).comment(Character.toUpperCase(name.charAt(0)) + name.substring(1));
    }

    public static void setCategory(ModConfigSpec.Builder builder, ConfigCategories category) {
        String name = category.getCategoryName();
        builder.push(name).comment(Character.toUpperCase(name.charAt(0)) + name.substring(1)).translation(category.getCategoryLangTag());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerIngameConfig(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    public static void registerConfigs(ModContainer container, String modId, boolean withFolder, @Nullable ModConfigSpec serverConfig, @Nullable ModConfigSpec clientConfig, @Nullable ModConfigSpec commonConfig, @Nullable ModConfigSpec startupConfig) {
        Object path = modId;
        if (withFolder) {
            path = modId + "/" + modId;
        }
        if (serverConfig != null) {
            container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverConfig, (String)path + "-server.toml");
        }
        if (clientConfig != null) {
            container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientConfig, (String)path + "-client.toml");
        }
        if (commonConfig != null) {
            container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonConfig, (String)path + "-common.toml");
        }
        if (startupConfig != null) {
            container.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)startupConfig, (String)path + "-startup.toml");
        }
        if (Config.getDebugMode()) {
            MagmaCore.LOGGER.info("Configs registered for " + modId);
        }
    }

    public static void registerConfigs(ModContainer container, String modId, boolean withFolder, @Nullable ModConfigSpec serverConfig, @Nullable ModConfigSpec clientConfig) {
        ConfigHelper.registerConfigs(container, modId, withFolder, serverConfig, clientConfig, null, null);
    }

    public static boolean isDebugGlobalModeEnabled(boolean modSpecificDebugMode) {
        return Config.getDebugMode() || modSpecificDebugMode;
    }
}

