/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.magmacore.config;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public class ConfigListHelper {
    public static boolean hasValidProbabilityFormat(String input) {
        if (input == null || input.trim().isEmpty() || !input.contains("-")) {
            return false;
        }
        try {
            int lastDashIndex = input.trim().lastIndexOf("-");
            if (lastDashIndex <= 0 || lastDashIndex >= input.trim().length() - 1) {
                return false;
            }
            String probabilityPart = input.trim().substring(lastDashIndex + 1);
            double probability = Double.parseDouble(probabilityPart);
            return probability >= 0.0 && probability <= 1.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String extractId(String input) {
        if (!ConfigListHelper.hasValidProbabilityFormat(input)) {
            return null;
        }
        int lastDashIndex = input.trim().lastIndexOf("-");
        return input.trim().substring(0, lastDashIndex);
    }

    public static double extractProbability(String input) {
        if (!ConfigListHelper.hasValidProbabilityFormat(input)) {
            return -1.0;
        }
        try {
            int lastDashIndex = input.trim().lastIndexOf("-");
            String probabilityPart = input.trim().substring(lastDashIndex + 1);
            return Double.parseDouble(probabilityPart);
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    public static boolean isValidEntity(String entityString) {
        if (entityString == null || entityString.trim().isEmpty() || !entityString.contains(":")) {
            return false;
        }
        try {
            ResourceLocation location = ResourceLocation.parse((String)entityString.trim());
            return BuiltInRegistries.ENTITY_TYPE.containsKey(location);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidEntityWithProbability(String input) {
        if (!input.contains(":") || !ConfigListHelper.hasValidProbabilityFormat(input)) {
            return false;
        }
        String entityId = ConfigListHelper.extractId(input);
        return entityId != null && ConfigListHelper.isValidEntity(entityId);
    }

    public static boolean isValidBlock(String blockString) {
        if (blockString == null || blockString.trim().isEmpty() || !blockString.contains(":")) {
            return false;
        }
        try {
            ResourceLocation location = ResourceLocation.parse((String)blockString.trim());
            return BuiltInRegistries.BLOCK.containsKey(location);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidBlockWithProbability(String input) {
        if (!input.contains(":") || !ConfigListHelper.hasValidProbabilityFormat(input)) {
            return false;
        }
        String blockId = ConfigListHelper.extractId(input);
        return blockId != null && ConfigListHelper.isValidBlock(blockId);
    }

    public static boolean isValidItem(String itemString) {
        if (itemString == null || itemString.trim().isEmpty() || !itemString.contains(":")) {
            return false;
        }
        try {
            ResourceLocation location = ResourceLocation.parse((String)itemString.trim());
            return BuiltInRegistries.ITEM.containsKey(location);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidItemWithProbability(String input) {
        if (!input.contains(":") || !ConfigListHelper.hasValidProbabilityFormat(input)) {
            return false;
        }
        String itemId = ConfigListHelper.extractId(input);
        return itemId != null && ConfigListHelper.isValidItem(itemId);
    }
}

