/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.magmacore.content;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemHelper {
    public static final Set<String> TOOL_KEYWORDS = Set.of("pickaxe", "axe", "sword", "shovel", "hoe");

    public static ResourceKey<Item> getKey(String modId, String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)name));
    }

    public static String getPath(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    public static String getPath(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
    }

    public static ResourceKey<Item> getPath(String modId, String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)name));
    }

    public static ResourceLocation getLocation(String modId, String name) {
        return ResourceLocation.fromNamespaceAndPath((String)modId, (String)name);
    }

    public static String getName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    public static String getName(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
    }

    public static String getId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getNamespace();
    }

    public static String getId(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace();
    }

    public static boolean isToolType(String path) {
        return TOOL_KEYWORDS.stream().anyMatch(path::contains);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isToolType(Item item, @Nullable Boolean withNameCheck) {
        boolean hasToolComponent = item.components().has(DataComponents.TOOL);
        if (!Boolean.TRUE.equals(withNameCheck)) return hasToolComponent;
        String path = ItemHelper.getPath(item);
        if (!hasToolComponent) return false;
        if (!TOOL_KEYWORDS.stream().anyMatch(path::contains)) return false;
        return true;
    }
}

