/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.magmacore.content.items;

import com.mojang.authlib.GameProfile;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import xxrexraptorxx.magmacore.main.MagmaCore;
import xxrexraptorxx.magmacore.utils.FormattingHelper;

public class RewardItems {
    public static ItemStack getCertificate() {
        ItemStack certificate = new ItemStack((ItemLike)Items.PAPER);
        certificate.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        certificate.set(DataComponents.RARITY, (Object)Rarity.EPIC);
        certificate.set(DataComponents.CUSTOM_NAME, (Object)FormattingHelper.setCoreLangComponent("item", "certificate", ChatFormatting.GOLD));
        certificate.set(DataComponents.LORE, (Object)new ItemLore(List.of(FormattingHelper.setCoreLangComponent("item", "certificate.lore", ChatFormatting.YELLOW).append((Component)Component.literal((String)"\n- XxRexRaptorxX").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY)))));
        return certificate;
    }

    public static ItemStack getPlayerHead(Player player) {
        ItemStack reward = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        GameProfile profile = new GameProfile(player.getUUID(), player.getName().getString());
        reward.set(DataComponents.PROFILE, (Object)new ResolvableProfile(profile));
        return reward;
    }

    public static ItemStack getChestplate(Level level, Player player) {
        ItemStack reward = new ItemStack((ItemLike)Items.IRON_CHESTPLATE);
        try {
            Registry lookupTrimMaterials = level.registryAccess().lookupOrThrow(Registries.TRIM_MATERIAL);
            Registry lookupTrimPatterns = level.registryAccess().lookupOrThrow(Registries.TRIM_PATTERN);
            reward.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)lookupTrimMaterials.getOrThrow(TrimMaterials.NETHERITE), (Holder)lookupTrimPatterns.getOrThrow(TrimPatterns.SILENCE)));
            reward.set(DataComponents.RARITY, (Object)Rarity.EPIC);
            reward.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            reward.set(DataComponents.CUSTOM_NAME, (Object)FormattingHelper.setCoreLangComponent("item", "legendary_chestplate", ChatFormatting.GOLD));
            reward.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.empty(), FormattingHelper.setCoreLangComponent("item", "legendary_chestplate.lore").append(player.getName().getString()))));
        }
        catch (IllegalStateException e) {
            MagmaCore.LOGGER.error("Failed to create ArmorTrim for reward: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            MagmaCore.LOGGER.error("Unexpected error in getArmor(): {}", (Object)e.getMessage(), (Object)e);
        }
        return reward;
    }

    public static ItemStack getLeggings(Level level, Player player) {
        ItemStack reward = new ItemStack((ItemLike)Items.IRON_LEGGINGS);
        try {
            Registry lookupTrimMaterials = level.registryAccess().lookupOrThrow(Registries.TRIM_MATERIAL);
            Registry lookupTrimPatterns = level.registryAccess().lookupOrThrow(Registries.TRIM_PATTERN);
            reward.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)lookupTrimMaterials.getOrThrow(TrimMaterials.NETHERITE), (Holder)lookupTrimPatterns.getOrThrow(TrimPatterns.DUNE)));
            reward.set(DataComponents.RARITY, (Object)Rarity.EPIC);
            reward.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            reward.set(DataComponents.CUSTOM_NAME, (Object)FormattingHelper.setCoreLangComponent("item", "legendary_leggings", ChatFormatting.GOLD));
            reward.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.empty(), FormattingHelper.setCoreLangComponent("item", "legendary_leggings.lore").append(player.getName().getString()))));
        }
        catch (IllegalStateException e) {
            MagmaCore.LOGGER.error("Failed to create ArmorTrim for reward: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            MagmaCore.LOGGER.error("Unexpected error in getArmor(): {}", (Object)e.getMessage(), (Object)e);
        }
        return reward;
    }
}

