/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.magmacore.datagen;

import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetLoreFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import xxrexraptorxx.magmacore.utils.FormattingHelper;

public class LootUtils {
    public static LootItemFunction.Builder setItemName(String name) {
        return SetNameFunction.setName((Component)FormattingHelper.setCoreLangComponent("item", name), (SetNameFunction.Target)SetNameFunction.Target.ITEM_NAME);
    }

    public static LootItemFunction.Builder setItemName(String name, ChatFormatting formatting) {
        return SetNameFunction.setName((Component)FormattingHelper.setCoreLangComponent("item", name).withStyle(formatting), (SetNameFunction.Target)SetNameFunction.Target.ITEM_NAME);
    }

    public static LootItemFunction.Builder setLore(String name) {
        return new SetLoreFunction.Builder().addLine((Component)FormattingHelper.setCoreLangComponent("lore", name));
    }

    public static LootItemFunction.Builder setLore(String name, ChatFormatting formatting) {
        return new SetLoreFunction.Builder().addLine((Component)FormattingHelper.setCoreLangComponent("lore", name).withStyle(formatting));
    }

    public static LootItemFunction.Builder setCount(int min, int max) {
        return SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max));
    }

    public static LootItemFunction.Builder setCount(int count) {
        return SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)count));
    }

    public static LootItemFunction.Builder setDamage() {
        return LootUtils.setDamage(0.2f, 0.7f);
    }

    public static LootItemFunction.Builder setDamage(float min, float max) {
        return SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)min, (float)max));
    }

    public static LootItemFunction.Builder setEnchantment(ResourceKey<Enchantment> enchantment, HolderLookup.RegistryLookup<Enchantment> lookup) {
        return LootUtils.setEnchantment(enchantment, 1, lookup);
    }

    public static LootItemFunction.Builder setEnchantment(ResourceKey<Enchantment> enchantment, Integer level, HolderLookup.RegistryLookup<Enchantment> lookup) {
        return new SetEnchantmentsFunction.Builder(false).withEnchantment((Holder)lookup.getOrThrow(enchantment), (NumberProvider)ConstantValue.exactly((float)level.intValue()));
    }

    public static LootItemFunction.Builder setEnchantment(ResourceKey<Enchantment> enchantment, Integer minLevel, Integer maxLevel, HolderLookup.RegistryLookup<Enchantment> lookup) {
        return new SetEnchantmentsFunction.Builder(false).withEnchantment((Holder)lookup.getOrThrow(enchantment), (NumberProvider)UniformGenerator.between((float)minLevel.intValue(), (float)maxLevel.intValue()));
    }

    public static LootItemFunction.Builder setAttribute(Holder<Attribute> attribute, AttributeModifier.Operation operation, NumberProvider value, EquipmentSlotGroup slots) {
        return SetAttributesFunction.setAttributes().withModifier(new SetAttributesFunction.ModifierBuilder(ResourceLocation.parse((String)attribute.getRegisteredName()), attribute, operation, value).forSlot(slots));
    }

    public static LootItemFunction.Builder setGlint(boolean value) {
        return SetComponentsFunction.setComponent((DataComponentType)DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)value);
    }

    public static LootItemFunction.Builder setArmorTrim(ResourceKey<TrimMaterial> material, ResourceKey<TrimPattern> pattern, HolderLookup.RegistryLookup<TrimMaterial> materialLookup, HolderLookup.RegistryLookup<TrimPattern> patternLookup) {
        return SetComponentsFunction.setComponent((DataComponentType)DataComponents.TRIM, (Object)new ArmorTrim((Holder)materialLookup.getOrThrow(material), (Holder)patternLookup.getOrThrow(pattern)));
    }

    public static LootItemFunction.Builder setColor(int rgb) {
        return SetComponentsFunction.setComponent((DataComponentType)DataComponents.DYED_COLOR, (Object)new DyedItemColor(rgb));
    }
}

