/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.magmacore.utils;

import com.mojang.logging.LogUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import xxrexraptorxx.magmacore.config.Config;
import xxrexraptorxx.magmacore.utils.FormattingHelper;

public class ChatLogAppender
extends AbstractAppender {
    protected ChatLogAppender(String name, Filter filter, Layout<?> layout) {
        super(name, filter, layout, false);
    }

    public void append(LogEvent event) {
        if (Config.getIngameLogs()) {
            String loggerName = event.getLoggerName();
            String msg = event.getMessage().getFormattedMessage();
            Level level = event.getLevel();
            if (msg != null && !msg.isEmpty() && (Config.getShowAllLogs() || loggerName.contains("xxrexraptorxx"))) {
                Minecraft mc = Minecraft.getInstance();
                if (mc.player != null) {
                    mc.player.displayClientMessage((Component)Component.literal((String)"[Log] ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)("[" + loggerName + "] ")).withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)msg).withStyle(FormattingHelper.getDebugColor(level))), false);
                }
            }
        }
    }

    public static void register() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        ChatLogAppender appender = new ChatLogAppender("ChatAppender", null, null);
        appender.start();
        config.addAppender((Appender)appender);
        LoggerConfig rootLoggerConfig = config.getLoggerConfig(LogUtils.getLogger().getName());
        rootLoggerConfig.addAppender((Appender)appender, Level.ALL, null);
        ctx.updateLoggers();
    }
}

