/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.magmacore.utils;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import xxrexraptorxx.magmacore.utils.FormattingHelper;

public class EffectHelper {
    @Nullable
    public static MobEffectInstance getOptionalEffect(String effectId, int duration, int amplifier, @Nullable Holder<MobEffect> alternativeEffect) {
        if (effectId == null) {
            return null;
        }
        for (MobEffect effect : BuiltInRegistries.MOB_EFFECT) {
            ResourceLocation key = BuiltInRegistries.MOB_EFFECT.getKey((Object)effect);
            if (key == null || !key.getPath().equals(effectId)) continue;
            return new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), duration, amplifier);
        }
        if (alternativeEffect == null) {
            return null;
        }
        return new MobEffectInstance(alternativeEffect, duration, amplifier);
    }

    @Nullable
    public static MobEffectInstance getOptionalEffect(String effectId, String alternativeEffectId, int duration, int amplifier, @Nullable Holder<MobEffect> fallbackEffect) {
        if (effectId == null && alternativeEffectId == null) {
            return null;
        }
        for (MobEffect effect : BuiltInRegistries.MOB_EFFECT) {
            ResourceLocation key = BuiltInRegistries.MOB_EFFECT.getKey((Object)effect);
            if (key != null && key.getPath().equals(effectId)) {
                return new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), duration, amplifier);
            }
            if (key == null || !key.getPath().equals(alternativeEffectId)) continue;
            return new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), duration, amplifier);
        }
        if (fallbackEffect == null) {
            return null;
        }
        return new MobEffectInstance(fallbackEffect, duration, amplifier);
    }

    public static ChatFormatting getEffectCategoryColor(MobEffect effect) {
        return FormattingHelper.getEffectCategoryColor(effect);
    }
}

