/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.magmacore.utils;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import org.apache.logging.log4j.Level;

public class FormattingHelper {
    public static final String lineSeperator = "\n";
    public static final String textSeperator = ": ";
    public static final String nameSeperator = "_";
    public static final String separator = ".";

    public static String transformRegistryNames(String registry_name) {
        if (registry_name == null || registry_name.isEmpty()) {
            return registry_name;
        }
        registry_name = registry_name.replace('_', ' ');
        String[] words = registry_name.split(" ");
        StringBuilder capitalizedString = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            capitalizedString.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return capitalizedString.toString().trim();
    }

    public static String capitalizeWords(String string) {
        return FormattingHelper.transformRegistryNames(string);
    }

    public static String setCoreTagPrefix(String prefix) {
        return prefix + ".magmacore.";
    }

    public static String setMCLangTagPrefix(String prefix) {
        return prefix + ".minecraft.";
    }

    public static String setLangTagPrefix(String prefix, String modId) {
        return prefix + separator + modId + separator;
    }

    public static String setCoreLangTag(String prefix, String suffix) {
        return prefix + ".magmacore." + suffix;
    }

    public static String setCoreLangTag(String suffix) {
        return "magmacore." + suffix;
    }

    public static String setMCLangTag(String prefix, String suffix) {
        return prefix + ".minecraft." + suffix;
    }

    public static String setLangTag(String prefix, String modId, String suffix) {
        return prefix + separator + modId + separator + suffix;
    }

    public static MutableComponent setCoreLangComponent(String prefix, String suffix) {
        return Component.translatable((String)FormattingHelper.setCoreLangTag(prefix, suffix));
    }

    public static MutableComponent setCoreLangComponent(String prefix, String suffix, ChatFormatting formatting) {
        return Component.translatable((String)FormattingHelper.setCoreLangTag(prefix, suffix)).withStyle(formatting);
    }

    public static MutableComponent setCoreLangComponent(String suffix) {
        return Component.translatable((String)FormattingHelper.setCoreLangTag(suffix));
    }

    public static MutableComponent setCoreLangComponent(String suffix, ChatFormatting formatting) {
        return Component.translatable((String)FormattingHelper.setCoreLangTag(suffix)).withStyle(formatting);
    }

    public static MutableComponent setModLangComponent(String prefix, String modId, String suffix) {
        return Component.translatable((String)FormattingHelper.setLangTag(prefix, modId, suffix));
    }

    public static MutableComponent setModLangComponent(String prefix, String modId, String suffix, ChatFormatting formatting) {
        return Component.translatable((String)FormattingHelper.setLangTag(prefix, modId, suffix)).withStyle(formatting);
    }

    public static MutableComponent setLangComponent(String modId, String suffix) {
        return Component.translatable((String)(modId + separator + suffix));
    }

    public static MutableComponent setLangComponent(String modId, String suffix, ChatFormatting formatting) {
        return Component.translatable((String)(modId + separator + suffix)).withStyle(formatting);
    }

    public static Component setExpandableTooltip(Component normal, Component expanded) {
        return Screen.hasShiftDown() ? expanded : normal;
    }

    public static double ConvertDecimalToPercentage(double decimal) {
        return decimal > 1.0 ? 100.0 : decimal * 100.0;
    }

    public static ChatFormatting getDebugColor(Level level) {
        if (level == Level.ERROR) {
            return ChatFormatting.RED;
        }
        if (level == Level.FATAL) {
            return ChatFormatting.DARK_RED;
        }
        if (level == Level.DEBUG) {
            return ChatFormatting.AQUA;
        }
        if (level == Level.TRACE) {
            return ChatFormatting.AQUA;
        }
        if (level == Level.WARN) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.YELLOW;
    }

    public static ChatFormatting getEffectCategoryColor(MobEffect effect) {
        if (effect.getCategory().equals((Object)MobEffectCategory.HARMFUL)) {
            return ChatFormatting.DARK_RED;
        }
        if (effect.getCategory().equals((Object)MobEffectCategory.BENEFICIAL)) {
            return ChatFormatting.GREEN;
        }
        return ChatFormatting.YELLOW;
    }
}

