/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.magmacore.world;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import xxrexraptorxx.magmacore.config.Config;
import xxrexraptorxx.magmacore.content.items.RewardItems;
import xxrexraptorxx.magmacore.main.MagmaCore;
import xxrexraptorxx.magmacore.main.ModRegistry;
import xxrexraptorxx.magmacore.utils.FormattingHelper;

@EventBusSubscriber(modid="magmacore", bus=EventBusSubscriber.Bus.GAME)
public class Events {
    private static final Map<String, Boolean> shownMap = new HashMap<String, Boolean>();
    private static boolean hasShownUp = false;
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    public static URI supporterList = URI.create("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Supporter");
    public static URI premiumSupporterList = URI.create("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Premium%20Supporter");
    public static URI eliteSupporterList = URI.create("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Elite");
    public static Set<String> supporterSet = new HashSet<String>();

    @SubscribeEvent
    public static void UpdateChecker(ClientTickEvent.Pre event) {
        if (Minecraft.getInstance().screen != null || !Config.getUpdateChecker() || hasShownUp) {
            return;
        }
        for (ModRegistry.ModEntry entry : ModRegistry.getEntries()) {
            ModContainer modContainer;
            LocalPlayer player;
            if (Config.getDebugMode()) {
                MagmaCore.LOGGER.info("Update-Checker for " + entry.modName() + " is running!");
            }
            if (shownMap.getOrDefault(entry.modId(), false).booleanValue() || Config.getUpdateCheckerBlacklist().contains(entry.modId()) || (player = Minecraft.getInstance().player) == null || (modContainer = (ModContainer)ModList.get().getModContainerById(entry.modId()).orElse(null)) == null) continue;
            VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)modContainer.getModInfo());
            switch (result.status()) {
                case OUTDATED: 
                case BETA_OUTDATED: {
                    MutableComponent msg = FormattingHelper.setCoreLangComponent("message.update_available", entry.modName()).withStyle(style -> style.withColor(ChatFormatting.BLUE));
                    MutableComponent link = FormattingHelper.setCoreLangComponent("message.update_link").withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(entry.updateUrl()))).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)FormattingHelper.setCoreLangComponent("message.official", ChatFormatting.GOLD))));
                    player.displayClientMessage((Component)msg, false);
                    player.displayClientMessage((Component)link, false);
                    shownMap.put(entry.modId(), true);
                    break;
                }
                case FAILED: {
                    MagmaCore.LOGGER.error("Update-Checker for {} is failed!", (Object)entry.modName());
                    shownMap.put(entry.modId(), true);
                    break;
                }
            }
        }
        if (Config.getDebugMode()) {
            MagmaCore.LOGGER.info("All updates checked!");
        }
        hasShownUp = true;
    }

    @SubscribeEvent
    public static void DistributeSupporterRewards(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (Config.getSupporterRewards()) {
            ServerPlayer serverPlayer;
            if (Config.getDebugMode()) {
                MagmaCore.LOGGER.info("Supporter rewards will be distributed!");
            }
            if (!player.getInventory().contains(RewardItems.getCertificate()) && player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).getStats().getValue(Stats.CUSTOM, (Object)Stats.PLAY_TIME) < 5) {
                boolean isDev = player.getName().getString().equals("Dev");
                CompletableFuture.runAsync(() -> {
                    if (Events.SupporterCheck(supporterList, player) || Config.getDebugMode() && isDev) {
                        Events.giveSupporterReward(player, level);
                    }
                    if (Events.SupporterCheck(premiumSupporterList, player) || Config.getDebugMode() && isDev) {
                        Events.givePremiumSupporterReward(player, level);
                    }
                    if (Events.SupporterCheck(eliteSupporterList, player) || Config.getDebugMode() && isDev) {
                        Events.giveEliteReward(player, level);
                    }
                });
            }
        }
    }

    private static boolean SupporterCheck(URI uri, Player player) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            List<String> supporterList = List.of(response.body().split("\\R"));
            return supporterList.contains(player.getName().getString());
        }
        catch (Exception e) {
            MagmaCore.LOGGER.error("Failed to fetch or process supporter list from URI: {}", (Object)uri, (Object)e);
            return false;
        }
    }

    private static void giveSupporterReward(Player player, Level level) {
        if (Config.getDebugMode()) {
            MagmaCore.LOGGER.info("Supporter found! " + String.valueOf(player.getDisplayName()));
        }
        level.playSound(null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.15f + 0.8f);
        player.getInventory().add(RewardItems.getPlayerHead(player));
        player.getInventory().add(RewardItems.getCertificate());
    }

    private static void givePremiumSupporterReward(Player player, Level level) {
        if (Config.getDebugMode()) {
            MagmaCore.LOGGER.info("Premium Supporter found! " + String.valueOf(player.getDisplayName()));
        }
        player.getInventory().add(RewardItems.getLeggings(level, player));
    }

    private static void giveEliteReward(Player player, Level level) {
        if (Config.getDebugMode()) {
            MagmaCore.LOGGER.info("Elite Supporter found! " + String.valueOf(player.getDisplayName()));
        }
        player.getInventory().add(RewardItems.getChestplate(level, player));
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        CompletableFuture.runAsync(() -> {
            supporterSet = Events.fetchList(supporterList);
            if (Config.getDebugMode()) {
                MagmaCore.LOGGER.info("Loaded supporter: {}", (Object)supporterSet.size());
            }
        });
    }

    private static Set<String> fetchList(URI uri) {
        try {
            HttpResponse<String> resp = HTTP_CLIENT.send(HttpRequest.newBuilder(uri).GET().build(), HttpResponse.BodyHandlers.ofString());
            return new HashSet<String>(List.of(resp.body().split("\\R")));
        }
        catch (Exception ex) {
            MagmaCore.LOGGER.error("Error while loading: {}", (Object)ex.getMessage());
            return Set.of();
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (Config.getSupporterHighlights()) {
            Player player = event.getEntity();
            Level level = player.level();
            boolean isDev = player.getName().getString().equals("Dev");
            if (!level.isClientSide() && supporterSet.contains(event.getEntity().getUUID().toString()) || Config.getDebugMode() && isDev) {
                Vec3 pos = player.position();
                double d0 = pos.x + (double)(level.random.nextFloat() - 0.5f);
                double d1 = pos.y + (double)(level.random.nextFloat() * 1.5f - 0.75f);
                double d2 = pos.z + (double)(level.random.nextFloat() - 0.5f);
                level.addParticle((ParticleOptions)ParticleTypes.GLOW, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    @SubscribeEvent
    public static void showStopModRepostsMessage(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.getServer().isDedicatedServer()) {
            return;
        }
        Path configDir = FMLPaths.CONFIGDIR.get();
        Path marker = configDir.resolve("#STOP_MOD_REPOSTS.txt");
        try {
            if (Files.notExists(marker, new LinkOption[0])) {
                String fileContent = "    Sites like 9minecraft.net, mc-mod.net, and many others, are known for reuploading mod files without permission from the authors. These sites will also contain a bunch of ads, to try to make money from mods they did not create.\n\n    These sites will use various methods to appear higher in Google when you search for the mod name, so a lot of people will download mods from them instead of the proper place. If you were linked to this site, you're one of these people.\n\n    FOR YOU, AS A PLAYER, THIS CAN MEAN ANY OF THE FOLLOWING:\n    > Getting versions of the mods advertised for the wrong Minecraft versions, which will 100% crash when you load them.\n    > Getting old, and broken, versions of the mods, possibly causing problems in your game.\n    > Getting modified versions of the mods, which may contain malware and viruses.\n    > Having your information stolen from malicious ads in the sites.\n    > Taking money and views away from the official authors, which may cause them to stop making new mods.\n\n    WHAT DO I DO NOW?\n    The most important thing to do now is to make sure you stop visiting these sites, and get the mods from official sources. We also recommend you do the following:\n\n    > Delete all the mods you've downloaded from these sites.\n    > Install the StopModReposts plugin, which makes sure you never visit them again.\n    > Run a virus/malware scan. We recommend MalwareBytes.\n    > Check out the #StopModReposts campaign, that tries to put an end to these sites. (https://stopmodreposts.org/)\n    > Spread the word. If you have any friends that use these sites, inform them to keep them safe.\n\n    WHERE DO I GET MODS NOW?\n    Here's a bunch of links to places where you can download official versions of mods, hosted by their real authors:\n\n    > CurseForge, where most modders host their mods. If it exists, it's probably there.\n    > Modrinth, a new hosting platform for mods that's also legit and more popular by the day.\n    > OptiFine.net, the official OptiFine site.\n    > Neoforged.net, which you need for any other Neoforge mods.\n    > FabricMC.net, which you need for any other Fabric mods.\n    > MinecraftForge Files, which you need for any other Forge mods.\n\n    This doesn't mean other sites aren't legit. In general, the first place to look for a mod is CurseForge and Modrinth, so look there first.\n\n    FAQ\n    Q: What if I've never had problems before?\n    > Just because you've never had problems with these sites before doesn't mean they're good. You should still avoid them for all the reasons listed above.\n\n    Q: Is there a list of these sites I can check out?\n    > Yes, however, due to these showing up all the time, it's possible to be incomplete. (https://github.com/StopModReposts/Illegal-Mod-Sites/blob/master/SITES.md)\n\n    Q: Why can't you just take these sites down?\n    > Unfortunately, these sites are often hosted in countries like Russia or Vietnam, where doing so isn't as feasible.\n\n    Q: What if it says \"Official Download\" on the sites?\n    > Sometimes they'll do that to trick you. If you're uncertain, you should verify with the StopModReposts list linked above.\n\n\n    Credits: XxRexRaptorxX, Vazkii, StopModReposts campaign\n";
                Files.writeString(marker, (CharSequence)fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
                String launcher = FMLLoader.getLauncherInfo().toLowerCase();
                if (!launcher.contains("curseforge") && !launcher.contains("modrinth") && !launcher.contains("prism") && Config.getModRepostsInfo()) {
                    MagmaCore.LOGGER.info("Stop-mod-reposts info message is generated. Don't worry, this message should only appear the very first time after installation!");
                    player2.displayClientMessage((Component)Component.literal((String)"<-------------------------------------------------->").withStyle(ChatFormatting.RED), false);
                    player2.displayClientMessage((Component)FormattingHelper.setCoreLangComponent("message.reposts_header", ChatFormatting.UNDERLINE).withStyle(ChatFormatting.DARK_RED), false);
                    player2.displayClientMessage((Component)FormattingHelper.setCoreLangComponent("message.reposts_warning", ChatFormatting.RED), false);
                    player2.displayClientMessage((Component)FormattingHelper.setCoreLangComponent("message.reposts_note_intro", ChatFormatting.UNDERLINE).withStyle(ChatFormatting.DARK_RED), false);
                    player2.displayClientMessage((Component)FormattingHelper.setCoreLangComponent("message.reposts_malware", ChatFormatting.RED), false);
                    player2.displayClientMessage((Component)FormattingHelper.setCoreLangComponent("message.reposts_steal", ChatFormatting.RED), false);
                    player2.displayClientMessage((Component)FormattingHelper.setCoreLangComponent("message.reposts_broken", ChatFormatting.RED), false);
                    player2.displayClientMessage((Component)FormattingHelper.setCoreLangComponent("message.reposts_authors", ChatFormatting.RED), false);
                    player2.displayClientMessage((Component)Component.empty(), false);
                    MutableComponent url = FormattingHelper.setCoreLangComponent("message.reposts_more_info").withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create("https://vazkii.net/repost/"))).withColor(ChatFormatting.GOLD).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"?").withStyle(ChatFormatting.GRAY))));
                    player2.displayClientMessage((Component)url, false);
                    player2.displayClientMessage((Component)Component.literal((String)"<-------------------------------------------------->").withStyle(ChatFormatting.RED), false);
                }
            }
        }
        catch (IOException e) {
            MagmaCore.LOGGER.error((Object)e);
        }
    }
}

