/*
 * Decompiled with CFR 0.152.
 */
package com.thevoidblock.voidcommands.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.thevoidblock.voidcommands.ChunkTracker;
import com.thevoidblock.voidcommands.VoidCommands;
import com.thevoidblock.voidcommands.VoidCommandsStyler;
import dev.xpple.clientarguments.arguments.CBlockStateArgument;
import dev.xpple.clientarguments.arguments.CEntityArgument;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_7157;

@Environment(value=EnvType.CLIENT)
public class VQueryCommand {
    private static final String ENTITY_QUERY_NAME = "entities";
    private static final String BLOCK_QUERY_NAME = "blocks";

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)String.format("%squery", Character.valueOf('v'))).then(ClientCommandManager.literal((String)ENTITY_QUERY_NAME).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)ENTITY_QUERY_NAME, (ArgumentType)CEntityArgument.entities()).executes(context -> VQueryCommand.executeEntities((CommandContext<FabricClientCommandSource>)context, VoidCommands.CLIENT.field_1690.method_38521()))).then(ClientCommandManager.argument((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)VoidCommands.CLIENT.field_1690.method_38521())).executes(context -> VQueryCommand.executeEntities((CommandContext<FabricClientCommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"distance"))))))).then(ClientCommandManager.literal((String)BLOCK_QUERY_NAME).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)BLOCK_QUERY_NAME, (ArgumentType)CBlockStateArgument.blockState((class_7157)registryAccess)).executes(context -> VQueryCommand.executeBlocks((CommandContext<FabricClientCommandSource>)context, CBlockStateArgument.getBlockState((CommandContext)context, (String)BLOCK_QUERY_NAME).getState(), VoidCommands.CLIENT.field_1690.method_38521()))).then(ClientCommandManager.argument((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)VoidCommands.CLIENT.field_1690.method_38521())).executes(context -> VQueryCommand.executeBlocks((CommandContext<FabricClientCommandSource>)context, CBlockStateArgument.getBlockState((CommandContext)context, (String)BLOCK_QUERY_NAME).getState(), IntegerArgumentType.getInteger((CommandContext)context, (String)"distance"))))))));
    }

    private static int executeEntities(CommandContext<FabricClientCommandSource> context, int distance) {
        int queryCount = 0;
        class_243 sourcePos = ((FabricClientCommandSource)context.getSource()).getPosition();
        try {
            queryCount = CEntityArgument.getEntities(context, (String)ENTITY_QUERY_NAME).stream().filter(entity -> Math.pow((int)Math.floor(entity.method_73189().field_1352 / 16.0) - (int)Math.floor(sourcePos.field_1352 / 16.0), 2.0) + Math.pow((int)Math.floor(entity.method_73189().field_1350 / 16.0) - (int)Math.floor(sourcePos.field_1350 / 16.0), 2.0) <= Math.pow(distance, 2.0)).toList().size();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(VQueryCommand.getFeedback(context, queryCount, distance));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (queryCount == 0) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"chat.voidcommands.entity_not_found", (Object[])new Object[]{VQueryCommand.getQueryArgument(context), distance}).method_27692(VoidCommandsStyler.ERROR_FORMATTING));
        }
        return queryCount;
    }

    private static int executeBlocks(CommandContext<FabricClientCommandSource> context, class_2680 blockState, int distance) {
        AtomicInteger queryCount = new AtomicInteger(0);
        assert (VoidCommands.CLIENT.field_1687 != null);
        class_243 sourcePos = ((FabricClientCommandSource)context.getSource()).getPosition();
        try (ExecutorService threadPool = Executors.newFixedThreadPool(ChunkTracker.loadedChunks.size());){
            for (class_1923 chunkPos : ChunkTracker.loadedChunks) {
                threadPool.submit(() -> {
                    if (Math.pow(chunkPos.field_9181 - (int)Math.floor(sourcePos.field_1352 / 16.0), 2.0) + Math.pow(chunkPos.field_9180 - (int)Math.floor(sourcePos.field_1350 / 16.0), 2.0) <= Math.pow(distance, 2.0)) {
                        for (int x = 0; x < 16; ++x) {
                            for (int y = VoidCommands.CLIENT.field_1687.method_31607(); y < VoidCommands.CLIENT.field_1687.method_31605(); ++y) {
                                for (int z = 0; z < 16; ++z) {
                                    class_2338 blockPos = new class_2338(chunkPos.field_9181 * 16 + x, y, chunkPos.field_9180 * 16 + z);
                                    if (VoidCommands.CLIENT.field_1687.method_8320(blockPos) != blockState) continue;
                                    queryCount.incrementAndGet();
                                }
                            }
                        }
                    }
                });
            }
        }
        if (queryCount.get() != 0) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback(VQueryCommand.getFeedback(context, queryCount.get(), distance));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"chat.voidcommands.block_not_found", (Object[])new Object[]{VQueryCommand.getQueryArgument(context), distance}).method_27692(VoidCommandsStyler.ERROR_FORMATTING));
        }
        return queryCount.get();
    }

    private static class_2561 getFeedback(CommandContext<FabricClientCommandSource> context, int count, int distance) {
        return class_2561.method_43469((String)"chat.voidcommands.query_found", (Object[])new Object[]{count, VQueryCommand.getQueryArgument(context), distance});
    }

    private static String getQueryArgument(CommandContext<FabricClientCommandSource> context) {
        return context.getInput().split("\\s+", 3)[2].split("\\s+\\d+$")[0];
    }
}

