/*
 * Decompiled with CFR 0.152.
 */
package villagerwindmill.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import villagerwindmill.world.structures.VillagerWindmillModStructureBase;
import villagerwindmill.world.structures.WindmillStructure;

@Mod.EventBusSubscriber
public class VillagerWindmillModStructures {
    public static final DeferredRegister<Structure<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"villager_windmill");
    private static final List<StructureRegistration> STRUCTURE_REGISTRATIONS = new ArrayList<StructureRegistration>();
    public static final RegistryObject<VillagerWindmillModStructureBase> WINDMILL = VillagerWindmillModStructures.register("windmill", WindmillStructure::new);

    private static RegistryObject<VillagerWindmillModStructureBase> register(String registryname, Supplier<VillagerWindmillModStructureBase> structure) {
        StructureRegistration structureRegistration = new StructureRegistration((RegistryObject<VillagerWindmillModStructureBase>)REGISTRY.register(registryname, structure));
        STRUCTURE_REGISTRATIONS.add(structureRegistration);
        return structureRegistration.structure();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (StructureRegistration registration : STRUCTURE_REGISTRATIONS) {
            VillagerWindmillModStructureBase structure = (VillagerWindmillModStructureBase)registration.structure().get();
            if (structure.getBiomes() != null && !structure.getBiomes().contains(event.getName())) continue;
            event.getGeneration().getStructures().add(() -> structure.configuredFeature());
        }
    }

    @SubscribeEvent
    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<VillagerWindmillModStructureBase, Object> tempMap = new HashMap<VillagerWindmillModStructureBase, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            for (StructureRegistration registration : STRUCTURE_REGISTRATIONS) {
                VillagerWindmillModStructureBase structure = (VillagerWindmillModStructureBase)registration.structure().get();
                if (structure.getDimensions() != null && !structure.getDimensions().contains(serverWorld.func_234923_W_())) {
                    tempMap.remove((Object)structure);
                    continue;
                }
                tempMap.putIfAbsent(structure, DimensionStructuresSettings.field_236191_b_.get((Object)structure));
            }
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    private static class StructureRegistration {
        private final RegistryObject<VillagerWindmillModStructureBase> structure;

        public StructureRegistration(RegistryObject<VillagerWindmillModStructureBase> structure) {
            this.structure = structure;
        }

        public RegistryObject<VillagerWindmillModStructureBase> structure() {
            return this.structure;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class InitClass {
        private InitClass() {
        }

        @SubscribeEvent
        public static void init(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                for (StructureRegistration registration : STRUCTURE_REGISTRATIONS) {
                    VillagerWindmillModStructureBase structure = (VillagerWindmillModStructureBase)registration.structure().get();
                    StructureSeparationSettings configuration = structure.getStructureFeatureConfiguration();
                    String id = structure.getRegistryName().toString();
                    Structure.field_236365_a_.put((Object)id, (Object)structure);
                    if (structure.isSurroundedByLand()) {
                        Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add((Object)structure).build();
                    }
                    DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put((Object)structure, (Object)configuration).build();
                    WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                        Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                        if (structureMap instanceof ImmutableMap) {
                            HashMap<VillagerWindmillModStructureBase, StructureSeparationSettings> tempMap = new HashMap<VillagerWindmillModStructureBase, StructureSeparationSettings>(structureMap);
                            tempMap.put(structure, configuration);
                            ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
                        } else {
                            structureMap.put(structure, configuration);
                        }
                    });
                    Registry.func_218325_a((Registry)WorldGenRegistries.field_243654_f, (String)id, structure.configuredFeature());
                    FlatGenerationSettings.field_202247_j.put(structure, structure.configuredFeature());
                }
            });
        }
    }
}

