/*
 * Decompiled with CFR 0.152.
 */
package villagerwindmill.world.structures.configurations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class StructureConfiguration
implements IFeatureConfig {
    private final int maxDepth;
    private final Height startHeight;
    private final Optional<Heightmap.Type> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    public static final Codec<StructureConfiguration> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(config -> config.maxDepth()), (App)Height.CODEC.fieldOf("start_height").forGetter(config -> config.startHeight()), (App)Heightmap.Type.field_236078_g_.optionalFieldOf("project_start_to_heightmap").forGetter(config -> config.projectStartToHeightmap()), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(config -> config.maxDistanceFromCenter())).apply((Applicative)builder, StructureConfiguration::new));

    public StructureConfiguration(int maxDepth, Height startHeight, Optional<Heightmap.Type> projectStartToHeightmap, int maxDistanceFromCenter) {
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public int maxDepth() {
        return this.maxDepth;
    }

    public Height startHeight() {
        return this.startHeight;
    }

    public Optional<Heightmap.Type> projectStartToHeightmap() {
        return this.projectStartToHeightmap;
    }

    public int maxDistanceFromCenter() {
        return this.maxDistanceFromCenter;
    }

    public static class ConstantHeight
    extends Height {
        public static ConstantHeight of(int height) {
            return new ConstantHeight(height);
        }

        private ConstantHeight(int height) {
            super(height, height);
        }

        @Override
        public int sample(Random random) {
            return this.min;
        }
    }

    public static class TrapezoidHeight
    extends Height {
        public static TrapezoidHeight of(int min, int max) {
            return new TrapezoidHeight(min, max);
        }

        private TrapezoidHeight(int min, int max) {
            super(min, max);
        }

        @Override
        public int sample(Random random) {
            if (this.min > this.max) {
                return this.min;
            }
            int mid = this.max - this.min;
            if (0 >= mid) {
                return random.nextInt(this.max - this.min + 1) + this.min;
            }
            int random1 = mid / 2;
            int random2 = mid - random1;
            return this.min + random.nextInt(random2 + 1) + random.nextInt(random1 + 1);
        }
    }

    public static class VeryBiasedToBottomHeight
    extends Height {
        public static VeryBiasedToBottomHeight of(int min, int max) {
            return new VeryBiasedToBottomHeight(min, max);
        }

        private VeryBiasedToBottomHeight(int min, int max) {
            super(min, max);
        }

        @Override
        public int sample(Random random) {
            if (this.max - this.min <= 0) {
                return this.min;
            }
            int random1 = MathHelper.func_76136_a((Random)random, (int)(this.min + 1), (int)this.max);
            int random2 = MathHelper.func_76136_a((Random)random, (int)this.min, (int)(random1 - 1));
            return MathHelper.func_76136_a((Random)random, (int)this.min, (int)random2);
        }
    }

    public static class BiasedToBottomHeight
    extends Height {
        public static BiasedToBottomHeight of(int min, int max) {
            return new BiasedToBottomHeight(min, max);
        }

        private BiasedToBottomHeight(int min, int max) {
            super(min, max);
        }

        @Override
        public int sample(Random random) {
            if (this.max - this.min <= 0) {
                return this.min;
            }
            int random1 = random.nextInt(this.max - this.min);
            return random.nextInt(random1 + 1) + this.min;
        }
    }

    public static class UniformHeight
    extends Height {
        public static UniformHeight of(int min, int max) {
            return new UniformHeight(min, max);
        }

        private UniformHeight(int min, int max) {
            super(min, max);
        }

        @Override
        public int sample(Random random) {
            if (this.min > this.max) {
                return this.min;
            }
            return random.nextInt(this.max - this.min + 1) + this.min;
        }
    }

    public static class Height {
        protected final int min;
        protected final int max;
        public static final Codec<Height> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min_inclusive").forGetter(height -> height.min), (App)Codec.INT.fieldOf("max_inclusive").forGetter(height -> height.max)).apply((Applicative)instance, Height::new));

        protected Height(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int sample(Random random) {
            return 0;
        }
    }
}

