/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geneticplayground.block;

import net.mcreator.geneticplayground.block.entity.SolarPanelBlockEntity;
import net.mcreator.geneticplayground.procedures.SolarPanelOnTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SolarPanelBlock
extends Block
implements EntityBlock {
    public SolarPanelBlock() {
        super(BlockBehaviour.Properties.of().strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)SolarPanelBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[]{SolarPanelBlock.box((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)1.0, (double)4.0), SolarPanelBlock.box((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)1.0, (double)14.0), SolarPanelBlock.box((double)12.0, (double)0.0, (double)6.0, (double)14.0, (double)1.0, (double)10.0), SolarPanelBlock.box((double)2.0, (double)0.0, (double)6.0, (double)4.0, (double)1.0, (double)10.0), SolarPanelBlock.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), SolarPanelBlock.box((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0), SolarPanelBlock.box((double)14.0, (double)6.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), SolarPanelBlock.box((double)1.0, (double)6.0, (double)1.0, (double)2.0, (double)7.0, (double)15.0), SolarPanelBlock.box((double)2.0, (double)6.0, (double)14.0, (double)14.0, (double)7.0, (double)15.0), SolarPanelBlock.box((double)2.0, (double)6.0, (double)1.0, (double)14.0, (double)7.0, (double)2.0), SolarPanelBlock.box((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0)});
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 1);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        SolarPanelOnTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 1);
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SolarPanelBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof SolarPanelBlockEntity) {
                SolarPanelBlockEntity be = (SolarPanelBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof SolarPanelBlockEntity) {
            SolarPanelBlockEntity be = (SolarPanelBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

