/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geneticplayground.block.entity;

import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.mcreator.geneticplayground.init.GeneticPlaygroundModBlockEntities;
import net.mcreator.geneticplayground.init.GeneticPlaygroundModFluids;
import net.mcreator.geneticplayground.world.inventory.BloodPurifierGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BloodPurifierBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    private final EnergyStorage energyStorage = new EnergyStorage(25000, 500, 25000, 0){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int retval = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                BloodPurifierBlockEntity.this.setChanged();
                BloodPurifierBlockEntity.this.level.sendBlockUpdated(BloodPurifierBlockEntity.this.worldPosition, BloodPurifierBlockEntity.this.level.getBlockState(BloodPurifierBlockEntity.this.worldPosition), BloodPurifierBlockEntity.this.level.getBlockState(BloodPurifierBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int retval = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                BloodPurifierBlockEntity.this.setChanged();
                BloodPurifierBlockEntity.this.level.sendBlockUpdated(BloodPurifierBlockEntity.this.worldPosition, BloodPurifierBlockEntity.this.level.getBlockState(BloodPurifierBlockEntity.this.worldPosition), BloodPurifierBlockEntity.this.level.getBlockState(BloodPurifierBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }
    };
    public final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return BloodPurifierBlockEntity.this.fluidTanks.length;
        }

        public FluidStack getFluidInTank(int tank) {
            return BloodPurifierBlockEntity.this.fluidTanks[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            return BloodPurifierBlockEntity.this.fluidTanks[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return BloodPurifierBlockEntity.this.fluidTanks[tank].isFluidValid(stack);
        }

        public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
            FluidTank[] tanks;
            for (FluidTank tank : tanks = (FluidTank[])Stream.concat(Arrays.stream(BloodPurifierBlockEntity.this.inputTanks), Arrays.stream(BloodPurifierBlockEntity.this.ioTanks)).toArray(FluidTank[]::new)) {
                int tankSpace = tank.getCapacity() - tank.getFluidAmount();
                if (stack.isEmpty()) {
                    return 0;
                }
                if (!tank.getFluid().isEmpty() && tank.getFluid().getFluid().isSame(stack.getFluid())) {
                    int fillAmount = Math.min(stack.getAmount(), tankSpace);
                    if (fillAmount > 0) {
                        return tank.fill(stack.copyWithAmount(fillAmount), action);
                    }
                    return 0;
                }
                if (!tank.isEmpty() || !tank.isFluidValid(stack)) continue;
                return tank.fill(stack.copyWithAmount(stack.getAmount()), action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
            FluidTank[] tanks;
            for (FluidTank tank : tanks = (FluidTank[])Stream.concat(Arrays.stream(BloodPurifierBlockEntity.this.outputTanks), Arrays.stream(BloodPurifierBlockEntity.this.ioTanks)).toArray(FluidTank[]::new)) {
                if (stack.getFluid() != tank.getFluid().getFluid()) continue;
                return tank.drain(stack.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidTank[] tanks;
            for (FluidTank tank : tanks = (FluidTank[])Stream.concat(Arrays.stream(BloodPurifierBlockEntity.this.outputTanks), Arrays.stream(BloodPurifierBlockEntity.this.ioTanks)).toArray(FluidTank[]::new)) {
                if (tank.getFluidAmount() <= 0) continue;
                return tank.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }

        public FluidTank getTank(int index) {
            return BloodPurifierBlockEntity.this.fluidTanks[index];
        }
    };
    private final FluidTank fluidTank0 = new FluidTank(1000, fs -> fs.getFluid() == GeneticPlaygroundModFluids.PLASMA_RESIDUE.get()){

        protected void onContentsChanged() {
            super.onContentsChanged();
            BloodPurifierBlockEntity.this.setChanged();
            BloodPurifierBlockEntity.this.level.sendBlockUpdated(BloodPurifierBlockEntity.this.worldPosition, BloodPurifierBlockEntity.this.level.getBlockState(BloodPurifierBlockEntity.this.worldPosition), BloodPurifierBlockEntity.this.level.getBlockState(BloodPurifierBlockEntity.this.worldPosition), 2);
        }

        public void setFluid(FluidStack stack) {
            super.setFluid(stack);
            BloodPurifierBlockEntity.this.setChanged();
            BloodPurifierBlockEntity.this.level.sendBlockUpdated(BloodPurifierBlockEntity.this.worldPosition, BloodPurifierBlockEntity.this.level.getBlockState(BloodPurifierBlockEntity.this.worldPosition), BloodPurifierBlockEntity.this.level.getBlockState(BloodPurifierBlockEntity.this.worldPosition), 2);
        }
    };
    private final FluidTank[] fluidTanks = new FluidTank[]{this.fluidTank0};
    private final FluidTank[] ioTanks = new FluidTank[]{this.fluidTank0};
    private final FluidTank[] inputTanks = new FluidTank[0];
    private final FluidTank[] outputTanks = new FluidTank[0];

    public BloodPurifierBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)GeneticPlaygroundModBlockEntities.BLOOD_PURIFIER.get(), position, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        Tag tag = compound.get("energyStorage");
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            this.energyStorage.deserializeNBT(lookupProvider, (Tag)intTag);
        }
        for (int i = 0; i < this.fluidTanks.length; ++i) {
            this.fluidTanks[i].readFromNBT(lookupProvider, compound.getCompound("fluidTank" + i));
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        }
        compound.put("energyStorage", this.energyStorage.serializeNBT(lookupProvider));
        for (int i = 0; i < this.fluidTanks.length; ++i) {
            compound.put("fluidTank" + i, (Tag)this.fluidTanks[i].writeToNBT(lookupProvider, new CompoundTag()));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Component getDefaultName() {
        return Component.literal((String)"blood_purifier");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new BloodPurifierGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    public Component getDisplayName() {
        return Component.literal((String)"Blood Purification Chamber");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index != 1;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemstack, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemstack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack itemstack, Direction direction) {
        if (index == 0) {
            return false;
        }
        if (index == 2) {
            return false;
        }
        return index != 4;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public IFluidHandler getFluidTank() {
        return this.fluidHandler;
    }

    public FluidTank getFluidTank0() {
        return this.fluidTank0;
    }
}

