/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geneticplayground.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.mcreator.geneticplayground.block.entity.BloodPurifierBlockEntity;
import net.mcreator.geneticplayground.init.GeneticPlaygroundModScreens;
import net.mcreator.geneticplayground.procedures.BatterySpritesheetProcedureProcedure;
import net.mcreator.geneticplayground.procedures.BatteryTooltipProcedure;
import net.mcreator.geneticplayground.procedures.ProgressUpdaterProcedure;
import net.mcreator.geneticplayground.utils.FluidStackWidget;
import net.mcreator.geneticplayground.world.inventory.BloodPurifierGUIMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class BloodPurifierGUIScreen
extends AbstractContainerScreen<BloodPurifierGUIMenu>
implements GeneticPlaygroundModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"genetic_playground:textures/screens/blood_purifier_gui.png");

    public BloodPurifierGUIScreen(BloodPurifierGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        boolean customTooltipShown = false;
        if (mouseX > this.leftPos + 8 && mouseX < this.leftPos + 24 && mouseY > this.topPos + 16 && mouseY < this.topPos + 80) {
            String hoverText = BatteryTooltipProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z);
            if (hoverText != null) {
                guiGraphics.renderComponentTooltip(this.font, Arrays.stream(hoverText.split("\n")).map(Component::literal).collect(Collectors.toList()), mouseX, mouseY);
            }
            customTooltipShown = true;
        }
        if (mouseX > this.leftPos + 133 && mouseX < this.leftPos + 151 && mouseY > this.topPos + 62 && mouseY < this.topPos + 80) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.genetic_playground.blood_purifier_gui.tooltip_empty_bucket_requires_1000mb"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (mouseX > this.leftPos + 24 && mouseX < this.leftPos + 42 && mouseY > this.topPos + 62 && mouseY < this.topPos + 79) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.genetic_playground.blood_purifier_gui.tooltip_machine_speed_upgrade"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (mouseX > this.leftPos + 77 && mouseX < this.leftPos + 99 && mouseY > this.topPos + 42 && mouseY < this.topPos + 57) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.genetic_playground.blood_purifier_gui.tooltip_ss3_requires_and_uses_255_kfe"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (!customTooltipShown) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(ResourceLocation.parse((String)"genetic_playground:textures/screens/syringe-1.png_4.png"), this.leftPos + 54, this.topPos + 41, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"genetic_playground:textures/screens/syringe-1.png_4.png"), this.leftPos + 105, this.topPos + 41, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"genetic_playground:textures/screens/bucket_je2_be2-1.png-1.png.png"), this.leftPos + 134, this.topPos + 63, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"genetic_playground:textures/screens/bucket_je2_be2-1.png-1.png_3.png"), this.leftPos + 25, this.topPos + 63, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"genetic_playground:textures/screens/spritesheet_12.png"), this.leftPos + 8, this.topPos + 16, (float)Mth.clamp((int)((int)BatterySpritesheetProcedureProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z) * 16), (int)0, (int)880), 0.0f, 16, 64, 896, 64);
        guiGraphics.blit(ResourceLocation.parse((String)"genetic_playground:textures/screens/spritesheet_3.png"), this.leftPos + 76, this.topPos + 41, (float)Mth.clamp((int)((int)ProgressUpdaterProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z) * 24), (int)0, (int)504), 0.0f, 24, 16, 528, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"genetic_playground:textures/screens/new_piskel-1.png_75.png"), this.leftPos + 151, this.topPos + 14, 0.0f, 0.0f, 18, 66, 18, 66);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.genetic_playground.blood_purifier_gui.label_blood_purification_chamber"), 5, 4, -12829636, false);
    }

    public void init() {
        super.init();
        this.addFluidWidget();
    }

    public void addFluidWidget() {
        BloodPurifierBlockEntity blockEntity = (BloodPurifierBlockEntity)this.world.getBlockEntity(BlockPos.containing((double)this.x, (double)this.y, (double)this.z));
        this.addRenderableOnly((Renderable)new FluidStackWidget((Screen)this, blockEntity.getFluidTank0(), this.leftPos + 152, this.topPos + 15, 16, 64));
    }
}

