/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geneticplayground.init;

import java.util.Map;
import net.mcreator.geneticplayground.init.GeneticPlaygroundModScreens;
import net.mcreator.geneticplayground.network.MenuStateUpdateMessage;
import net.mcreator.geneticplayground.world.inventory.BloodCentrifugeGUIMenu;
import net.mcreator.geneticplayground.world.inventory.BloodPurifierGUIMenu;
import net.mcreator.geneticplayground.world.inventory.CellAnalyzerGUIMenu;
import net.mcreator.geneticplayground.world.inventory.DNAExtractorGUIMenu;
import net.mcreator.geneticplayground.world.inventory.FissionPowerPlantGUIMenu;
import net.mcreator.geneticplayground.world.inventory.FissionReactorConfigGUIMenu;
import net.mcreator.geneticplayground.world.inventory.HeatGeneratorGUIMenu;
import net.mcreator.geneticplayground.world.inventory.PlasmidInjectionChamberGUIMenu;
import net.mcreator.geneticplayground.world.inventory.PlasmidSynthesiserGUIMenu;
import net.mcreator.geneticplayground.world.inventory.ThermalTurbineGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class GeneticPlaygroundModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"genetic_playground");
    public static final DeferredHolder<MenuType<?>, MenuType<BloodPurifierGUIMenu>> BLOOD_PURIFIER_GUI = REGISTRY.register("blood_purifier_gui", () -> IMenuTypeExtension.create(BloodPurifierGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<BloodCentrifugeGUIMenu>> BLOOD_CENTRIFUGE_GUI = REGISTRY.register("blood_centrifuge_gui", () -> IMenuTypeExtension.create(BloodCentrifugeGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<CellAnalyzerGUIMenu>> CELL_ANALYZER_GUI = REGISTRY.register("cell_analyzer_gui", () -> IMenuTypeExtension.create(CellAnalyzerGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<DNAExtractorGUIMenu>> DNA_EXTRACTOR_GUI = REGISTRY.register("dna_extractor_gui", () -> IMenuTypeExtension.create(DNAExtractorGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<PlasmidSynthesiserGUIMenu>> PLASMID_SYNTHESISER_GUI = REGISTRY.register("plasmid_synthesiser_gui", () -> IMenuTypeExtension.create(PlasmidSynthesiserGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<PlasmidInjectionChamberGUIMenu>> PLASMID_INJECTION_CHAMBER_GUI = REGISTRY.register("plasmid_injection_chamber_gui", () -> IMenuTypeExtension.create(PlasmidInjectionChamberGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<FissionPowerPlantGUIMenu>> FISSION_POWER_PLANT_GUI = REGISTRY.register("fission_power_plant_gui", () -> IMenuTypeExtension.create(FissionPowerPlantGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<ThermalTurbineGUIMenu>> THERMAL_TURBINE_GUI = REGISTRY.register("thermal_turbine_gui", () -> IMenuTypeExtension.create(ThermalTurbineGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<FissionReactorConfigGUIMenu>> FISSION_REACTOR_CONFIG_GUI = REGISTRY.register("fission_reactor_config_gui", () -> IMenuTypeExtension.create(FissionReactorConfigGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<HeatGeneratorGUIMenu>> HEAT_GENERATOR_GUI = REGISTRY.register("heat_generator_gui", () -> IMenuTypeExtension.create(HeatGeneratorGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (player.level().isClientSide) {
                Screen screen = Minecraft.getInstance().screen;
                if (screen instanceof GeneticPlaygroundModScreens.ScreenAccessor) {
                    GeneticPlaygroundModScreens.ScreenAccessor accessor = (GeneticPlaygroundModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

