/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.geneticplayground.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidStackWidget
extends AbstractWidget {
    private final Screen screen;
    private final FluidTank tank;

    public FluidStackWidget(Screen screen, FluidTank tank, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
        this.screen = screen;
        this.tank = tank;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (!this.tank.getFluid().isEmpty()) {
            FluidStack fluidStack = this.tank.getFluid();
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation still = props.getStillTexture(fluidStack);
            AbstractTexture texture = minecraft.getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS);
            if (texture instanceof TextureAtlas) {
                TextureAtlas atlas = (TextureAtlas)texture;
                atlas = (TextureAtlas)texture;
                TextureAtlasSprite sprite = atlas.getSprite(still);
                int color = props.getTintColor();
                RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.red((int)color) / 255.0f), (float)((float)FastColor.ARGB32.green((int)color) / 255.0f), (float)((float)FastColor.ARGB32.blue((int)color) / 255.0f), (float)((float)FastColor.ARGB32.alpha((int)color) / 255.0f));
                RenderSystem.enableBlend();
                int stored = this.tank.getFluidAmount();
                float capacity = this.tank.getCapacity();
                float filledVolume = (float)stored / capacity;
                int renderableHeight = (int)(filledVolume * (float)this.getHeight());
                int atlasWidth = (int)((float)sprite.contents().width() / (sprite.getU1() - sprite.getU0()));
                int atlasHeight = (int)((float)sprite.contents().height() / (sprite.getV1() - sprite.getV0()));
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, (float)(this.getHeight() - 16), 0.0f);
                int i = 0;
                while ((double)i < Math.ceil((float)renderableHeight / 16.0f)) {
                    int drawingHeight = Math.min(16, renderableHeight - 16 * i);
                    int notDrawingHeight = 16 - drawingHeight;
                    guiGraphics.blit(InventoryMenu.BLOCK_ATLAS, this.getX(), this.getY() + notDrawingHeight, 0, sprite.getU0() * (float)atlasWidth, sprite.getV0() * (float)atlasHeight + (float)notDrawingHeight, this.getWidth(), drawingHeight, atlasWidth, atlasHeight);
                    guiGraphics.pose().translate(0.0f, -16.0f, 0.0f);
                    ++i;
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.pose().popPose();
            }
        }
        RenderSystem.disableDepthTest();
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (FluidStackWidget.mouseHover(mouseX, mouseY, this.getX(), this.getY(), this.getWidth(), this.getHeight())) {
            int amount;
            Font font = this.screen.getMinecraft().font;
            FormattedCharSequence[] tooltipText = new FormattedCharSequence[2];
            if (!this.tank.getFluid().isEmpty()) {
                tooltipText[0] = this.tank.getFluid().getHoverName().getVisualOrderText();
                amount = this.tank.getFluidAmount();
            } else {
                tooltipText[0] = Component.literal((String)"Air").getVisualOrderText();
                amount = 0;
            }
            tooltipText[1] = Component.literal((String)(amount + "mB / " + this.tank.getCapacity() + "mB")).getVisualOrderText();
            guiGraphics.renderTooltip(font, Arrays.asList(tooltipText), mouseX, mouseY);
        }
    }

    private static boolean mouseHover(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

