/*
 * Decompiled with CFR 0.152.
 */
package com.aesyin.pvpzone;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PVPZoneNotifier
extends JavaPlugin
implements Listener {
    private int pvpRadius;
    private String enterMessage;
    private String leaveMessage;
    private NamedTextColor enterColor;
    private NamedTextColor leaveColor;
    private String enterDisplayType;
    private String leaveDisplayType;
    private String combatDisplayType;
    private boolean soundEnabled;
    private String enterSoundName;
    private String leaveSoundName;
    private float soundVolume;
    private float soundPitch;
    private boolean combatEnabled;
    private int combatDuration;
    private String combatTagMsg;
    private String combatSafeMsg;
    private String combatLogoutMsg;
    private String combatPunishment;
    private boolean disablePearls;
    private boolean disableElytra;
    private String blockedMsg;
    private final List<PotionEffect> combatDebuffs = new ArrayList<PotionEffect>();
    private final Map<UUID, Long> combatTagged = new HashMap<UUID, Long>();
    private final Set<UUID> loggedOutInCombat = new HashSet<UUID>();
    private final Set<UUID> inPvpZone = new HashSet<UUID>();
    private final Map<UUID, BukkitRunnable> combatCountdownTasks = new HashMap<UUID, BukkitRunnable>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("pvpzonereload")).setExecutor((sender, command, label, args) -> {
            this.reloadConfig();
            this.loadConfig();
            sender.sendMessage((Component)Component.text((String)"PVPZoneNotifier configuration reloaded.", (TextColor)NamedTextColor.GREEN));
            return true;
        });
        Objects.requireNonNull(this.getCommand("pvpzoneradius")).setExecutor((sender, command, label, args) -> {
            if (!sender.hasPermission("pvpzone.admin")) {
                sender.sendMessage((Component)Component.text((String)"You don't have permission to use this command.", (TextColor)NamedTextColor.RED));
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage((Component)Component.text((String)"Usage: /pvpzoneradius <number>", (TextColor)NamedTextColor.YELLOW));
                return true;
            }
            try {
                int newRadius = Integer.parseInt(args[0]);
                if (newRadius < 0) {
                    sender.sendMessage((Component)Component.text((String)"Radius must be 0 or higher.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.pvpRadius = newRadius;
                this.getConfig().set("pvp-radius", (Object)newRadius);
                this.saveConfig();
                sender.sendMessage((Component)Component.text((String)("PvP radius set to " + newRadius + " blocks."), (TextColor)NamedTextColor.GREEN));
            }
            catch (NumberFormatException ex) {
                sender.sendMessage((Component)Component.text((String)("Invalid number: " + args[0]), (TextColor)NamedTextColor.RED));
            }
            return true;
        });
        this.getLogger().info("PVPZoneNotifier enabled successfully.");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.pvpRadius = config.getInt("pvp-radius", 3000);
        this.enterMessage = config.getString("messages.enter-pvp", "You are now in a PVP Zone");
        this.leaveMessage = config.getString("messages.leave-pvp", "You are now in a Safe Zone");
        this.enterColor = this.parseColor(config.getString("colors.enter-pvp", "red"));
        this.leaveColor = this.parseColor(config.getString("colors.leave-pvp", "green"));
        this.enterDisplayType = config.getString("display.enter", "ACTION_BAR").toUpperCase(Locale.ROOT);
        this.leaveDisplayType = config.getString("display.leave", "ACTION_BAR").toUpperCase(Locale.ROOT);
        this.combatDisplayType = config.getString("display.combat", "ACTION_BAR").toUpperCase(Locale.ROOT);
        this.soundEnabled = config.getBoolean("sounds.enable", true);
        this.enterSoundName = config.getString("sounds.enter", "ENTITY_EXPERIENCE_ORB_PICKUP");
        this.leaveSoundName = config.getString("sounds.leave", "ENTITY_ITEM_PICKUP");
        this.soundVolume = (float)config.getDouble("sounds.volume", 1.0);
        this.soundPitch = (float)config.getDouble("sounds.pitch", 1.0);
        this.combatEnabled = config.getBoolean("combat.enabled", true);
        this.combatDuration = config.getInt("combat.tag-duration", 15);
        this.combatPunishment = config.getString("combat.punishment", "DEBUFF");
        this.disablePearls = config.getBoolean("combat.disable-pearls", true);
        this.disableElytra = config.getBoolean("combat.disable-elytra", true);
        this.combatTagMsg = config.getString("combat.messages.tag", "You are in combat!");
        this.combatSafeMsg = config.getString("combat.messages.safe", "You are no longer in combat.");
        this.combatLogoutMsg = config.getString("combat.messages.logout", "%player% logged out during combat!");
        this.blockedMsg = config.getString("combat.messages.blocked-item", "You cannot use that while in combat!");
        this.combatDebuffs.clear();
        if (config.isList("combat.debuff-effects")) {
            for (Map entry : config.getMapList("combat.debuff-effects")) {
                try {
                    Number num;
                    String typeName = Objects.toString(entry.get("type"), "POISON");
                    PotionEffectType type = PotionEffectType.getByName((String)typeName.toUpperCase(Locale.ROOT));
                    if (type == null) continue;
                    Object durationObj = entry.get("duration");
                    Object amplifierObj = entry.get("amplifier");
                    int duration = 100;
                    int amplifier = 1;
                    if (durationObj instanceof Number) {
                        num = (Number)durationObj;
                        duration = num.intValue();
                    }
                    if (amplifierObj instanceof Number) {
                        num = (Number)amplifierObj;
                        amplifier = num.intValue();
                    }
                    this.combatDebuffs.add(new PotionEffect(type, duration, amplifier));
                }
                catch (Exception ex) {
                    this.getLogger().warning("Invalid debuff entry in config: " + String.valueOf(entry));
                }
            }
        }
    }

    private NamedTextColor parseColor(String name) {
        try {
            return (NamedTextColor)NamedTextColor.NAMES.value((Object)name.toLowerCase(Locale.ROOT));
        }
        catch (Exception e) {
            return NamedTextColor.WHITE;
        }
    }

    private void sendDisplay(Player player, String type, String message, NamedTextColor color) {
        TextComponent text = Component.text((String)message, (TextColor)color);
        switch (type) {
            case "TITLE": {
                Title title = Title.title((Component)text, (Component)Component.empty(), (Title.Times)Title.Times.of((Duration)Duration.ofMillis(250L), (Duration)Duration.ofMillis(1500L), (Duration)Duration.ofMillis(250L)));
                player.showTitle(title);
                break;
            }
            case "SUBTITLE": {
                Title title = Title.title((Component)Component.empty(), (Component)text, (Title.Times)Title.Times.of((Duration)Duration.ofMillis(250L), (Duration)Duration.ofMillis(1500L), (Duration)Duration.ofMillis(250L)));
                player.showTitle(title);
                break;
            }
            default: {
                player.sendActionBar((Component)text);
            }
        }
    }

    private void playSoundSafe(Player player, String soundName, float volume, float pitch) {
        try {
            Sound sound = Sound.valueOf((String)soundName);
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        Player player = e.getPlayer();
        Location loc = e.getTo();
        if (loc == null) {
            return;
        }
        double dist = Math.sqrt(loc.getX() * loc.getX() + loc.getZ() * loc.getZ());
        boolean inZone = dist >= (double)this.pvpRadius;
        boolean wasInZone = this.inPvpZone.contains(player.getUniqueId());
        if (inZone && !wasInZone) {
            this.inPvpZone.add(player.getUniqueId());
            this.sendDisplay(player, this.enterDisplayType, this.enterMessage, this.enterColor);
            if (this.soundEnabled) {
                this.playSoundSafe(player, this.enterSoundName, this.soundVolume, this.soundPitch);
            }
        } else if (!inZone && wasInZone) {
            this.inPvpZone.remove(player.getUniqueId());
            this.sendDisplay(player, this.leaveDisplayType, this.leaveMessage, this.leaveColor);
            if (this.soundEnabled) {
                this.playSoundSafe(player, this.leaveSoundName, this.soundVolume, this.soundPitch);
            }
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        if (!this.combatEnabled) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Entity entity2 = e.getDamager();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity2;
        double dist = Math.sqrt(victim.getLocation().getX() * victim.getLocation().getX() + victim.getLocation().getZ() * victim.getLocation().getZ());
        if (dist < (double)this.pvpRadius) {
            return;
        }
        this.tagCombat(attacker);
        this.tagCombat(victim);
    }

    private void tagCombat(final Player player) {
        this.combatTagged.put(player.getUniqueId(), System.currentTimeMillis());
        if (this.combatCountdownTasks.containsKey(player.getUniqueId())) {
            this.combatCountdownTasks.get(player.getUniqueId()).cancel();
        }
        BukkitRunnable countdown = new BukkitRunnable(){
            int secondsLeft;
            {
                this.secondsLeft = PVPZoneNotifier.this.combatDuration;
            }

            public void run() {
                if (!PVPZoneNotifier.this.isInCombat(player)) {
                    PVPZoneNotifier.this.sendDisplay(player, PVPZoneNotifier.this.combatDisplayType, PVPZoneNotifier.this.combatSafeMsg, NamedTextColor.GREEN);
                    this.cancel();
                    PVPZoneNotifier.this.combatCountdownTasks.remove(player.getUniqueId());
                    return;
                }
                PVPZoneNotifier.this.sendDisplay(player, PVPZoneNotifier.this.combatDisplayType, PVPZoneNotifier.this.combatTagMsg + " (" + this.secondsLeft + "s)", NamedTextColor.RED);
                --this.secondsLeft;
                if (this.secondsLeft < 0) {
                    this.cancel();
                    PVPZoneNotifier.this.combatCountdownTasks.remove(player.getUniqueId());
                }
            }
        };
        countdown.runTaskTimer((Plugin)this, 0L, 20L);
        this.combatCountdownTasks.put(player.getUniqueId(), countdown);
    }

    private boolean isInCombat(Player player) {
        Long lastHit = this.combatTagged.get(player.getUniqueId());
        return lastHit != null && System.currentTimeMillis() - lastHit < (long)this.combatDuration * 1000L;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        if (!this.combatEnabled) {
            return;
        }
        Player p = e.getPlayer();
        if (this.isInCombat(p)) {
            this.loggedOutInCombat.add(p.getUniqueId());
            String msg = this.combatLogoutMsg.replace("%player%", p.getName());
            Bukkit.broadcast((Component)Component.text((String)msg, (TextColor)NamedTextColor.RED));
            switch (this.combatPunishment.toUpperCase(Locale.ROOT)) {
                case "KILL": {
                    p.setHealth(0.0);
                    break;
                }
                case "CLEAR_INVENTORY": {
                    p.getInventory().clear();
                    break;
                }
                case "DEBUFF": {
                    break;
                }
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (!this.combatEnabled) {
            return;
        }
        if (this.combatPunishment.equalsIgnoreCase("DEBUFF") && this.loggedOutInCombat.remove(p.getUniqueId())) {
            for (PotionEffect effect : this.combatDebuffs) {
                p.addPotionEffect(effect);
            }
            p.sendMessage((Component)Component.text((String)"You logged out during combat and are now weakened!", (TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (!this.combatEnabled || !this.disablePearls) {
            return;
        }
        Player p = e.getPlayer();
        if (this.isInCombat(p) && p.getInventory().getItemInMainHand().getType() == Material.ENDER_PEARL) {
            e.setCancelled(true);
            this.sendDisplay(p, this.combatDisplayType, this.blockedMsg, NamedTextColor.RED);
        }
    }

    @EventHandler
    public void onElytraToggle(PlayerToggleFlightEvent e) {
        if (!this.combatEnabled || !this.disableElytra) {
            return;
        }
        Player p = e.getPlayer();
        if (this.isInCombat(p) && p.isGliding()) {
            e.setCancelled(true);
            p.setGliding(false);
            this.sendDisplay(p, this.combatDisplayType, this.blockedMsg, NamedTextColor.RED);
        }
    }
}

