/*
 * Decompiled with CFR 0.152.
 */
package de.kokoio01.spawnglider;

import de.kokoio01.spawnglider.config.SpawnElytraConfig;
import de.kokoio01.spawnglider.util.States;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class RegionFlightController {
    private static final int GRACE_PERIOD_TICKS = 5;
    private static final int MIN_FLYING_TICKS_FOR_GRACE = 20;
    private final SpawnElytraConfig config;

    public RegionFlightController(SpawnElytraConfig config) {
        this.config = config;
    }

    public void register() {
        ServerTickEvents.END_SERVER_TICK.register(this::onEndTick);
    }

    private void onEndTick(MinecraftServer server) {
        States.GracePeriodEndTimes.entrySet().removeIf(entry -> System.currentTimeMillis() >= (Long)entry.getValue());
        for (class_3222 player : server.method_3760().method_14571()) {
            if (player.method_68878() || player.method_7325() || !States.isGlidingEnabled(player.method_5667())) continue;
            class_2960 worldId = player.method_51469().method_27983().method_29177();
            SpawnElytraConfig.Region region = this.config.getRegion(worldId);
            boolean inside = false;
            if (region != null) {
                inside = region.contains(worldId, player.method_23317(), player.method_23318(), player.method_23321());
            }
            if (inside && !player.method_6128() && !player.method_24828()) {
                player.method_23669();
                States.setFlying(player.method_5667(), true);
                States.resetFlyingTicks(player.method_5667());
                continue;
            }
            if (States.isFlying(player.method_5667()) && !player.method_24828()) {
                States.incrementFlyingTicks(player.method_5667());
                if (player.method_6128()) continue;
                player.method_23669();
                continue;
            }
            if (States.isFlying(player.method_5667()) && player.method_24828()) {
                int flown = States.getFlyingTicks(player.method_5667());
                States.setFlying(player.method_5667(), false);
                if (flown >= 20) {
                    States.startGracePeriod(player.method_5667(), 5L);
                    if (!player.method_6128()) {
                        player.method_23669();
                    }
                }
                States.resetFlyingTicks(player.method_5667());
                continue;
            }
            if (!States.isInGracePeriod(player.method_5667()) || player.method_6128()) continue;
            player.method_23669();
        }
    }
}

