/*
 * Decompiled with CFR 0.152.
 */
package de.kokoio01.spawnglider.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.kokoio01.spawnglider.config.SpawnElytraConfig;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ZoneManagementCommand {
    private static SpawnElytraConfig config;

    public static void register(SpawnElytraConfig configInstance) {
        config = configInstance;
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"spawnglider").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"zone").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"minX", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"minY", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"minZ", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"maxX", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"maxY", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"maxZ", (ArgumentType)IntegerArgumentType.integer()).executes(ZoneManagementCommand::setZone))))))))).then(class_2170.method_9247((String)"remove").executes(ZoneManagementCommand::removeZone))).then(class_2170.method_9247((String)"list").executes(ZoneManagementCommand::listZones))).then(class_2170.method_9247((String)"info").executes(ZoneManagementCommand::zoneInfo))).then(class_2170.method_9247((String)"sethere").then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer()).executes(ZoneManagementCommand::setZoneHere)))).executes(ZoneManagementCommand::help))));
    }

    private static int setZone(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players").method_27692(class_124.field_1061));
            return 0;
        }
        String dimension = player.method_51469().method_27983().method_29177().toString();
        int minX = IntegerArgumentType.getInteger(ctx, (String)"minX");
        int minY = IntegerArgumentType.getInteger(ctx, (String)"minY");
        int minZ = IntegerArgumentType.getInteger(ctx, (String)"minZ");
        int maxX = IntegerArgumentType.getInteger(ctx, (String)"maxX");
        int maxY = IntegerArgumentType.getInteger(ctx, (String)"maxY");
        int maxZ = IntegerArgumentType.getInteger(ctx, (String)"maxZ");
        ZoneManagementCommand.config.regions.removeIf(region -> region.dimension.equals(dimension));
        SpawnElytraConfig.Region region2 = new SpawnElytraConfig.Region();
        region2.dimension = dimension;
        region2.minX = minX;
        region2.minY = minY;
        region2.minZ = minZ;
        region2.maxX = maxX;
        region2.maxY = maxY;
        region2.maxZ = maxZ;
        ZoneManagementCommand.config.regions.add(region2);
        config.save();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Zone set for dimension " + dimension + " from (" + minX + "," + minY + "," + minZ + ") to (" + maxX + "," + maxY + "," + maxZ + ")")).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int removeZone(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players").method_27692(class_124.field_1061));
            return 0;
        }
        String dimension = player.method_51469().method_27983().method_29177().toString();
        boolean removed = ZoneManagementCommand.config.regions.removeIf(region -> region.dimension.equals(dimension));
        if (removed) {
            config.save();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Zone removed for dimension " + dimension)).method_27692(class_124.field_1060), true);
        } else {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No zone found for dimension " + dimension)).method_27692(class_124.field_1061));
        }
        return removed ? 1 : 0;
    }

    private static int listZones(CommandContext<class_2168> ctx) {
        if (ZoneManagementCommand.config.regions.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"No zones configured").method_27692(class_124.field_1054), false);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Configured zones:").method_27692(class_124.field_1065), false);
        for (int i = 0; i < ZoneManagementCommand.config.regions.size(); ++i) {
            SpawnElytraConfig.Region region = ZoneManagementCommand.config.regions.get(i);
            class_5250 zoneText = class_2561.method_43470((String)(i + 1 + ". " + region.dimension + " from (" + region.minX + "," + region.minY + "," + region.minZ + ") to (" + region.maxX + "," + region.maxY + "," + region.maxZ + ")")).method_27692(class_124.field_1068);
            ((class_2168)ctx.getSource()).method_9226(() -> ZoneManagementCommand.lambda$listZones$8((class_2561)zoneText), false);
        }
        return 1;
    }

    private static int zoneInfo(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players").method_27692(class_124.field_1061));
            return 0;
        }
        String dimension = player.method_51469().method_27983().method_29177().toString();
        SpawnElytraConfig.Region region = config.getRegion(class_2960.method_12829((String)dimension));
        if (region == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No zone found for dimension " + dimension)).method_27692(class_124.field_1061));
            return 0;
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Zone info for " + dimension + ":")).method_27692(class_124.field_1065), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Min: (" + region.minX + "," + region.minY + "," + region.minZ + ")")).method_27692(class_124.field_1068), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Max: (" + region.maxX + "," + region.maxY + "," + region.maxZ + ")")).method_27692(class_124.field_1068), false);
        return 1;
    }

    private static int setZoneHere(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players").method_27692(class_124.field_1061));
            return 0;
        }
        int radius = IntegerArgumentType.getInteger(ctx, (String)"radius");
        String dimension = player.method_51469().method_27983().method_29177().toString();
        int x = (int)player.method_23317();
        int y = (int)player.method_23318();
        int z = (int)player.method_23321();
        ZoneManagementCommand.config.regions.removeIf(region -> region.dimension.equals(dimension));
        SpawnElytraConfig.Region region2 = new SpawnElytraConfig.Region();
        region2.dimension = dimension;
        region2.minX = x - radius;
        region2.minY = Math.max(y - radius, -64);
        region2.minZ = z - radius;
        region2.maxX = x + radius;
        region2.maxY = Math.min(y + radius, 320);
        region2.maxZ = z + radius;
        ZoneManagementCommand.config.regions.add(region2);
        config.save();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Zone set around your position (" + x + "," + y + "," + z + ") with radius " + radius + " in dimension " + dimension)).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int help(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"SpawnGlider Zone Commands:").method_27692(class_124.field_1065), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"/spawnglider zone set <minX> <minY> <minZ> <maxX> <maxY> <maxZ> - Set a zone in current dimension").method_27692(class_124.field_1068), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"/spawnglider zone remove - Remove zone in current dimension").method_27692(class_124.field_1068), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"/spawnglider zone list - List all zones").method_27692(class_124.field_1068), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"/spawnglider zone info - Show zone info for current dimension").method_27692(class_124.field_1068), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"/spawnglider zone sethere <radius> - Set zone around your position").method_27692(class_124.field_1068), false);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$listZones$8(class_2561 zoneText) {
        return zoneText;
    }
}

