/*
 * Decompiled with CFR 0.152.
 */
package de.kokoio01.spawnglider.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class SpawnElytraConfig {
    @SerializedName(value="regions")
    public List<Region> regions = new ArrayList<Region>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "spawnelytra.json";

    public static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SpawnElytraConfig loadOrCreate() {
        Path path = SpawnElytraConfig.getConfigPath();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader2222 = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                SpawnElytraConfig cfg = (SpawnElytraConfig)GSON.fromJson((Reader)reader2222, SpawnElytraConfig.class);
                if (cfg != null && cfg.regions != null) {
                    SpawnElytraConfig spawnElytraConfig = cfg;
                    return spawnElytraConfig;
                }
            }
            catch (IOException reader2222) {
                // empty catch block
            }
        }
        SpawnElytraConfig def = new SpawnElytraConfig();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)def, (Appendable)writer);
                return def;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return def;
    }

    public Region getRegion(class_2960 worldId) {
        for (Region r : this.regions) {
            if (!r.dimension.equals(worldId.toString())) continue;
            return r;
        }
        return null;
    }

    public Region getFirstRegion() {
        if (this.regions.isEmpty()) {
            return null;
        }
        return this.regions.get(0);
    }

    public void save() {
        Path path = SpawnElytraConfig.getConfigPath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Region {
        @SerializedName(value="dimension")
        public String dimension;
        @SerializedName(value="minX")
        public int minX;
        @SerializedName(value="minY")
        public int minY;
        @SerializedName(value="minZ")
        public int minZ;
        @SerializedName(value="maxX")
        public int maxX;
        @SerializedName(value="maxY")
        public int maxY;
        @SerializedName(value="maxZ")
        public int maxZ;

        public boolean contains(class_2960 worldId, double x, double y, double z) {
            if (worldId == null) {
                return false;
            }
            if (!worldId.toString().equals(this.dimension)) {
                return false;
            }
            return x >= (double)Math.min(this.minX, this.maxX) && x <= (double)Math.max(this.minX, this.maxX) && y >= (double)Math.min(this.minY, this.maxY) && y <= (double)Math.max(this.minY, this.maxY) && z >= (double)Math.min(this.minZ, this.maxZ) && z <= (double)Math.max(this.minZ, this.maxZ);
        }
    }
}

