/*
 * Decompiled with CFR 0.152.
 */
package de.kokoio01.spawnglider.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class States {
    public static Map<UUID, Boolean> GlidingEnabled = new HashMap<UUID, Boolean>();
    public static Set<UUID> FlyingPlayers = new HashSet<UUID>();
    public static Map<UUID, Long> GracePeriodEndTimes = new HashMap<UUID, Long>();
    public static Map<UUID, Integer> FlyingTicks = new HashMap<UUID, Integer>();

    public static boolean isGlidingEnabled(UUID uuid) {
        return GlidingEnabled.getOrDefault(uuid, true);
    }

    public static void setGlidingEnabled(UUID uuid, boolean value) {
        GlidingEnabled.put(uuid, value);
    }

    public static boolean isFlying(UUID uuid) {
        return FlyingPlayers.contains(uuid);
    }

    public static void setFlying(UUID uuid, boolean flying) {
        if (flying) {
            FlyingPlayers.add(uuid);
        } else {
            FlyingPlayers.remove(uuid);
        }
    }

    public static int getFlyingTicks(UUID uuid) {
        return FlyingTicks.getOrDefault(uuid, 0);
    }

    public static void incrementFlyingTicks(UUID uuid) {
        FlyingTicks.put(uuid, States.getFlyingTicks(uuid) + 1);
    }

    public static void resetFlyingTicks(UUID uuid) {
        FlyingTicks.remove(uuid);
    }

    public static boolean isInGracePeriod(UUID uuid) {
        Long endTime = GracePeriodEndTimes.get(uuid);
        if (endTime == null) {
            return false;
        }
        return System.currentTimeMillis() < endTime;
    }

    public static void startGracePeriod(UUID uuid, long ticks) {
        long durationMs = ticks * 50L;
        GracePeriodEndTimes.put(uuid, System.currentTimeMillis() + durationMs);
    }

    public static void clearGracePeriod(UUID uuid) {
        GracePeriodEndTimes.remove(uuid);
    }
}

