/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchunkhoppers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import jn.willfrydev.xchunkhoppers.xChunkHoppers;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager {
    private final xChunkHoppers plugin;
    private File file;
    private FileConfiguration dataConfig;

    public DataManager(xChunkHoppers plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "data.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.SEVERE, "No se pudo crear data.yml", e);
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void saveData() {
        try {
            this.dataConfig.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "No se pudo guardar data.yml", e);
        }
    }

    public void addHopper(Location loc, String type) {
        String locStr = this.locToString(loc);
        this.dataConfig.set("hoppers." + locStr, (Object)type);
        this.saveData();
    }

    public void removeHopper(Location loc) {
        String locStr = this.locToString(loc);
        this.dataConfig.set("hoppers." + locStr, null);
        this.saveData();
    }

    public Map<Location, String> loadHoppers() {
        HashMap<Location, String> loaded = new HashMap<Location, String>();
        if (this.dataConfig.getConfigurationSection("hoppers") == null) {
            return loaded;
        }
        for (String key : this.dataConfig.getConfigurationSection("hoppers").getKeys(false)) {
            String type = this.dataConfig.getString("hoppers." + key);
            Location loc = this.stringToLoc(key);
            if (loc == null || type == null) continue;
            loaded.put(loc, type);
        }
        return loaded;
    }

    private String locToString(Location loc) {
        if (loc.getWorld() == null) {
            return "";
        }
        return loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    private Location stringToLoc(String str) {
        String[] parts = str.split(",");
        if (parts.length != 4) {
            return null;
        }
        World w = Bukkit.getWorld((String)parts[0]);
        if (w == null) {
            return null;
        }
        int x = Integer.parseInt(parts[1]);
        int y = Integer.parseInt(parts[2]);
        int z = Integer.parseInt(parts[3]);
        return new Location(w, (double)x, (double)y, (double)z);
    }
}

