/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchunkhoppers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jn.willfrydev.xchunkhoppers.xChunkHoppers;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GUI
implements Listener {
    private final xChunkHoppers plugin;
    private final NamespacedKey typeKey;
    private final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public GUI(xChunkHoppers plugin) {
        this.plugin = plugin;
        this.typeKey = new NamespacedKey((Plugin)plugin, "hopper_type");
    }

    public void openMenu(Player player) {
        ConfigurationSection section;
        String title = this.colorize(this.plugin.getConfig().getString("menu.title", "&8Hoppers Menu"));
        int size = this.plugin.getConfig().getInt("menu.size", 27);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)title);
        if (this.plugin.getConfig().getBoolean("menu.fill.enabled")) {
            ItemStack filler = new ItemStack(Material.valueOf((String)this.plugin.getConfig().getString("menu.fill.material", "BLACK_STAINED_GLASS_PANE")));
            ItemMeta meta = filler.getItemMeta();
            meta.setDisplayName(" ");
            filler.setItemMeta(meta);
            for (int i = 0; i < size; ++i) {
                inv.setItem(i, filler);
            }
        }
        if ((section = this.plugin.getConfig().getConfigurationSection("hopper-types")) != null) {
            int slotIndex = 0;
            for (String key : section.getKeys(false)) {
                if (slotIndex >= size) break;
                ItemStack hopperItem = this.plugin.getHopperItem(key, 1);
                inv.setItem(slotIndex + 10, hopperItem);
                ++slotIndex;
            }
        }
        player.openInventory(inv);
        this.playSound(player);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = this.colorize(this.plugin.getConfig().getString("menu.title", "&8Hoppers Menu"));
        if (!event.getView().getTitle().equals(title)) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta != null && meta.getPersistentDataContainer().has(this.typeKey, PersistentDataType.STRING)) {
            String type = (String)meta.getPersistentDataContainer().get(this.typeKey, PersistentDataType.STRING);
            player.getInventory().addItem(new ItemStack[]{this.plugin.getHopperItem(type, 1)});
            player.sendMessage(this.colorize(this.plugin.getConfig().getString("messages.received")));
            this.playSound(player);
        }
    }

    private void playSound(Player player) {
        if (this.plugin.getConfig().getBoolean("effects.sound.enabled")) {
            try {
                String s = this.plugin.getConfig().getString("effects.sound.type", "UI_BUTTON_CLICK");
                player.playSound(player.getLocation(), Sound.valueOf((String)s), 1.0f, 1.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String colorize(String message) {
        if (message == null) {
            return "";
        }
        Matcher matcher = this.HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            try {
                String hexCode = matcher.group(1);
                matcher.appendReplacement(buffer, net.md_5.bungee.api.ChatColor.of((String)("#" + hexCode)).toString());
            }
            catch (Exception exception) {}
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }
}

