/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchunkhoppers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jn.willfrydev.xchunkhoppers.DataManager;
import jn.willfrydev.xchunkhoppers.GUI;
import jn.willfrydev.xchunkhoppers.api.ChunkHopperAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.Hopper;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class xChunkHoppers
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter,
ChunkHopperAPI {
    private static xChunkHoppers instance;
    private NamespacedKey typeKey;
    private final Map<Location, String> hopperCache = new HashMap<Location, String>();
    private final Map<String, Integer> typeRadiusMap = new HashMap<String, Integer>();
    private DataManager dataManager;
    private GUI menuGUI;
    private List<String> filterList;
    private boolean useWhitelist;
    private boolean isEnabled;
    private final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public static ChunkHopperAPI getAPI() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.dataManager = new DataManager(this);
        this.typeKey = new NamespacedKey((Plugin)this, "hopper_type");
        this.loadConfiguration();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.menuGUI = new GUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.menuGUI, (Plugin)this);
        PluginCommand cmd = this.getCommand("xchunkhopper");
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)this);
            cmd.setTabCompleter((TabCompleter)this);
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new HopperExpansion(this).register();
        }
        this.log(this.colorize("&a&lxChunkHoppers &7(v" + this.getDescription().getVersion() + ") &bActivado."));
    }

    public void onDisable() {
        this.dataManager.saveData();
        this.hopperCache.clear();
        this.log(this.colorize("&c&lxChunkHoppers Desactivado."));
    }

    private void log(String msg) {
        Bukkit.getConsoleSender().sendMessage("[xChunkHoppers] " + msg);
    }

    public void loadConfiguration() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.isEnabled = config.getBoolean("settings.enabled", true);
        this.useWhitelist = config.getBoolean("settings.use-whitelist", false);
        this.filterList = config.getStringList("settings.filter-list");
        this.typeRadiusMap.clear();
        ConfigurationSection section = config.getConfigurationSection("hopper-types");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                int radius = section.getInt(key + ".radius", -1);
                this.typeRadiusMap.put(key, radius);
            }
        }
        this.hopperCache.clear();
        this.hopperCache.putAll(this.dataManager.loadHoppers());
    }

    private String colorize(String message) {
        if (message == null) {
            return "";
        }
        Matcher matcher = this.HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            try {
                String hexCode = matcher.group(1);
                matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hexCode)).toString());
            }
            catch (Exception exception) {}
        }
        matcher.appendTail(buffer);
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }

    @Override
    public boolean isChunkHopper(Block block) {
        return this.hopperCache.containsKey(block.getLocation());
    }

    @Override
    public Location getHopperLocation(Chunk chunk) {
        for (Map.Entry<Location, String> entry : this.hopperCache.entrySet()) {
            if (!entry.getKey().getChunk().equals(chunk)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public boolean hasHopper(Chunk chunk) {
        return this.getHopperLocation(chunk) != null;
    }

    @Override
    public ItemStack getHopperItem(int amount) {
        return this.getHopperItem("default", amount);
    }

    public ItemStack getHopperItem(String type, int amount) {
        if (!this.typeRadiusMap.containsKey(type)) {
            return new ItemStack(Material.HOPPER, amount);
        }
        ItemStack item = new ItemStack(Material.HOPPER, amount);
        ItemMeta meta = item.getItemMeta();
        FileConfiguration config = this.getConfig();
        String path = "hopper-types." + type;
        if (meta != null) {
            String name = this.colorize(config.getString(path + ".name", "&dHopper"));
            meta.setDisplayName(name);
            List lore = config.getStringList(path + ".lore").stream().map(this::colorize).collect(Collectors.toList());
            meta.setLore(lore);
            meta.getPersistentDataContainer().set(this.typeKey, PersistentDataType.STRING, (Object)type);
            item.setItemMeta(meta);
        }
        return item;
    }

    @Override
    public Collection<String> getFilterList() {
        return Collections.unmodifiableList(this.filterList);
    }

    private String getMsg(String key) {
        String msg = this.getConfig().getString("messages." + key);
        if (msg == null) {
            return key;
        }
        String prefix = this.getConfig().getString("messages.prefix", "");
        return this.colorize(prefix + msg);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        PersistentDataContainer container;
        if (!this.isEnabled) {
            return;
        }
        ItemStack item = event.getItemInHand();
        if (item.getType() == Material.HOPPER && item.getItemMeta() != null && (container = item.getItemMeta().getPersistentDataContainer()).has(this.typeKey, PersistentDataType.STRING)) {
            String type = (String)container.get(this.typeKey, PersistentDataType.STRING);
            if (!event.getPlayer().hasPermission(this.getConfig().getString("permissions.place"))) {
                event.getPlayer().sendMessage(this.getMsg("no-permission"));
                event.setCancelled(true);
                return;
            }
            Location loc = event.getBlock().getLocation();
            this.dataManager.addHopper(loc, type);
            this.hopperCache.put(loc, type);
            String typeName = this.getConfig().getString("hopper-types." + type + ".name", type);
            event.getPlayer().sendMessage(this.getMsg("placed").replace("%type%", this.colorize(typeName)));
            this.playEffects(loc);
        }
    }

    private void playEffects(Location location) {
        FileConfiguration config = this.getConfig();
        Location center = location.clone().add(0.5, 1.0, 0.5);
        if (config.getBoolean("effects.sound.enabled")) {
            try {
                String s = config.getString("effects.sound.type");
                location.getWorld().playSound(location, Sound.valueOf((String)s), 1.0f, 1.0f);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        if (config.getBoolean("effects.particles.enabled")) {
            try {
                String p = config.getString("effects.particles.type");
                location.getWorld().spawnParticle(Particle.valueOf((String)p), center, config.getInt("effects.particles.count"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.isEnabled) {
            return;
        }
        if (this.hopperCache.containsKey(event.getBlock().getLocation())) {
            if (!event.getPlayer().hasPermission(this.getConfig().getString("permissions.break"))) {
                event.getPlayer().sendMessage(this.getMsg("no-permission"));
                event.setCancelled(true);
                return;
            }
            String type = this.hopperCache.get(event.getBlock().getLocation());
            this.dataManager.removeHopper(event.getBlock().getLocation());
            this.hopperCache.remove(event.getBlock().getLocation());
            event.setDropItems(false);
            event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), this.getHopperItem(type, 1));
            event.getPlayer().sendMessage(this.getMsg("broken"));
        }
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        if (!this.isEnabled) {
            return;
        }
        Location itemLoc = event.getLocation();
        for (Map.Entry<Location, String> entry : this.hopperCache.entrySet()) {
            Location hopperLoc = entry.getKey();
            if (!hopperLoc.getWorld().equals(itemLoc.getWorld())) continue;
            String type = entry.getValue();
            int radius = this.typeRadiusMap.getOrDefault(type, -1);
            boolean shouldCollect = false;
            if (radius == -1) {
                if (hopperLoc.getChunk().equals(itemLoc.getChunk())) {
                    shouldCollect = true;
                }
            } else if (hopperLoc.distance(itemLoc) <= (double)radius) {
                shouldCollect = true;
            }
            if (!shouldCollect) continue;
            Block block = hopperLoc.getBlock();
            if (block.getState() instanceof Hopper) {
                Hopper hopper = (Hopper)block.getState();
                ItemStack item = event.getEntity().getItemStack();
                boolean inList = this.filterList.contains(item.getType().toString());
                if (this.useWhitelist && !inList || !this.useWhitelist && inList) {
                    return;
                }
                event.setCancelled(true);
                HashMap leftover = hopper.getInventory().addItem(new ItemStack[]{item});
                if (!leftover.isEmpty()) {
                    for (ItemStack drop : leftover.values()) {
                        block.getWorld().dropItemNaturally(hopperLoc.add(0.5, 1.2, 0.5), drop);
                    }
                }
                return;
            }
            this.dataManager.removeHopper(hopperLoc);
            this.hopperCache.remove(hopperLoc);
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission(this.getConfig().getString("permissions.admin"))) {
            sender.sendMessage(this.getMsg("no-permission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(this.colorize("&#fb00ff&lxChunkHoppers &7v" + this.getDescription().getVersion()));
            sender.sendMessage(this.colorize("&7/xch menu &8- &fAbrir men\u00fa"));
            sender.sendMessage(this.colorize("&7/xch give <player> <type> &8- &fDar item"));
            sender.sendMessage(this.colorize("&7/xch reload"));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            this.loadConfiguration();
            sender.sendMessage(this.getMsg("reload"));
            return true;
        }
        if (args[0].equalsIgnoreCase("menu")) {
            if (sender instanceof Player) {
                this.menuGUI.openMenu((Player)sender);
            } else {
                sender.sendMessage(String.valueOf(org.bukkit.ChatColor.RED) + "Solo para jugadores.");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("give")) {
            if (args.length < 3) {
                sender.sendMessage(this.colorize("&cUso: /xch give <player> <type> [amount]"));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            String type = args[2].toLowerCase();
            if (target == null) {
                sender.sendMessage(this.getMsg("player-not-found"));
                return true;
            }
            if (!this.typeRadiusMap.containsKey(type)) {
                sender.sendMessage(this.getMsg("type-not-found"));
                return true;
            }
            int amount = 1;
            if (args.length >= 4) {
                try {
                    amount = Integer.parseInt(args[3]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            target.getInventory().addItem(new ItemStack[]{this.getHopperItem(type, amount)});
            sender.sendMessage(this.getMsg("give-success").replace("%amount%", String.valueOf(amount)).replace("%type%", type).replace("%player%", target.getName()));
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (!sender.hasPermission("xchunkhoppers.admin")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return Arrays.asList("give", "menu", "reload");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            return null;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("give")) {
            return new ArrayList<String>(this.typeRadiusMap.keySet());
        }
        return Collections.emptyList();
    }

    public static class HopperExpansion
    extends PlaceholderExpansion {
        private final xChunkHoppers plugin;

        public HopperExpansion(xChunkHoppers plugin) {
            this.plugin = plugin;
        }

        @NotNull
        public String getIdentifier() {
            return "xchunkhopper";
        }

        @NotNull
        public String getAuthor() {
            return "WillfryDev";
        }

        @NotNull
        public String getVersion() {
            return this.plugin.getDescription().getVersion();
        }

        public boolean persist() {
            return true;
        }

        public String onPlaceholderRequest(Player player, @NotNull String params) {
            if (params.equalsIgnoreCase("count")) {
                return String.valueOf(this.plugin.hopperCache.size());
            }
            return null;
        }
    }
}

