/*
 * Decompiled with CFR 0.152.
 */
package com.mryarg1ch.storylineofmineyarg.apocalypse;

import com.mryarg1ch.storylineofmineyarg.StorylineOfMineyarg;
import com.mryarg1ch.storylineofmineyarg.config.ApocalypseConfig;
import com.mryarg1ch.storylineofmineyarg.data.ApocalypseDataManager;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\nH\u0002J\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u001a\u001a\u00020\nJ\u0006\u0010\u001b\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010\u001d\u001a\u00020\nJ\b\u0010\u001e\u001a\u00020\nH\u0002J\u0006\u0010\u001f\u001a\u00020\nJ\u0010\u0010 \u001a\u00020\n2\b\b\u0002\u0010!\u001a\u00020\u0004J\b\u0010\"\u001a\u00020\nH\u0002J\b\u0010#\u001a\u00020\nH\u0002J\b\u0010$\u001a\u00020\nH\u0002J\b\u0010%\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/mryarg1ch/storylineofmineyarg/apocalypse/ApocalypseManager;", "", "()V", "isRunning", "", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "server", "Lnet/minecraft/server/MinecraftServer;", "applyMobEvolution", "", "mob", "Lnet/minecraft/world/entity/monster/Monster;", "applySnowInRadius", "level", "Lnet/minecraft/server/level/ServerLevel;", "center", "Lnet/minecraft/core/BlockPos;", "radius", "", "checkApocalypseEvents", "equipBetterArmor", "expandSnowfall", "isActive", "isPaused", "onServerStart", "onServerStop", "pauseApocalypse", "resumeApocalypse", "startApocalypse", "startApocalypseLoop", "startTestMode", "stopApocalypse", "resetProgress", "stopApocalypseLoop", "triggerMobEvolution", "triggerMobSpawnIncrease", "triggerSnowfall", "storylineofmineyarg"})
@SourceDebugExtension(value={"SMAP\nApocalypseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApocalypseManager.kt\ncom/mryarg1ch/storylineofmineyarg/apocalypse/ApocalypseManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,352:1\n1#2:353\n1855#3,2:354\n1855#3,2:356\n1855#3,2:358\n1855#3,2:360\n1864#3,3:362\n*S KotlinDebug\n*F\n+ 1 ApocalypseManager.kt\ncom/mryarg1ch/storylineofmineyarg/apocalypse/ApocalypseManager\n*L\n185#1:354,2\n200#1:356,2\n221#1:358,2\n248#1:360,2\n346#1:362,3\n*E\n"})
public final class ApocalypseManager {
    @Nullable
    private MinecraftServer server;
    @NotNull
    private final ScheduledExecutorService scheduler;
    private boolean isRunning;

    public ApocalypseManager() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
        this.scheduler = scheduledExecutorService;
    }

    public final void onServerStart(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        if (StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypseActive()) {
            this.startApocalypseLoop();
        }
    }

    public final void onServerStop() {
        this.stopApocalypseLoop();
        this.scheduler.shutdown();
    }

    public final boolean isActive() {
        return StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypseActive();
    }

    public final boolean isPaused() {
        return StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypsePaused();
    }

    public final void startApocalypse() {
        block0: {
            StorylineOfMineyarg.INSTANCE.getDataManager().startApocalypse(false);
            this.startApocalypseLoop();
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block0;
            MinecraftServer it = minecraftServer;
            boolean bl = false;
            StorylineOfMineyarg.INSTANCE.getDataManager().saveData(it);
        }
    }

    public final void startTestMode() {
        block0: {
            StorylineOfMineyarg.INSTANCE.getDataManager().startApocalypse(true);
            this.startApocalypseLoop();
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block0;
            MinecraftServer it = minecraftServer;
            boolean bl = false;
            StorylineOfMineyarg.INSTANCE.getDataManager().saveData(it);
        }
    }

    public final void stopApocalypse(boolean resetProgress) {
        block0: {
            StorylineOfMineyarg.INSTANCE.getDataManager().stopApocalypse(resetProgress);
            this.stopApocalypseLoop();
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block0;
            MinecraftServer it = minecraftServer;
            boolean bl = false;
            StorylineOfMineyarg.INSTANCE.getDataManager().saveData(it);
        }
    }

    public static /* synthetic */ void stopApocalypse$default(ApocalypseManager apocalypseManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        apocalypseManager.stopApocalypse(bl);
    }

    public final void pauseApocalypse() {
        block0: {
            StorylineOfMineyarg.INSTANCE.getDataManager().pauseApocalypse();
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block0;
            MinecraftServer it = minecraftServer;
            boolean bl = false;
            StorylineOfMineyarg.INSTANCE.getDataManager().saveData(it);
        }
    }

    public final void resumeApocalypse() {
        block0: {
            StorylineOfMineyarg.INSTANCE.getDataManager().resumeApocalypse();
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block0;
            MinecraftServer it = minecraftServer;
            boolean bl = false;
            StorylineOfMineyarg.INSTANCE.getDataManager().saveData(it);
        }
    }

    private final void startApocalypseLoop() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.scheduler.scheduleAtFixedRate(() -> ApocalypseManager.startApocalypseLoop$lambda$5(this), 0L, 5L, TimeUnit.SECONDS);
        this.scheduler.scheduleAtFixedRate(() -> ApocalypseManager.startApocalypseLoop$lambda$6(this), 10L, 10L, TimeUnit.SECONDS);
        StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u0426\u0438\u043a\u043b \u0430\u043f\u043e\u043a\u0430\u043b\u0438\u043f\u0441\u0438\u0441\u0430 \u0437\u0430\u043f\u0443\u0449\u0435\u043d");
    }

    private final void stopApocalypseLoop() {
        this.isRunning = false;
        StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u0426\u0438\u043a\u043b \u0430\u043f\u043e\u043a\u0430\u043b\u0438\u043f\u0441\u0438\u0441\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
    }

    private final void checkApocalypseEvents() {
        block5: {
            int evolutionThreshold;
            MinecraftServer it;
            ApocalypseDataManager dataManager = StorylineOfMineyarg.INSTANCE.getDataManager();
            ApocalypseConfig config = StorylineOfMineyarg.INSTANCE.getConfig();
            if (!dataManager.getMobSpawnIncreaseTriggered() && dataManager.shouldTriggerEvent(config.getDaysUntilMobSpawnIncrease(), config.getMobSpawnCoefficient())) {
                this.triggerMobSpawnIncrease();
                dataManager.setMobSpawnIncreaseTriggered(true);
                MinecraftServer minecraftServer = this.server;
                if (minecraftServer != null) {
                    it = minecraftServer;
                    boolean bl = false;
                    dataManager.saveData(it);
                }
            }
            if (!dataManager.getSnowfallTriggered() && dataManager.shouldTriggerEvent(config.getDaysUntilSnowfall(), config.getSnowfallSpeedCoefficient())) {
                this.triggerSnowfall();
                dataManager.setSnowfallTriggered(true);
                MinecraftServer minecraftServer = this.server;
                if (minecraftServer != null) {
                    it = minecraftServer;
                    boolean bl = false;
                    dataManager.saveData(it);
                }
            }
            if (!dataManager.shouldTriggerEvent(evolutionThreshold = config.getDaysUntilMobEvolution() + dataManager.getMobEvolutionLevel() * 3, config.getMobEvolutionSpeedCoefficient())) break block5;
            this.triggerMobEvolution();
            int n = dataManager.getMobEvolutionLevel();
            dataManager.setMobEvolutionLevel(n + 1);
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer != null) {
                MinecraftServer it2 = minecraftServer;
                boolean bl = false;
                dataManager.saveData(it2);
            }
        }
    }

    private final void triggerMobSpawnIncrease() {
        block1: {
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block1;
            MinecraftServer server = minecraftServer;
            boolean bl = false;
            String message = "\u00a7c\u00a7l[\u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0421\u0418\u0421] \u00a7r\u00a7c\u0421\u043f\u0430\u0432\u043d \u0430\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u044b\u0445 \u043c\u043e\u0431\u043e\u0432 \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d!";
            List list = server.m_6846_().m_11314_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerPlayer player = (ServerPlayer)element$iv;
                boolean bl2 = false;
                player.m_213846_((Component)Component.m_237113_((String)message));
            }
            StorylineOfMineyarg.logAndMessage$default(StorylineOfMineyarg.INSTANCE, "\u0423\u0432\u0435\u043b\u0438\u0447\u0435\u043d \u0441\u043f\u0430\u0432\u043d \u0430\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u044b\u0445 \u043c\u043e\u0431\u043e\u0432", null, 2, null);
        }
    }

    private final void triggerSnowfall() {
        block1: {
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block1;
            MinecraftServer server = minecraftServer;
            boolean bl = false;
            String message = "\u00a7f\u00a7l[\u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0421\u0418\u0421] \u00a7r\u00a7f\u041d\u0430\u0447\u0430\u043b\u0441\u044f \u0432\u0435\u0447\u043d\u044b\u0439 \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434! \u0425\u043e\u043b\u043e\u0434 \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u043e \u043c\u0438\u0440\u0443...";
            List list = server.m_6846_().m_11314_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerPlayer player = (ServerPlayer)element$iv;
                boolean bl2 = false;
                player.m_213846_((Component)Component.m_237113_((String)message));
            }
            StorylineOfMineyarg.logAndMessage$default(StorylineOfMineyarg.INSTANCE, "\u041d\u0430\u0447\u0430\u043b\u0441\u044f \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434", null, 2, null);
        }
    }

    private final void triggerMobEvolution() {
        block5: {
            int evolutionLevel = StorylineOfMineyarg.INSTANCE.getDataManager().getMobEvolutionLevel();
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block5;
            MinecraftServer server = minecraftServer;
            boolean bl = false;
            String message = switch (evolutionLevel) {
                case 0 -> "\u00a7c\u00a7l[\u042d\u0412\u041e\u041b\u042e\u0426\u0418\u042f] \u00a7r\u00a7c\u041c\u043e\u0431\u044b \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0433\u043e\u0440\u044f\u0442 \u043d\u0430 \u0441\u043e\u043b\u043d\u0446\u0435!";
                case 1 -> "\u00a7c\u00a7l[\u042d\u0412\u041e\u041b\u042e\u0426\u0418\u042f] \u00a7r\u00a7c\u041c\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u043d\u043e\u0435 \u0441\u043d\u0430\u0440\u044f\u0436\u0435\u043d\u0438\u0435!";
                default -> "\u00a7c\u00a7l[\u042d\u0412\u041e\u041b\u042e\u0426\u0418\u042f] \u00a7r\u00a7c\u041c\u043e\u0431\u044b \u0441\u0442\u0430\u043b\u0438 \u0441\u0438\u043b\u044c\u043d\u0435\u0435, \u0431\u044b\u0441\u0442\u0440\u0435\u0435 \u0438 \u043e\u043f\u0430\u0441\u043d\u0435\u0435!";
            };
            List list = server.m_6846_().m_11314_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerPlayer player = (ServerPlayer)element$iv;
                boolean bl2 = false;
                player.m_213846_((Component)Component.m_237113_((String)message));
            }
            StorylineOfMineyarg.logAndMessage$default(StorylineOfMineyarg.INSTANCE, "\u042d\u0432\u043e\u043b\u044e\u0446\u0438\u044f \u043c\u043e\u0431\u043e\u0432: \u0443\u0440\u043e\u0432\u0435\u043d\u044c " + evolutionLevel, null, 2, null);
        }
    }

    private final void expandSnowfall() {
        ApocalypseDataManager dataManager = StorylineOfMineyarg.INSTANCE.getDataManager();
        BlockPos blockPos = dataManager.getSnowCenter();
        if (blockPos == null) {
            return;
        }
        BlockPos snowCenter = blockPos;
        MinecraftServer minecraftServer = this.server;
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        int speedCoeff = StorylineOfMineyarg.INSTANCE.getConfig().getSnowfallSpeedCoefficient();
        int radiusIncrease = dataManager.isTestMode() ? RangesKt.coerceAtLeast((int)(speedCoeff / 10), (int)1) : RangesKt.coerceAtLeast((int)(speedCoeff / 50), (int)1);
        dataManager.setCurrentSnowRadius(dataManager.getCurrentSnowRadius() + radiusIncrease);
        Iterable iterable = server.m_129785_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerLevel level = (ServerLevel)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)level.m_46472_(), (Object)Level.f_46428_)) continue;
            Intrinsics.checkNotNull((Object)level);
            this.applySnowInRadius(level, snowCenter, dataManager.getCurrentSnowRadius());
        }
        MinecraftServer it = server;
        boolean bl = false;
        dataManager.saveData(it);
        if (StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) {
            StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u0421\u043d\u0435\u0433\u043e\u043f\u0430\u0434 \u0440\u0430\u0441\u0448\u0438\u0440\u0438\u043b\u0441\u044f \u0434\u043e \u0440\u0430\u0434\u0438\u0443\u0441\u0430 " + dataManager.getCurrentSnowRadius());
        }
    }

    private final void applySnowInRadius(ServerLevel level, BlockPos center, int radius) {
        Random random = new Random();
        int blocksToProcess = RangesKt.coerceAtLeast((int)((int)((double)(radius * radius) * 0.1)), (int)10);
        for (int i = 0; i < blocksToProcess; ++i) {
            int it = i;
            boolean bl = false;
            int x = center.m_123341_() + random.nextInt(radius * 2) - radius;
            int z = center.m_123343_() + random.nextInt(radius * 2) - radius;
            double distance = Math.sqrt((x - center.m_123341_()) * (x - center.m_123341_()) + (z - center.m_123343_()) * (z - center.m_123343_()));
            if (!(distance <= (double)radius)) continue;
            BlockPos pos = new BlockPos(x, level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z), z);
            if (level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)level, pos.m_7495_())) {
                level.m_7731_(pos, Blocks.f_50125_.m_49966_(), 3);
            }
            if (!Intrinsics.areEqual((Object)level.m_8055_(pos.m_7495_()).m_60734_(), (Object)Blocks.f_49990_)) continue;
            level.m_7731_(pos.m_7495_(), Blocks.f_50126_.m_49966_(), 3);
        }
    }

    public final void applyMobEvolution(@NotNull Monster mob) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        int evolutionLevel = StorylineOfMineyarg.INSTANCE.getDataManager().getMobEvolutionLevel();
        switch (evolutionLevel) {
            case 0: {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19607_, Integer.MAX_VALUE, 0, false, false));
                break;
            }
            case 1: {
                Monster monster = mob;
                if (monster instanceof Zombie) {
                    Random random = new Random();
                    if (random.nextFloat() < 0.3f) {
                        mob.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42523_));
                    }
                    Random random2 = new Random();
                    if (random2.nextFloat() < 0.2f) {
                        mob.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42584_));
                    }
                    this.equipBetterArmor(mob);
                    break;
                }
                if (!(monster instanceof Skeleton)) break;
                ItemStack bow = new ItemStack((ItemLike)Items.f_42411_);
                EnchantmentHelper.m_44865_((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)Enchantments.f_44988_, (Object)2)), (ItemStack)bow);
                mob.m_21008_(InteractionHand.MAIN_HAND, bow);
                this.equipBetterArmor(mob);
                break;
            }
            default: {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, Integer.MAX_VALUE, evolutionLevel - 2, false, false));
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19603_, Integer.MAX_VALUE, evolutionLevel - 2, false, false));
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19600_, Integer.MAX_VALUE, evolutionLevel - 2, false, false));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void equipBetterArmor(Monster mob) {
        Object[] objectArray = new ItemStack[]{new ItemStack((ItemLike)Items.f_42468_), new ItemStack((ItemLike)Items.f_42469_), new ItemStack((ItemLike)Items.f_42470_), new ItemStack((ItemLike)Items.f_42471_)};
        List armorItems = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEachIndexed$iv = armorItems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void armor;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack itemStack = (ItemStack)item$iv;
            int index = n;
            boolean bl = false;
            Random random = new Random();
            if (!(random.nextFloat() < 0.5f)) continue;
            mob.m_8061_(EquipmentSlot.values()[index + 2], (ItemStack)armor);
        }
    }

    private static final void startApocalypseLoop$lambda$5(ApocalypseManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            if (!StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypsePaused()) {
                this$0.checkApocalypseEvents();
            }
        }
        catch (Exception e) {
            StorylineOfMineyarg.INSTANCE.getLOGGER().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0446\u0438\u043a\u043b\u0435 \u0430\u043f\u043e\u043a\u0430\u043b\u0438\u043f\u0441\u0438\u0441\u0430: " + e.getMessage());
        }
    }

    private static final void startApocalypseLoop$lambda$6(ApocalypseManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            if (!StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypsePaused() && StorylineOfMineyarg.INSTANCE.getDataManager().getSnowfallTriggered()) {
                this$0.expandSnowfall();
            }
        }
        catch (Exception e) {
            StorylineOfMineyarg.INSTANCE.getLOGGER().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0441\u043d\u0435\u0433\u0430: " + e.getMessage());
        }
    }
}

