/*
 * Decompiled with CFR 0.152.
 */
package com.mryarg1ch.storylineofmineyarg.apocalypse;

import com.mryarg1ch.storylineofmineyarg.StorylineOfMineyarg;
import com.mryarg1ch.storylineofmineyarg.data.ApocalypseDataManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\u0011J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0002J(\u0010\u001a\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/mryarg1ch/storylineofmineyarg/apocalypse/WeatherManager;", "", "()V", "isRunning", "", "random", "Ljava/util/Random;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "server", "Lnet/minecraft/server/MinecraftServer;", "isInSnowBiome", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "notifyPlayersInSnowZone", "", "center", "radius", "", "shouldSnow", "onServerStart", "onServerStop", "startWeatherLoop", "stopWeatherLoop", "updateWeatherInLevel", "updateWeatherInSnowBiomes", "storylineofmineyarg"})
@SourceDebugExtension(value={"SMAP\nWeatherManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeatherManager.kt\ncom/mryarg1ch/storylineofmineyarg/apocalypse/WeatherManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1855#2,2:159\n1855#2,2:162\n1#3:161\n*S KotlinDebug\n*F\n+ 1 WeatherManager.kt\ncom/mryarg1ch/storylineofmineyarg/apocalypse/WeatherManager\n*L\n79#1:159,2\n133#1:162,2\n*E\n"})
public final class WeatherManager {
    @Nullable
    private MinecraftServer server;
    @NotNull
    private final ScheduledExecutorService scheduler;
    @NotNull
    private final Random random;
    private boolean isRunning;

    public WeatherManager() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        this.scheduler = scheduledExecutorService;
        this.random = new Random();
    }

    public final void onServerStart(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        this.startWeatherLoop();
    }

    public final void onServerStop() {
        this.stopWeatherLoop();
        this.scheduler.shutdown();
    }

    private final void startWeatherLoop() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.scheduler.scheduleAtFixedRate(() -> WeatherManager.startWeatherLoop$lambda$0(this), 0L, 10L, TimeUnit.MINUTES);
    }

    private final void stopWeatherLoop() {
        this.isRunning = false;
    }

    private final void updateWeatherInSnowBiomes() {
        MinecraftServer minecraftServer = this.server;
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        ApocalypseDataManager dataManager = StorylineOfMineyarg.INSTANCE.getDataManager();
        BlockPos blockPos = dataManager.getSnowCenter();
        if (blockPos == null) {
            return;
        }
        BlockPos snowCenter = blockPos;
        if (!dataManager.getSnowfallTriggered()) {
            return;
        }
        boolean shouldSnow = this.random.nextBoolean();
        Iterable iterable = server.m_129785_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerLevel level = (ServerLevel)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)level.m_46472_(), (Object)Level.f_46428_)) continue;
            Intrinsics.checkNotNull((Object)level);
            this.updateWeatherInLevel(level, snowCenter, dataManager.getCurrentSnowRadius(), shouldSnow);
        }
        if (StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) {
            String weatherType = shouldSnow ? "\u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434" : "\u044f\u0441\u043d\u0430\u044f \u043f\u043e\u0433\u043e\u0434\u0430";
            StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u041f\u043e\u0433\u043e\u0434\u0430 \u0432 \u0441\u043d\u0435\u0436\u043d\u043e\u0439 \u0437\u043e\u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0430 \u043d\u0430: " + weatherType);
        }
    }

    private final void updateWeatherInLevel(ServerLevel level, BlockPos center, int radius, boolean shouldSnow) {
        try {
            Field serverLevelDataField = level.getClass().getDeclaredField("serverLevelData");
            serverLevelDataField.setAccessible(true);
            Object serverLevelData = serverLevelDataField.get(level);
            if (shouldSnow) {
                Object object = new Class[]{Boolean.TYPE};
                Method method = serverLevelData.getClass().getMethod("setRaining", (Class<?>)object);
                object = new Object[]{true};
                method.invoke(serverLevelData, (Object[])object);
                object = new Class[]{Boolean.TYPE};
                Method method2 = serverLevelData.getClass().getMethod("setThundering", (Class<?>)object);
                object = new Object[]{false};
                method2.invoke(serverLevelData, (Object[])object);
                Object $this$updateWeatherInLevel_u24lambda_u242 = object = serverLevelData.getClass().getDeclaredField("rainTime");
                boolean bl = false;
                ((Field)$this$updateWeatherInLevel_u24lambda_u242).setAccessible(true);
                ((Field)object).set(serverLevelData, 12000);
                Object $this$updateWeatherInLevel_u24lambda_u243 = object = serverLevelData.getClass().getDeclaredField("clearWeatherTime");
                boolean bl2 = false;
                ((Field)$this$updateWeatherInLevel_u24lambda_u243).setAccessible(true);
                ((Field)object).set(serverLevelData, 0);
            } else {
                Object object = new Class[]{Boolean.TYPE};
                Method method = serverLevelData.getClass().getMethod("setRaining", (Class<?>)object);
                object = new Object[]{false};
                method.invoke(serverLevelData, (Object[])object);
                object = new Class[]{Boolean.TYPE};
                Method method3 = serverLevelData.getClass().getMethod("setThundering", (Class<?>)object);
                object = new Object[]{false};
                method3.invoke(serverLevelData, (Object[])object);
                Object $this$updateWeatherInLevel_u24lambda_u244 = object = serverLevelData.getClass().getDeclaredField("clearWeatherTime");
                boolean bl = false;
                ((Field)$this$updateWeatherInLevel_u24lambda_u244).setAccessible(true);
                ((Field)object).set(serverLevelData, 12000);
                Object $this$updateWeatherInLevel_u24lambda_u245 = object = serverLevelData.getClass().getDeclaredField("rainTime");
                boolean bl3 = false;
                ((Field)$this$updateWeatherInLevel_u24lambda_u245).setAccessible(true);
                ((Field)object).set(serverLevelData, 0);
            }
        }
        catch (Exception e) {
            StorylineOfMineyarg.INSTANCE.getLOGGER().warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0433\u043e\u0434\u0443: " + e.getMessage());
        }
        this.notifyPlayersInSnowZone(level, center, radius, shouldSnow);
    }

    private final void notifyPlayersInSnowZone(ServerLevel level, BlockPos center, int radius, boolean shouldSnow) {
        String message = shouldSnow ? "\u00a7f\u2744 \u0412 \u0441\u043d\u0435\u0436\u043d\u043e\u0439 \u0437\u043e\u043d\u0435 \u043d\u0430\u0447\u0430\u043b\u0441\u044f \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434!" : "\u00a77\u2600 \u0412 \u0441\u043d\u0435\u0436\u043d\u043e\u0439 \u0437\u043e\u043d\u0435 \u043f\u0440\u043e\u044f\u0441\u043d\u0438\u043b\u043e\u0441\u044c.";
        List list = level.m_6907_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            BlockPos playerPos = player.m_20183_();
            double distance = Math.sqrt((playerPos.m_123341_() - center.m_123341_()) * (playerPos.m_123341_() - center.m_123341_()) + (playerPos.m_123343_() - center.m_123343_()) * (playerPos.m_123343_() - center.m_123343_()));
            if (!(distance <= (double)radius)) continue;
            player.m_213846_((Component)Component.m_237113_((String)message));
        }
    }

    private final boolean isInSnowBiome(ServerLevel level, BlockPos pos) {
        Holder biome = level.m_204166_(pos);
        return biome.m_203565_(Biomes.f_186761_) || biome.m_203565_(Biomes.f_48152_) || biome.m_203565_(Biomes.f_186756_) || biome.m_203565_(Biomes.f_48212_) || biome.m_203565_(Biomes.f_48182_);
    }

    private static final void startWeatherLoop$lambda$0(WeatherManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.updateWeatherInSnowBiomes();
        }
        catch (Exception e) {
            StorylineOfMineyarg.INSTANCE.getLOGGER().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u043f\u043e\u0433\u043e\u0434\u044b: " + e.getMessage());
        }
    }
}

