/*
 * Decompiled with CFR 0.152.
 */
package com.mryarg1ch.storylineofmineyarg.events;

import com.mryarg1ch.storylineofmineyarg.StorylineOfMineyarg;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004J\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004J\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R$\u0010\u0003\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/mryarg1ch/storylineofmineyarg/events/MobSpawnController;", "", "()V", "allowedHostileMobs", "", "Lnet/minecraft/world/entity/EntityType;", "kotlin.jvm.PlatformType", "bannedHostileMobs", "getAllowedHostileMobs", "getBannedHostileMobs", "isMobAllowed", "", "entityType", "onEntityJoinLevel", "", "event", "Lnet/minecraftforge/event/entity/EntityJoinLevelEvent;", "storylineofmineyarg"})
public final class MobSpawnController {
    @NotNull
    public static final MobSpawnController INSTANCE = new MobSpawnController();
    @NotNull
    private static final Set<EntityType<?>> allowedHostileMobs;
    @NotNull
    private static final Set<EntityType<?>> bannedHostileMobs;

    private MobSpawnController() {
    }

    @SubscribeEvent
    public final void onEntityJoinLevel(@NotNull EntityJoinLevelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        Level level = event.getLevel();
        if (level.f_46443_ || !Intrinsics.areEqual((Object)level.m_46472_(), (Object)Level.f_46428_)) {
            return;
        }
        if (bannedHostileMobs.contains(entity.m_6095_())) {
            event.setCanceled(true);
            if (StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) {
                StorylineOfMineyarg.INSTANCE.getLOGGER().debug("\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u0441\u043f\u0430\u0432\u043d \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u043e\u0433\u043e \u043c\u043e\u0431\u0430: " + entity.m_6095_().m_20676_().getString());
            }
            return;
        }
        if (entity instanceof Monster && !allowedHostileMobs.contains(((Monster)entity).m_6095_())) {
            event.setCanceled(true);
            if (StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) {
                StorylineOfMineyarg.INSTANCE.getLOGGER().debug("\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u0441\u043f\u0430\u0432\u043d \u043d\u0435\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u043e\u0433\u043e \u0430\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u043e\u0431\u0430: " + ((Monster)entity).m_6095_().m_20676_().getString());
            }
        }
    }

    public final boolean isMobAllowed(@NotNull EntityType<?> entityType) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        return !bannedHostileMobs.contains(entityType);
    }

    @NotNull
    public final Set<EntityType<?>> getAllowedHostileMobs() {
        return CollectionsKt.toSet((Iterable)allowedHostileMobs);
    }

    @NotNull
    public final Set<EntityType<?>> getBannedHostileMobs() {
        return CollectionsKt.toSet((Iterable)bannedHostileMobs);
    }

    static {
        Object[] objectArray = new EntityType[]{EntityType.f_20501_, EntityType.f_20551_, EntityType.f_20566_, EntityType.f_20453_, EntityType.f_20496_, EntityType.f_20497_, EntityType.f_20565_, EntityType.f_20468_, EntityType.f_20511_, EntityType.f_20531_, EntityType.f_20521_, EntityType.f_20523_, EntityType.f_20567_};
        allowedHostileMobs = SetsKt.setOf((Object[])objectArray);
        objectArray = new EntityType[]{EntityType.f_20524_, EntityType.f_20479_, EntityType.f_20554_, EntityType.f_20558_, EntityType.f_20495_, EntityType.f_20509_, EntityType.f_20526_, EntityType.f_20493_, EntityType.f_20568_, EntityType.f_20513_, EntityType.f_20518_, EntityType.f_20491_, EntityType.f_20455_, EntityType.f_20563_, EntityType.f_20562_, EntityType.f_20458_, EntityType.f_20481_, EntityType.f_20530_, EntityType.f_20512_, EntityType.f_20456_, EntityType.f_20500_};
        bannedHostileMobs = SetsKt.setOf((Object[])objectArray);
    }
}

