/*
 * Decompiled with CFR 0.152.
 */
package com.mryarg1ch.storylineofmineyarg.apocalypse;

import com.mryarg1ch.storylineofmineyarg.StorylineOfMineyarg;
import com.mryarg1ch.storylineofmineyarg.apocalypse.WeatherManager;
import com.mryarg1ch.storylineofmineyarg.config.ApocalypseConfig;
import com.mryarg1ch.storylineofmineyarg.data.ApocalypseDataManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J(\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J(\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0010H\u0002J\b\u0010!\u001a\u00020\u0010H\u0002J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0014H\u0002J(\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010(\u001a\u00020\u0010H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010.\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0006\u0010/\u001a\u00020\u0004J\u0006\u00100\u001a\u00020\u0004J\u0010\u00101\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u00102\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u00103\u001a\u00020\u0010J\u0006\u00104\u001a\u00020\u0010J\u0006\u00105\u001a\u00020\u0010J\u0006\u00106\u001a\u00020\u0010J\b\u00107\u001a\u00020\u0010H\u0002J\u0006\u00108\u001a\u00020\u0010J\u0010\u00109\u001a\u00020\u00102\b\b\u0002\u0010:\u001a\u00020\u0004J\b\u0010;\u001a\u00020\u0010H\u0002J\b\u0010<\u001a\u00020\u0010H\u0002J\b\u0010=\u001a\u00020\u0010H\u0002J\b\u0010>\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/mryarg1ch/storylineofmineyarg/apocalypse/ApocalypseManager;", "", "()V", "isRunning", "", "lastSnowExpansionTime", "", "lastWeatherChangeTime", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "server", "Lnet/minecraft/server/MinecraftServer;", "weatherManager", "Lcom/mryarg1ch/storylineofmineyarg/apocalypse/WeatherManager;", "applyBiomeToColumn", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "x", "", "z", "applyBiomeToNewRing", "center", "Lnet/minecraft/core/BlockPos;", "innerRadius", "outerRadius", "applyMobEvolution", "mob", "Lnet/minecraft/world/entity/monster/Monster;", "applySnowEffectsToSurface", "applySnowToNewRing", "checkApocalypseEvents", "checkSnowExpansion", "equipProgressiveArmor", "evolutionLevel", "equipProgressiveWeapon", "expandBiomeArea", "overworld", "snowCenter", "expandSnowfallAndBiome", "getDiamondArmor", "Lnet/minecraft/world/item/ItemStack;", "slot", "Lnet/minecraft/world/entity/EquipmentSlot;", "getIronArmor", "getLeatherArmor", "isActive", "isPaused", "manageWeatherForSnowfall", "onServerStart", "onServerStop", "pauseApocalypse", "resumeApocalypse", "startApocalypse", "startApocalypseLoop", "startTestMode", "stopApocalypse", "resetProgress", "stopApocalypseLoop", "triggerMobEvolution", "triggerMobSpawnIncrease", "triggerSnowfall", "storylineofmineyarg"})
@SourceDebugExtension(value={"SMAP\nApocalypseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApocalypseManager.kt\ncom/mryarg1ch/storylineofmineyarg/apocalypse/ApocalypseManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,654:1\n1855#2:655\n1855#2,2:656\n1856#2:658\n1855#2,2:660\n1855#2,2:662\n1855#2,2:664\n1855#2,2:666\n1855#2,2:668\n1855#2,2:670\n1#3:659\n*S KotlinDebug\n*F\n+ 1 ApocalypseManager.kt\ncom/mryarg1ch/storylineofmineyarg/apocalypse/ApocalypseManager\n*L\n81#1:655\n82#1:656,2\n81#1:658\n208#1:660,2\n242#1:662,2\n279#1:664,2\n367#1:666,2\n391#1:668,2\n529#1:670,2\n*E\n"})
public final class ApocalypseManager {
    @Nullable
    private MinecraftServer server;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private boolean isRunning;
    @NotNull
    private final WeatherManager weatherManager = new WeatherManager();
    private long lastWeatherChangeTime;
    private long lastSnowExpansionTime;

    public final void onServerStart(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        this.weatherManager.onServerStart(server);
        if (StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypseActive()) {
            this.startApocalypseLoop();
        }
    }

    public final void onServerStop() {
        this.stopApocalypseLoop();
        this.weatherManager.onServerStop();
        this.scheduler.shutdown();
    }

    public final boolean isActive() {
        return StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypseActive();
    }

    public final boolean isPaused() {
        return StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypsePaused();
    }

    public final void startApocalypse() {
        block2: {
            StorylineOfMineyarg.INSTANCE.getDataManager().startApocalypse(false);
            this.startApocalypseLoop();
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block2;
            MinecraftServer it = minecraftServer;
            boolean bl = false;
            StorylineOfMineyarg.INSTANCE.getDataManager().saveData(it);
            Iterable iterable = it.m_129785_();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerLevel level = (ServerLevel)element$iv;
                boolean bl2 = false;
                List list = level.m_6907_();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    ServerPlayer player = (ServerPlayer)element$iv2;
                    boolean bl3 = false;
                    player.m_6330_(SoundEvents.f_11894_, SoundSource.MASTER, 1.0f, 1.0f);
                }
            }
        }
    }

    public final void startTestMode() {
        block0: {
            StorylineOfMineyarg.INSTANCE.getDataManager().startApocalypse(true);
            this.startApocalypseLoop();
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block0;
            MinecraftServer it = minecraftServer;
            boolean bl = false;
            StorylineOfMineyarg.INSTANCE.getDataManager().saveData(it);
        }
    }

    public final void stopApocalypse(boolean resetProgress) {
        block0: {
            StorylineOfMineyarg.INSTANCE.getDataManager().stopApocalypse(resetProgress);
            this.stopApocalypseLoop();
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block0;
            MinecraftServer it = minecraftServer;
            boolean bl = false;
            StorylineOfMineyarg.INSTANCE.getDataManager().saveData(it);
        }
    }

    public static /* synthetic */ void stopApocalypse$default(ApocalypseManager apocalypseManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        apocalypseManager.stopApocalypse(bl);
    }

    public final void pauseApocalypse() {
        block0: {
            StorylineOfMineyarg.INSTANCE.getDataManager().pauseApocalypse();
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block0;
            MinecraftServer it = minecraftServer;
            boolean bl = false;
            StorylineOfMineyarg.INSTANCE.getDataManager().saveData(it);
        }
    }

    public final void resumeApocalypse() {
        block0: {
            StorylineOfMineyarg.INSTANCE.getDataManager().resumeApocalypse();
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block0;
            MinecraftServer it = minecraftServer;
            boolean bl = false;
            StorylineOfMineyarg.INSTANCE.getDataManager().saveData(it);
        }
    }

    private final void startApocalypseLoop() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.scheduler.scheduleAtFixedRate(() -> ApocalypseManager.startApocalypseLoop$lambda$8(this), 30L, 30L, TimeUnit.SECONDS);
        this.scheduler.scheduleAtFixedRate(() -> ApocalypseManager.startApocalypseLoop$lambda$9(this), 10L, 10L, TimeUnit.SECONDS);
        StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u0426\u0438\u043a\u043b \u0430\u043f\u043e\u043a\u0430\u043b\u0438\u043f\u0441\u0438\u0441\u0430 \u0437\u0430\u043f\u0443\u0449\u0435\u043d");
    }

    private final void stopApocalypseLoop() {
        this.isRunning = false;
        StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u0426\u0438\u043a\u043b \u0430\u043f\u043e\u043a\u0430\u043b\u0438\u043f\u0441\u0438\u0441\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
    }

    private final void checkApocalypseEvents() {
        block5: {
            int evolutionThreshold;
            MinecraftServer it;
            ApocalypseDataManager dataManager = StorylineOfMineyarg.INSTANCE.getDataManager();
            ApocalypseConfig config = StorylineOfMineyarg.INSTANCE.getConfig();
            if (!dataManager.getMobSpawnIncreaseTriggered() && dataManager.shouldTriggerEvent(config.getDaysUntilMobSpawnIncrease(), config.getMobSpawnCoefficient())) {
                this.triggerMobSpawnIncrease();
                dataManager.setMobSpawnIncreaseTriggered(true);
                MinecraftServer minecraftServer = this.server;
                if (minecraftServer != null) {
                    it = minecraftServer;
                    boolean bl = false;
                    dataManager.saveData(it);
                }
            }
            if (!dataManager.getSnowfallTriggered() && dataManager.shouldTriggerEvent(config.getDaysUntilSnowfall(), config.getSnowfallSpeedCoefficient())) {
                this.triggerSnowfall();
                dataManager.setSnowfallTriggered(true);
                MinecraftServer minecraftServer = this.server;
                if (minecraftServer != null) {
                    it = minecraftServer;
                    boolean bl = false;
                    dataManager.saveData(it);
                }
            }
            if (!dataManager.shouldTriggerEvent(evolutionThreshold = config.getDaysUntilMobEvolution() + dataManager.getMobEvolutionLevel() * 3, config.getMobEvolutionSpeedCoefficient())) break block5;
            this.triggerMobEvolution();
            int n = dataManager.getMobEvolutionLevel();
            dataManager.setMobEvolutionLevel(n + 1);
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer != null) {
                MinecraftServer it2 = minecraftServer;
                boolean bl = false;
                dataManager.saveData(it2);
            }
        }
    }

    private final void triggerMobSpawnIncrease() {
        block1: {
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block1;
            MinecraftServer server = minecraftServer;
            boolean bl = false;
            String message = "\u00a7c\u00a7l[\u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0421\u0418\u0421] \u00a7r\u00a7c\u0421\u043f\u0430\u0432\u043d \u0437\u043e\u043c\u0431\u0438 \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d!";
            List list = server.m_6846_().m_11314_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerPlayer player = (ServerPlayer)element$iv;
                boolean bl2 = false;
                player.m_213846_((Component)Component.m_237113_((String)message));
            }
            StorylineOfMineyarg.logAndMessage$default(StorylineOfMineyarg.INSTANCE, "\u0423\u0432\u0435\u043b\u0438\u0447\u0435\u043d \u0441\u043f\u0430\u0432\u043d \u0437\u043e\u043c\u0431\u0438", null, 2, null);
        }
    }

    private final void triggerSnowfall() {
        block2: {
            ServerLevel overworld;
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block2;
            MinecraftServer server = minecraftServer;
            boolean bl = false;
            ApocalypseDataManager dataManager = StorylineOfMineyarg.INSTANCE.getDataManager();
            if (dataManager.getSnowCenter() == null && (overworld = server.m_129880_(Level.f_46428_)) != null) {
                BlockPos spawnPos = overworld.m_220360_();
                dataManager.setSnowCenter(spawnPos);
                dataManager.setCurrentSnowRadius(1);
                dataManager.setCurrentBiomeRadius(1);
                Intrinsics.checkNotNull((Object)spawnPos);
                this.applySnowToNewRing(overworld, spawnPos, 0, 1);
                StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0446\u0435\u043d\u0442\u0440 \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434\u0430: " + spawnPos.m_123341_() + ", " + spawnPos.m_123343_());
            }
            String message = "\u00a7f\u00a7l[\u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0421\u0418\u0421] \u00a7r\u00a7f\u041d\u0430\u0447\u0430\u043b\u0441\u044f \u0432\u0435\u0447\u043d\u044b\u0439 \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434! \u0425\u043e\u043b\u043e\u0434 \u0440\u0430\u0441\u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u043e \u043c\u0438\u0440\u0443...";
            List list = server.m_6846_().m_11314_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerPlayer player = (ServerPlayer)element$iv;
                boolean bl2 = false;
                player.m_213846_((Component)Component.m_237113_((String)message));
            }
            StorylineOfMineyarg.logAndMessage$default(StorylineOfMineyarg.INSTANCE, "\u041d\u0430\u0447\u0430\u043b\u0441\u044f \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434", null, 2, null);
        }
    }

    private final void triggerMobEvolution() {
        block10: {
            int evolutionLevel = StorylineOfMineyarg.INSTANCE.getDataManager().getMobEvolutionLevel();
            int spawnIncrease = new Random().nextInt(3) + 1;
            ApocalypseConfig config = StorylineOfMineyarg.INSTANCE.getConfig();
            int newSpawnCoeff = RangesKt.coerceAtMost((int)(config.getMobSpawnCoefficient() + spawnIncrease), (int)100);
            config.setMobSpawnCoefficient(newSpawnCoeff);
            try {
                File configDir = new File("config");
                config.saveConfig(configDir);
            }
            catch (Exception e) {
                System.err.println("[Storyline Of Mineyarg] WARNING: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e: " + e.getMessage());
            }
            MinecraftServer minecraftServer = this.server;
            if (minecraftServer == null) break block10;
            MinecraftServer server = minecraftServer;
            boolean bl = false;
            String message = switch (evolutionLevel) {
                case 0 -> "\u00a7c\u00a7l[\u042d\u0412\u041e\u041b\u042e\u0426\u0418\u042f] \u00a7r\u00a7c\u0417\u043e\u043c\u0431\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0433\u043e\u0440\u044f\u0442 \u043d\u0430 \u0441\u043e\u043b\u043d\u0446\u0435 \u0438 \u043d\u0430\u0447\u0438\u043d\u0430\u044e\u0442 \u043d\u043e\u0441\u0438\u0442\u044c \u043a\u043e\u0436\u0430\u043d\u0443\u044e \u0431\u0440\u043e\u043d\u044e! \u0421\u043f\u0430\u0432\u043d \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d \u043d\u0430 " + spawnIncrease + " \u0437\u043e\u043c\u0431\u0438.";
                case 1 -> "\u00a7c\u00a7l[\u042d\u0412\u041e\u041b\u042e\u0426\u0418\u042f] \u00a7r\u00a7c\u0417\u043e\u043c\u0431\u0438 \u0441\u0442\u0430\u043b\u0438 \u0431\u044b\u0441\u0442\u0440\u0435\u0435 \u0438 \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043b\u0443\u0447\u0448\u0443\u044e \u0431\u0440\u043e\u043d\u044e \u0441 \u043e\u0440\u0443\u0436\u0438\u0435\u043c! \u0421\u043f\u0430\u0432\u043d \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d \u043d\u0430 " + spawnIncrease + " \u0437\u043e\u043c\u0431\u0438.";
                case 2 -> "\u00a7c\u00a7l[\u042d\u0412\u041e\u041b\u042e\u0426\u0418\u042f] \u00a7r\u00a7c\u0417\u043e\u043c\u0431\u0438 \u043f\u0440\u044b\u0433\u0430\u044e\u0442 \u0432\u044b\u0448\u0435, \u043d\u043e\u0441\u044f\u0442 \u0436\u0435\u043b\u0435\u0437\u043d\u0443\u044e \u0431\u0440\u043e\u043d\u044e \u0438 \u0432\u043b\u0430\u0434\u0435\u044e\u0442 \u0436\u0435\u043b\u0435\u0437\u043d\u044b\u043c\u0438 \u043c\u0435\u0447\u0430\u043c\u0438! \u0421\u043f\u0430\u0432\u043d \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d \u043d\u0430 " + spawnIncrease + " \u0437\u043e\u043c\u0431\u0438.";
                case 3 -> "\u00a7c\u00a7l[\u042d\u0412\u041e\u041b\u042e\u0426\u0418\u042f] \u00a7r\u00a7c\u0417\u043e\u043c\u0431\u0438 \u0441\u0442\u0430\u043b\u0438 \u0441\u0438\u043b\u044c\u043d\u0435\u0435 \u0432 \u0431\u043e\u044e, \u0438\u0445 \u043e\u0440\u0443\u0436\u0438\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u0447\u0430\u0440\u043e\u0432\u0430\u043d\u043e! \u0421\u043f\u0430\u0432\u043d \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d \u043d\u0430 " + spawnIncrease + " \u0437\u043e\u043c\u0431\u0438.";
                case 4 -> "\u00a7c\u00a7l[\u042d\u0412\u041e\u041b\u042e\u0426\u0418\u042f] \u00a7r\u00a7c\u0417\u043e\u043c\u0431\u0438 \u0434\u043e\u0441\u0442\u0438\u0433\u043b\u0438 \u0432\u044b\u0441\u043e\u043a\u043e\u0433\u043e \u0443\u0440\u043e\u0432\u043d\u044f \u0438 \u043c\u043e\u0433\u0443\u0442 \u043d\u043e\u0441\u0438\u0442\u044c \u0430\u043b\u043c\u0430\u0437\u043d\u044b\u0435 \u043c\u0435\u0447\u0438! \u0421\u043f\u0430\u0432\u043d \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d \u043d\u0430 " + spawnIncrease + " \u0437\u043e\u043c\u0431\u0438.";
                default -> "\u00a7c\u00a7l[\u042d\u0412\u041e\u041b\u042e\u0426\u0418\u042f] \u00a7r\u00a7c\u0417\u043e\u043c\u0431\u0438 \u0434\u043e\u0441\u0442\u0438\u0433\u043b\u0438 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0439 \u044d\u0432\u043e\u043b\u044e\u0446\u0438\u0438 \u0441 \u0430\u043b\u043c\u0430\u0437\u043d\u043e\u0439 \u0431\u0440\u043e\u043d\u0435\u0439 \u0438 \u0437\u0430\u0447\u0430\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u043c\u0438 \u043c\u0435\u0447\u0430\u043c\u0438! \u0421\u043f\u0430\u0432\u043d \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d \u043d\u0430 " + spawnIncrease + " \u0437\u043e\u043c\u0431\u0438.";
            };
            List list = server.m_6846_().m_11314_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerPlayer player = (ServerPlayer)element$iv;
                boolean bl2 = false;
                player.m_213846_((Component)Component.m_237113_((String)message));
            }
            StorylineOfMineyarg.logAndMessage$default(StorylineOfMineyarg.INSTANCE, "\u042d\u0432\u043e\u043b\u044e\u0446\u0438\u044f \u0437\u043e\u043c\u0431\u0438: \u0443\u0440\u043e\u0432\u0435\u043d\u044c " + evolutionLevel + ", \u0441\u043f\u0430\u0432\u043d \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d \u043d\u0430 " + spawnIncrease + " (\u043d\u043e\u0432\u044b\u0439 \u043a\u043e\u044d\u0444\u0444\u0438\u0446\u0438\u0435\u043d\u0442: " + newSpawnCoeff + "%)", null, 2, null);
        }
    }

    private final void checkSnowExpansion() {
        long expansionInterval;
        long currentTime = System.currentTimeMillis();
        ApocalypseDataManager dataManager = StorylineOfMineyarg.INSTANCE.getDataManager();
        long l = expansionInterval = dataManager.isTestMode() ? 1000L : 60000L;
        if (currentTime - this.lastSnowExpansionTime >= expansionInterval) {
            this.expandSnowfallAndBiome();
            this.lastSnowExpansionTime = currentTime;
        }
    }

    private final void expandSnowfallAndBiome() {
        ApocalypseDataManager dataManager = StorylineOfMineyarg.INSTANCE.getDataManager();
        BlockPos blockPos = dataManager.getSnowCenter();
        if (blockPos == null) {
            return;
        }
        BlockPos snowCenter = blockPos;
        MinecraftServer minecraftServer = this.server;
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        int oldSnowRadius = dataManager.getCurrentSnowRadius();
        int oldBiomeRadius = dataManager.getCurrentBiomeRadius();
        dataManager.setCurrentSnowRadius(dataManager.getCurrentSnowRadius() + 1);
        dataManager.setCurrentBiomeRadius(dataManager.getCurrentBiomeRadius() + 1);
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        if (overworld != null) {
            this.expandBiomeArea(overworld, snowCenter, oldBiomeRadius, dataManager.getCurrentBiomeRadius());
            this.applySnowToNewRing(overworld, snowCenter, oldSnowRadius, dataManager.getCurrentSnowRadius());
            this.manageWeatherForSnowfall(overworld);
        }
        if (StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) {
            StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u0421\u043d\u0435\u0433 \u0438 \u0431\u0438\u043e\u043c \u0440\u0430\u0441\u0448\u0438\u0440\u0438\u043b\u0438\u0441\u044c \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u043d\u043e \u0434\u043e \u0440\u0430\u0434\u0438\u0443\u0441\u0430: " + dataManager.getCurrentSnowRadius());
        }
    }

    private final void expandBiomeArea(ServerLevel overworld, BlockPos snowCenter, int innerRadius, int outerRadius) {
        this.applyBiomeToNewRing(overworld, snowCenter, innerRadius, outerRadius);
    }

    private final void applySnowToNewRing(ServerLevel level, BlockPos center, int innerRadius, int outerRadius) {
        int n;
        List ringCoordinates = new ArrayList();
        int x = center.m_123341_() - outerRadius;
        if (x <= (n = center.m_123341_() + outerRadius)) {
            while (true) {
                int n2;
                int z;
                if ((z = center.m_123343_() - outerRadius) <= (n2 = center.m_123343_() + outerRadius)) {
                    while (true) {
                        int distance;
                        if ((distance = (int)Math.sqrt((x - center.m_123341_()) * (x - center.m_123341_()) + (z - center.m_123343_()) * (z - center.m_123343_()))) > innerRadius && distance <= outerRadius) {
                            ringCoordinates.add(new Pair((Object)x, (Object)z));
                        }
                        if (z == n2) break;
                        ++z;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        Iterable $this$forEach$iv = ringCoordinates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int x2 = ((Number)pair.component1()).intValue();
            int z = ((Number)pair.component2()).intValue();
            this.applySnowEffectsToSurface(level, x2, z);
        }
    }

    private final void applyBiomeToNewRing(ServerLevel level, BlockPos center, int innerRadius, int outerRadius) {
        int n;
        List ringCoordinates = new ArrayList();
        int x = center.m_123341_() - outerRadius;
        if (x <= (n = center.m_123341_() + outerRadius)) {
            while (true) {
                int n2;
                int z;
                if ((z = center.m_123343_() - outerRadius) <= (n2 = center.m_123343_() + outerRadius)) {
                    while (true) {
                        int distance;
                        if ((distance = (int)Math.sqrt((x - center.m_123341_()) * (x - center.m_123341_()) + (z - center.m_123343_()) * (z - center.m_123343_()))) > innerRadius && distance <= outerRadius) {
                            ringCoordinates.add(new Pair((Object)x, (Object)z));
                        }
                        if (z == n2) break;
                        ++z;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        Iterable $this$forEach$iv = ringCoordinates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int x2 = ((Number)pair.component1()).intValue();
            int z = ((Number)pair.component2()).intValue();
            this.applyBiomeToColumn(level, x2, z);
        }
    }

    private final void applyBiomeToColumn(ServerLevel level, int x, int z) {
        int minY = level.m_141937_();
        int maxY = level.m_151558_() - 1;
        CommandSourceStack silentCommandSource = level.m_7654_().m_129893_().m_81348_(new Vec3((double)x, 0.0, (double)z)).m_81324_();
        level.m_7654_().m_129892_().m_230957_(silentCommandSource, "fillbiome " + x + " " + minY + " " + z + " " + x + " " + maxY + " " + z + " minecraft:snowy_taiga");
    }

    private final void applySnowEffectsToSurface(ServerLevel level, int x, int z) {
        BlockPos belowPos;
        BlockState belowState;
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        BlockPos pos = new BlockPos(x, surfaceY, z);
        if (level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)level, pos.m_7495_())) {
            level.m_7731_(pos, Blocks.f_50125_.m_49966_(), 3);
        }
        if (Intrinsics.areEqual((Object)(belowState = level.m_8055_(belowPos = pos.m_7495_())).m_60734_(), (Object)Blocks.f_49990_)) {
            level.m_7731_(belowPos, Blocks.f_50126_.m_49966_(), 3);
        }
        if (Intrinsics.areEqual((Object)belowState.m_60734_(), (Object)Blocks.f_50440_)) {
            level.m_7731_(belowPos, Blocks.f_50127_.m_49966_(), 3);
        }
    }

    private final void manageWeatherForSnowfall(ServerLevel level) {
        long weatherChangeInterval;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastWeatherChangeTime < (weatherChangeInterval = 30000L)) {
            return;
        }
        try {
            CommandSourceStack commandSource = level.m_7654_().m_129893_().m_81324_().m_81358_(4);
            Random random = new Random();
            float weatherType = random.nextFloat();
            String command = weatherType < 0.33f ? "weather clear" : (weatherType < 0.66f ? "weather rain" : "weather thunder");
            level.m_7654_().m_129892_().m_230957_(commandSource, command);
            this.lastWeatherChangeTime = currentTime;
            if (StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) {
                StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043f\u043e\u0433\u043e\u0434\u0430: " + command);
            }
        }
        catch (Exception e) {
            StorylineOfMineyarg.INSTANCE.getLOGGER().warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0433\u043e\u0434\u0443: " + e.getMessage());
        }
    }

    public final void applyMobEvolution(@NotNull Monster mob) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        int evolutionLevel = StorylineOfMineyarg.INSTANCE.getDataManager().getMobEvolutionLevel();
        if (evolutionLevel < 0 || !(mob instanceof Zombie)) {
            return;
        }
        mob.m_7292_(new MobEffectInstance(MobEffects.f_19607_, Integer.MAX_VALUE, 0, false, false));
        if (evolutionLevel > 0) {
            int buffLevel = RangesKt.coerceAtLeast((int)(evolutionLevel - 1), (int)0);
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, Integer.MAX_VALUE, buffLevel, false, false));
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19603_, Integer.MAX_VALUE, buffLevel, false, false));
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19600_, Integer.MAX_VALUE, buffLevel, false, false));
        }
        this.equipProgressiveArmor(mob, evolutionLevel);
        this.equipProgressiveWeapon(mob, evolutionLevel);
    }

    private final void equipProgressiveArmor(Monster mob, int evolutionLevel) {
        Random random = new Random();
        float armorChance = switch (evolutionLevel) {
            case 0 -> 0.3f;
            case 1 -> 0.5f;
            case 2 -> 0.7f;
            case 3 -> 0.8f;
            case 4 -> 0.9f;
            default -> 1.0f;
        };
        Object[] objectArray = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
        List armorSlots = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = armorSlots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EquipmentSlot slot = (EquipmentSlot)element$iv;
            boolean bl = false;
            if (!(random.nextFloat() < armorChance)) continue;
            ItemStack armorItem = switch (evolutionLevel) {
                case 0 -> this.getLeatherArmor(slot);
                case 1 -> {
                    if (random.nextFloat() < 0.6f) {
                        yield this.getLeatherArmor(slot);
                    }
                    yield this.getIronArmor(slot);
                }
                case 2 -> {
                    if (random.nextFloat() < 0.3f) {
                        yield this.getLeatherArmor(slot);
                    }
                    yield this.getIronArmor(slot);
                }
                case 3 -> this.getIronArmor(slot);
                case 4 -> this.getIronArmor(slot);
                default -> evolutionLevel >= 5 && random.nextFloat() < 0.25f ? this.getDiamondArmor(slot) : this.getIronArmor(slot);
            };
            mob.m_8061_(slot, armorItem);
        }
    }

    private final void equipProgressiveWeapon(Monster mob, int evolutionLevel) {
        Random random = new Random();
        switch (evolutionLevel) {
            case 0: {
                if (!(random.nextFloat() < 0.2f)) break;
                mob.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42420_));
                break;
            }
            case 1: {
                if (!(random.nextFloat() < 0.4f)) break;
                Item weapon = random.nextFloat() < 0.7f ? Items.f_42425_ : Items.f_42383_;
                mob.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)weapon));
                break;
            }
            case 2: {
                if (!(random.nextFloat() < 0.6f)) break;
                mob.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42383_));
                break;
            }
            case 3: {
                if (!(random.nextFloat() < 0.7f)) break;
                ItemStack sword = new ItemStack((ItemLike)Items.f_42383_);
                if (random.nextFloat() < 0.3f) {
                    EnchantmentHelper.m_44865_((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)Enchantments.f_44977_, (Object)1)), (ItemStack)sword);
                }
                mob.m_21008_(InteractionHand.MAIN_HAND, sword);
                break;
            }
            case 4: {
                if (!(random.nextFloat() < 0.8f)) break;
                Item weapon = random.nextFloat() < 0.7f ? Items.f_42383_ : Items.f_42388_;
                ItemStack sword = new ItemStack((ItemLike)weapon);
                if (random.nextFloat() < 0.5f) {
                    int enchantLevel = Intrinsics.areEqual((Object)weapon, (Object)Items.f_42388_) ? 2 : 1;
                    EnchantmentHelper.m_44865_((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)Enchantments.f_44977_, (Object)enchantLevel)), (ItemStack)sword);
                }
                mob.m_21008_(InteractionHand.MAIN_HAND, sword);
                break;
            }
            default: {
                if (!(random.nextFloat() < 0.9f)) break;
                ItemStack sword = new ItemStack((ItemLike)Items.f_42388_);
                int enchantLevel = Math.min(evolutionLevel - 3, 3);
                EnchantmentHelper.m_44865_((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)Enchantments.f_44977_, (Object)enchantLevel)), (ItemStack)sword);
                mob.m_21008_(InteractionHand.MAIN_HAND, sword);
            }
        }
        if (evolutionLevel >= 2 && random.nextFloat() < 0.1f + (float)evolutionLevel * 0.05f) {
            mob.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42584_));
        }
    }

    private final ItemStack getLeatherArmor(EquipmentSlot slot) {
        ItemStack itemStack;
        switch (WhenMappings.$EnumSwitchMapping$0[slot.ordinal()]) {
            case 1: {
                itemStack = new ItemStack((ItemLike)Items.f_42407_);
                break;
            }
            case 2: {
                itemStack = new ItemStack((ItemLike)Items.f_42408_);
                break;
            }
            case 3: {
                itemStack = new ItemStack((ItemLike)Items.f_42462_);
                break;
            }
            case 4: {
                itemStack = new ItemStack((ItemLike)Items.f_42463_);
                break;
            }
            default: {
                ItemStack itemStack2 = ItemStack.f_41583_;
                itemStack = itemStack2;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
            }
        }
        return itemStack;
    }

    private final ItemStack getIronArmor(EquipmentSlot slot) {
        ItemStack itemStack;
        switch (WhenMappings.$EnumSwitchMapping$0[slot.ordinal()]) {
            case 1: {
                itemStack = new ItemStack((ItemLike)Items.f_42468_);
                break;
            }
            case 2: {
                itemStack = new ItemStack((ItemLike)Items.f_42469_);
                break;
            }
            case 3: {
                itemStack = new ItemStack((ItemLike)Items.f_42470_);
                break;
            }
            case 4: {
                itemStack = new ItemStack((ItemLike)Items.f_42471_);
                break;
            }
            default: {
                ItemStack itemStack2 = ItemStack.f_41583_;
                itemStack = itemStack2;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
            }
        }
        return itemStack;
    }

    private final ItemStack getDiamondArmor(EquipmentSlot slot) {
        ItemStack itemStack;
        switch (WhenMappings.$EnumSwitchMapping$0[slot.ordinal()]) {
            case 1: {
                itemStack = new ItemStack((ItemLike)Items.f_42472_);
                break;
            }
            case 2: {
                itemStack = new ItemStack((ItemLike)Items.f_42473_);
                break;
            }
            case 3: {
                itemStack = new ItemStack((ItemLike)Items.f_42474_);
                break;
            }
            case 4: {
                itemStack = new ItemStack((ItemLike)Items.f_42475_);
                break;
            }
            default: {
                ItemStack itemStack2 = ItemStack.f_41583_;
                itemStack = itemStack2;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
            }
        }
        return itemStack;
    }

    private static final void startApocalypseLoop$lambda$8(ApocalypseManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            if (this$0.isRunning && !StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypsePaused()) {
                this$0.checkApocalypseEvents();
                MinecraftServer minecraftServer = this$0.server;
                if (minecraftServer != null) {
                    MinecraftServer it = minecraftServer;
                    boolean bl = false;
                    StorylineOfMineyarg.INSTANCE.getDataManager().saveData(it);
                }
            }
        }
        catch (Exception e) {
            StorylineOfMineyarg.INSTANCE.getLOGGER().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0446\u0438\u043a\u043b\u0435 \u0430\u043f\u043e\u043a\u0430\u043b\u0438\u043f\u0441\u0438\u0441\u0430: " + e.getMessage());
        }
    }

    private static final void startApocalypseLoop$lambda$9(ApocalypseManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            if (this$0.isRunning && !StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypsePaused() && StorylineOfMineyarg.INSTANCE.getDataManager().getSnowfallTriggered()) {
                this$0.checkSnowExpansion();
            }
        }
        catch (Exception e) {
            StorylineOfMineyarg.INSTANCE.getLOGGER().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0446\u0438\u043a\u043b\u0435 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f \u0441\u043d\u0435\u0433\u0430: " + e.getMessage());
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EquipmentSlot.values().length];
            try {
                nArray[EquipmentSlot.HEAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.CHEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.LEGS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.FEET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

