/*
 * Decompiled with CFR 0.152.
 */
package com.mryarg1ch.storylineofmineyarg.apocalypse;

import com.mryarg1ch.storylineofmineyarg.StorylineOfMineyarg;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u001b\u001a\u00020\u0011J\b\u0010\u001c\u001a\u00020\u0011H\u0002J\b\u0010\u001d\u001a\u00020\u0011H\u0002J\b\u0010\u001e\u001a\u00020\u0011H\u0002J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R8\u0010\u000b\u001a,\u0012(\u0012&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/mryarg1ch/storylineofmineyarg/apocalypse/WeatherManager;", "", "()V", "isRunning", "", "random", "Ljava/util/Random;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "server", "Lnet/minecraft/server/MinecraftServer;", "winterBiomes", "", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/biome/Biome;", "kotlin.jvm.PlatformType", "clearWeatherInWinterBiomes", "", "forceSnowInWinterBiomes", "isInWinterBiome", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "notifyPlayersInWinterBiomes", "shouldSnow", "onServerStart", "onServerStop", "startWeatherLoop", "stopWeatherLoop", "updateWeatherInAllWinterBiomes", "updateWeatherInLevel", "storylineofmineyarg"})
@SourceDebugExtension(value={"SMAP\nWeatherManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeatherManager.kt\ncom/mryarg1ch/storylineofmineyarg/apocalypse/WeatherManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1855#2,2:197\n1855#2,2:200\n1747#2,3:202\n1855#2,2:205\n1855#2,2:207\n1#3:199\n*S KotlinDebug\n*F\n+ 1 WeatherManager.kt\ncom/mryarg1ch/storylineofmineyarg/apocalypse/WeatherManager\n*L\n95#1:197,2\n149#1:200,2\n164#1:202,3\n173#1:205,2\n188#1:207,2\n*E\n"})
public final class WeatherManager {
    @Nullable
    private MinecraftServer server;
    @Nullable
    private ScheduledExecutorService scheduler;
    @NotNull
    private final Random random = new Random();
    private boolean isRunning;
    @NotNull
    private final List<ResourceKey<Biome>> winterBiomes;

    public WeatherManager() {
        Object[] objectArray = new ResourceKey[]{Biomes.f_186761_, Biomes.f_48152_, Biomes.f_186756_, Biomes.f_48212_, Biomes.f_48182_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48148_, Biomes.f_186755_, Biomes.f_186757_, Biomes.f_186758_};
        this.winterBiomes = CollectionsKt.listOf((Object[])objectArray);
    }

    public final void onServerStart(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        this.startWeatherLoop();
    }

    public final void onServerStop() {
        this.stopWeatherLoop();
        ScheduledExecutorService scheduledExecutorService = this.scheduler;
        if (scheduledExecutorService != null) {
            scheduledExecutorService.shutdown();
        }
        this.scheduler = null;
    }

    private final void startWeatherLoop() {
        block5: {
            block4: {
                if (this.isRunning) {
                    return;
                }
                this.isRunning = true;
                if (this.scheduler == null) break block4;
                ScheduledExecutorService scheduledExecutorService = this.scheduler;
                Intrinsics.checkNotNull((Object)scheduledExecutorService);
                if (!scheduledExecutorService.isShutdown()) break block5;
            }
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
        }
        ScheduledExecutorService scheduledExecutorService = this.scheduler;
        Intrinsics.checkNotNull((Object)scheduledExecutorService);
        scheduledExecutorService.scheduleAtFixedRate(() -> WeatherManager.startWeatherLoop$lambda$0(this), 0L, 10L, TimeUnit.MINUTES);
    }

    private final void stopWeatherLoop() {
        this.isRunning = false;
    }

    private final void updateWeatherInAllWinterBiomes() {
        MinecraftServer minecraftServer = this.server;
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        boolean shouldSnow = this.random.nextBoolean();
        Iterable iterable = server.m_129785_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerLevel level = (ServerLevel)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)level.m_46472_(), (Object)Level.f_46428_)) continue;
            Intrinsics.checkNotNull((Object)level);
            this.updateWeatherInLevel(level, shouldSnow);
        }
        if (StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) {
            String weatherType = shouldSnow ? "\u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434" : "\u044f\u0441\u043d\u0430\u044f \u043f\u043e\u0433\u043e\u0434\u0430";
            StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u041f\u043e\u0433\u043e\u0434\u0430 \u0432\u043e \u0432\u0441\u0435\u0445 \u0437\u0438\u043c\u043d\u0438\u0445 \u0431\u0438\u043e\u043c\u0430\u0445 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0430 \u043d\u0430: " + weatherType);
        }
    }

    private final void updateWeatherInLevel(ServerLevel level, boolean shouldSnow) {
        try {
            Field serverLevelDataField = level.getClass().getDeclaredField("serverLevelData");
            serverLevelDataField.setAccessible(true);
            Object serverLevelData = serverLevelDataField.get(level);
            if (shouldSnow) {
                Object object = new Class[]{Boolean.TYPE};
                Method method = serverLevelData.getClass().getMethod("setRaining", (Class<?>)object);
                object = new Object[]{true};
                method.invoke(serverLevelData, (Object[])object);
                object = new Class[]{Boolean.TYPE};
                Method method2 = serverLevelData.getClass().getMethod("setThundering", (Class<?>)object);
                object = new Object[]{false};
                method2.invoke(serverLevelData, (Object[])object);
                Object $this$updateWeatherInLevel_u24lambda_u242 = object = serverLevelData.getClass().getDeclaredField("rainTime");
                boolean bl = false;
                ((Field)$this$updateWeatherInLevel_u24lambda_u242).setAccessible(true);
                ((Field)object).set(serverLevelData, 12000);
                Object $this$updateWeatherInLevel_u24lambda_u243 = object = serverLevelData.getClass().getDeclaredField("clearWeatherTime");
                boolean bl2 = false;
                ((Field)$this$updateWeatherInLevel_u24lambda_u243).setAccessible(true);
                ((Field)object).set(serverLevelData, 0);
            } else {
                Object object = new Class[]{Boolean.TYPE};
                Method method = serverLevelData.getClass().getMethod("setRaining", (Class<?>)object);
                object = new Object[]{false};
                method.invoke(serverLevelData, (Object[])object);
                object = new Class[]{Boolean.TYPE};
                Method method3 = serverLevelData.getClass().getMethod("setThundering", (Class<?>)object);
                object = new Object[]{false};
                method3.invoke(serverLevelData, (Object[])object);
                Object $this$updateWeatherInLevel_u24lambda_u244 = object = serverLevelData.getClass().getDeclaredField("clearWeatherTime");
                boolean bl = false;
                ((Field)$this$updateWeatherInLevel_u24lambda_u244).setAccessible(true);
                ((Field)object).set(serverLevelData, 12000);
                Object $this$updateWeatherInLevel_u24lambda_u245 = object = serverLevelData.getClass().getDeclaredField("rainTime");
                boolean bl3 = false;
                ((Field)$this$updateWeatherInLevel_u24lambda_u245).setAccessible(true);
                ((Field)object).set(serverLevelData, 0);
            }
        }
        catch (Exception e) {
            StorylineOfMineyarg.INSTANCE.getLOGGER().warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0433\u043e\u0434\u0443: " + e.getMessage());
        }
        this.notifyPlayersInWinterBiomes(level, shouldSnow);
    }

    private final void notifyPlayersInWinterBiomes(ServerLevel level, boolean shouldSnow) {
        String message = shouldSnow ? "\u00a7f\u2744 \u0412 \u0437\u0438\u043c\u043d\u0438\u0445 \u0431\u0438\u043e\u043c\u0430\u0445 \u043d\u0430\u0447\u0430\u043b\u0441\u044f \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434!" : "\u00a77\u2600 \u0412 \u0437\u0438\u043c\u043d\u0438\u0445 \u0431\u0438\u043e\u043c\u0430\u0445 \u043f\u0440\u043e\u044f\u0441\u043d\u0438\u043b\u043e\u0441\u044c.";
        List list = level.m_6907_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            BlockPos playerPos = player.m_20183_();
            Intrinsics.checkNotNull((Object)playerPos);
            if (!this.isInWinterBiome(level, playerPos)) continue;
            player.m_213846_((Component)Component.m_237113_((String)message));
        }
    }

    private final boolean isInWinterBiome(ServerLevel level, BlockPos pos) {
        boolean bl;
        block3: {
            Holder biome = level.m_204166_(pos);
            Iterable $this$any$iv = this.winterBiomes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ResourceKey it = (ResourceKey)element$iv;
                    boolean bl2 = false;
                    if (!biome.m_203565_(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void forceSnowInWinterBiomes() {
        MinecraftServer minecraftServer = this.server;
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        Iterable iterable = server.m_129785_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerLevel level = (ServerLevel)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)level.m_46472_(), (Object)Level.f_46428_)) continue;
            Intrinsics.checkNotNull((Object)level);
            this.updateWeatherInLevel(level, true);
        }
        StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u041f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434 \u0432\u043e \u0432\u0441\u0435\u0445 \u0437\u0438\u043c\u043d\u0438\u0445 \u0431\u0438\u043e\u043c\u0430\u0445");
    }

    public final void clearWeatherInWinterBiomes() {
        MinecraftServer minecraftServer = this.server;
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        Iterable iterable = server.m_129785_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerLevel level = (ServerLevel)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)level.m_46472_(), (Object)Level.f_46428_)) continue;
            Intrinsics.checkNotNull((Object)level);
            this.updateWeatherInLevel(level, false);
        }
        StorylineOfMineyarg.INSTANCE.getLOGGER().info("\u0423\u0431\u0440\u0430\u043d \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434 \u0432\u043e \u0432\u0441\u0435\u0445 \u0437\u0438\u043c\u043d\u0438\u0445 \u0431\u0438\u043e\u043c\u0430\u0445");
    }

    private static final void startWeatherLoop$lambda$0(WeatherManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.updateWeatherInAllWinterBiomes();
        }
        catch (Exception e) {
            StorylineOfMineyarg.INSTANCE.getLOGGER().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u043f\u043e\u0433\u043e\u0434\u044b: " + e.getMessage());
        }
    }
}

