/*
 * Decompiled with CFR 0.152.
 */
package com.mryarg1ch.storylineofmineyarg.config;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0004J\u000e\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u0004J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020,J\u000e\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020.R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR$\u0010\r\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR$\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010\"\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0007\"\u0004\b$\u0010\t\u00a8\u00061"}, d2={"Lcom/mryarg1ch/storylineofmineyarg/config/ApocalypseConfig;", "", "()V", "value", "", "daysUntilMobEvolution", "getDaysUntilMobEvolution", "()I", "setDaysUntilMobEvolution", "(I)V", "daysUntilMobSpawnIncrease", "getDaysUntilMobSpawnIncrease", "setDaysUntilMobSpawnIncrease", "daysUntilSnowfall", "getDaysUntilSnowfall", "setDaysUntilSnowfall", "enableProgressLogging", "", "getEnableProgressLogging", "()Z", "setEnableProgressLogging", "(Z)V", "mobEvolutionSpeedCoefficient", "getMobEvolutionSpeedCoefficient", "setMobEvolutionSpeedCoefficient", "mobSpawnCoefficient", "getMobSpawnCoefficient", "setMobSpawnCoefficient", "snowSpawnPosition", "Lnet/minecraft/core/BlockPos;", "getSnowSpawnPosition", "()Lnet/minecraft/core/BlockPos;", "setSnowSpawnPosition", "(Lnet/minecraft/core/BlockPos;)V", "snowfallSpeedCoefficient", "getSnowfallSpeedCoefficient", "setSnowfallSpeedCoefficient", "applyCoefficient", "", "timeMs", "coefficient", "daysToMilliseconds", "days", "loadConfig", "", "configDir", "Ljava/io/File;", "resetToDefaults", "saveConfig", "storylineofmineyarg"})
@SourceDebugExtension(value={"SMAP\nApocalypseConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApocalypseConfig.kt\ncom/mryarg1ch/storylineofmineyarg/config/ApocalypseConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class ApocalypseConfig {
    private int daysUntilMobSpawnIncrease = 3;
    private int daysUntilSnowfall = 2;
    private int daysUntilMobEvolution = 7;
    private int mobSpawnCoefficient = 30;
    private int mobEvolutionSpeedCoefficient = 75;
    private int snowfallSpeedCoefficient = 25;
    private boolean enableProgressLogging = true;
    @Nullable
    private BlockPos snowSpawnPosition;

    public final int getDaysUntilMobSpawnIncrease() {
        return this.daysUntilMobSpawnIncrease;
    }

    public final void setDaysUntilMobSpawnIncrease(int value) {
        this.daysUntilMobSpawnIncrease = RangesKt.coerceIn((int)value, (int)1, (int)100);
    }

    public final int getDaysUntilSnowfall() {
        return this.daysUntilSnowfall;
    }

    public final void setDaysUntilSnowfall(int value) {
        this.daysUntilSnowfall = RangesKt.coerceIn((int)value, (int)2, (int)100);
    }

    public final int getDaysUntilMobEvolution() {
        return this.daysUntilMobEvolution;
    }

    public final void setDaysUntilMobEvolution(int value) {
        this.daysUntilMobEvolution = RangesKt.coerceIn((int)value, (int)1, (int)100);
    }

    public final int getMobSpawnCoefficient() {
        return this.mobSpawnCoefficient;
    }

    public final void setMobSpawnCoefficient(int value) {
        this.mobSpawnCoefficient = RangesKt.coerceIn((int)value, (int)1, (int)100);
    }

    public final int getMobEvolutionSpeedCoefficient() {
        return this.mobEvolutionSpeedCoefficient;
    }

    public final void setMobEvolutionSpeedCoefficient(int value) {
        this.mobEvolutionSpeedCoefficient = RangesKt.coerceIn((int)value, (int)1, (int)100);
    }

    public final int getSnowfallSpeedCoefficient() {
        return this.snowfallSpeedCoefficient;
    }

    public final void setSnowfallSpeedCoefficient(int value) {
        this.snowfallSpeedCoefficient = RangesKt.coerceIn((int)value, (int)1, (int)100);
    }

    public final boolean getEnableProgressLogging() {
        return this.enableProgressLogging;
    }

    public final void setEnableProgressLogging(boolean bl) {
        this.enableProgressLogging = bl;
    }

    @Nullable
    public final BlockPos getSnowSpawnPosition() {
        return this.snowSpawnPosition;
    }

    public final void setSnowSpawnPosition(@Nullable BlockPos blockPos) {
        this.snowSpawnPosition = blockPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadConfig(@NotNull File configDir) {
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        File configFile = new File(configDir, "storylineofmineyarg-config.properties");
        if (!configFile.exists()) {
            this.saveConfig(configDir);
            return;
        }
        try {
            Properties properties = new Properties();
            Closeable closeable = new FileInputStream(configFile);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                properties.load(it);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = properties.getProperty("daysUntilMobSpawnIncrease", "3");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            this.setDaysUntilMobSpawnIncrease(Integer.parseInt(string));
            String string2 = properties.getProperty("daysUntilSnowfall", "2");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            this.setDaysUntilSnowfall(Integer.parseInt(string2));
            String string3 = properties.getProperty("daysUntilMobEvolution", "7");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
            this.setDaysUntilMobEvolution(Integer.parseInt(string3));
            String string4 = properties.getProperty("mobSpawnCoefficient", "50");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
            this.setMobSpawnCoefficient(Integer.parseInt(string4));
            String string5 = properties.getProperty("mobEvolutionSpeedCoefficient", "75");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getProperty(...)");
            this.setMobEvolutionSpeedCoefficient(Integer.parseInt(string5));
            String string6 = properties.getProperty("snowfallSpeedCoefficient", "25");
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getProperty(...)");
            this.setSnowfallSpeedCoefficient(Integer.parseInt(string6));
            this.enableProgressLogging = Boolean.parseBoolean(properties.getProperty("enableProgressLogging", "true"));
            String snowX = properties.getProperty("snowSpawnX");
            String snowY = properties.getProperty("snowSpawnY");
            String snowZ = properties.getProperty("snowSpawnZ");
            if (snowX != null && snowY != null && snowZ != null) {
                this.snowSpawnPosition = new BlockPos(Integer.parseInt(snowX), Integer.parseInt(snowY), Integer.parseInt(snowZ));
            }
            System.out.println((Object)"[Storyline Of Mineyarg] INFO: Configuration loaded successfully");
        }
        catch (Exception e) {
            System.err.println("[Storyline Of Mineyarg] ERROR: Failed to load configuration: " + e.getMessage());
            this.saveConfig(configDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveConfig(@NotNull File configDir) {
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        File configFile = new File(configDir, "storylineofmineyarg-config.properties");
        try {
            Properties properties = new Properties();
            properties.setProperty("daysUntilMobSpawnIncrease", String.valueOf(this.daysUntilMobSpawnIncrease));
            properties.setProperty("daysUntilSnowfall", String.valueOf(this.daysUntilSnowfall));
            properties.setProperty("daysUntilMobEvolution", String.valueOf(this.daysUntilMobEvolution));
            properties.setProperty("mobSpawnCoefficient", String.valueOf(this.mobSpawnCoefficient));
            properties.setProperty("mobEvolutionSpeedCoefficient", String.valueOf(this.mobEvolutionSpeedCoefficient));
            properties.setProperty("snowfallSpeedCoefficient", String.valueOf(this.snowfallSpeedCoefficient));
            properties.setProperty("enableProgressLogging", String.valueOf(this.enableProgressLogging));
            BlockPos blockPos = this.snowSpawnPosition;
            if (blockPos != null) {
                BlockPos pos = blockPos;
                boolean bl = false;
                properties.setProperty("snowSpawnX", String.valueOf(pos.m_123341_()));
                properties.setProperty("snowSpawnY", String.valueOf(pos.m_123342_()));
                properties.setProperty("snowSpawnZ", String.valueOf(pos.m_123343_()));
            }
            Closeable closeable = new FileOutputStream(configFile);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl = false;
                properties.store(it, "Storyline Of Mineyarg Configuration");
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            System.out.println((Object)"[Storyline Of Mineyarg] INFO: Configuration saved successfully");
        }
        catch (Exception e) {
            System.err.println("[Storyline Of Mineyarg] ERROR: Failed to save configuration: " + e.getMessage());
        }
    }

    public final void resetToDefaults() {
        this.setDaysUntilMobSpawnIncrease(3);
        this.setDaysUntilSnowfall(2);
        this.setDaysUntilMobEvolution(7);
        this.setMobSpawnCoefficient(30);
        this.setMobEvolutionSpeedCoefficient(75);
        this.setSnowfallSpeedCoefficient(25);
        this.enableProgressLogging = true;
        this.snowSpawnPosition = null;
        System.out.println((Object)"[Storyline Of Mineyarg] INFO: Configuration reset to defaults");
    }

    public final long daysToMilliseconds(int days) {
        return (long)days * 24L * 60L * 60L * 1000L;
    }

    public final long applyCoefficient(long timeMs, int coefficient) {
        return (long)((double)(timeMs * (long)coefficient) / 100.0);
    }
}

