/*
 * Decompiled with CFR 0.152.
 */
package com.mryarg1ch.storylineofmineyarg.events;

import com.mryarg1ch.storylineofmineyarg.StorylineOfMineyarg;
import com.mryarg1ch.storylineofmineyarg.config.ApocalypseConfig;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="storylineofmineyarg")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/mryarg1ch/storylineofmineyarg/events/ApocalypseEventHandler;", "", "()V", "onMobSpawn", "", "event", "Lnet/minecraftforge/event/entity/EntityJoinLevelEvent;", "spawnAdditionalMobs", "originalMob", "Lnet/minecraft/world/entity/monster/Monster;", "storylineofmineyarg"})
public final class ApocalypseEventHandler {
    @NotNull
    public static final ApocalypseEventHandler INSTANCE = new ApocalypseEventHandler();

    private ApocalypseEventHandler() {
    }

    @SubscribeEvent
    public final void onMobSpawn(@NotNull EntityJoinLevelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypseActive() || StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypsePaused()) {
            return;
        }
        Entity entity = event.getEntity();
        if (StorylineOfMineyarg.INSTANCE.getDataManager().getMobSpawnIncreaseTriggered() && entity instanceof Monster && StorylineOfMineyarg.INSTANCE.getDataManager().isTestMode()) {
            ApocalypseConfig config = StorylineOfMineyarg.INSTANCE.getConfig();
            double spawnMultiplier = (double)config.getMobSpawnCoefficient() / 100.0;
            Random random = new Random();
            if (random.nextDouble() < spawnMultiplier) {
                this.spawnAdditionalMobs((Monster)entity);
            }
        }
        if (entity instanceof Monster && StorylineOfMineyarg.INSTANCE.getDataManager().getMobEvolutionLevel() > 0) {
            try {
                StorylineOfMineyarg.INSTANCE.getApocalypseManager().applyMobEvolution((Monster)entity);
                if (StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) {
                    System.out.println((Object)("[Storyline Of Mineyarg] DEBUG: \u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0430 \u044d\u0432\u043e\u043b\u044e\u0446\u0438\u044f \u043a \u043c\u043e\u0431\u0443: " + entity.getClass().getSimpleName()));
                }
            }
            catch (Exception e) {
                System.err.println("[Storyline Of Mineyarg] ERROR: \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u044d\u0432\u043e\u043b\u044e\u0446\u0438\u0438 \u043a \u043c\u043e\u0431\u0443: " + e.getMessage());
            }
        }
    }

    private final void spawnAdditionalMobs(Monster originalMob) {
        try {
            Level level = originalMob.m_9236_();
            BlockPos pos = originalMob.m_20183_();
            Random random = new Random();
            int additionalMobCount = random.nextInt(2) + 1;
            for (int i = 0; i < additionalMobCount; ++i) {
                Monster monster;
                int it = i;
                boolean bl = false;
                int offsetX = random.nextInt(6) - 3;
                int offsetZ = random.nextInt(6) - 3;
                BlockPos spawnPos = pos.m_7918_(offsetX, 0, offsetZ);
                Monster monster2 = originalMob;
                if (monster2 instanceof Zombie) {
                    monster = (Monster)new Zombie(EntityType.f_20501_, level);
                } else if (monster2 instanceof Skeleton) {
                    monster = (Monster)new Skeleton(EntityType.f_20524_, level);
                } else if (monster2 instanceof Creeper) {
                    monster = (Monster)new Creeper(EntityType.f_20558_, level);
                } else {
                    if (!(monster2 instanceof Spider)) continue;
                    monster = (Monster)new Spider(EntityType.f_20479_, level);
                }
                Monster newMob = monster;
                newMob.m_6034_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
                if (!level.m_7967_((Entity)newMob) || !StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) continue;
                System.out.println((Object)"[Storyline Of Mineyarg] DEBUG: \u0417\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u043e\u043c\u0431\u0438 \u0432 \u0442\u0435\u0441\u0442\u043e\u0432\u043e\u043c \u0440\u0435\u0436\u0438\u043c\u0435");
            }
        }
        catch (Exception e) {
            System.err.println("[Storyline Of Mineyarg] ERROR: \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043f\u0430\u0432\u043d\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0437\u043e\u043c\u0431\u0438: " + e.getMessage());
        }
    }
}

