/*
 * Decompiled with CFR 0.152.
 */
package com.mryarg1ch.storylineofmineyarg.events;

import com.mryarg1ch.storylineofmineyarg.StorylineOfMineyarg;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/mryarg1ch/storylineofmineyarg/events/ZombieBlockBreakingHandler;", "", "()V", "breakableBlocks", "", "Lnet/minecraft/world/level/block/Block;", "kotlin.jvm.PlatformType", "lastBreakTime", "", "Lnet/minecraft/world/entity/monster/Zombie;", "", "breakBlock", "", "zombie", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "canBreakBlock", "", "canReachPlayerDirectly", "player", "Lnet/minecraft/world/entity/player/Player;", "cleanupZombie", "hasBlockBreakingEvolution", "isBlockObstructingPath", "zombiePos", "playerPos", "blockPos", "onZombieTick", "event", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingTickEvent;", "tryBreakBlocksTowardsPlayer", "storylineofmineyarg"})
public final class ZombieBlockBreakingHandler {
    @NotNull
    public static final ZombieBlockBreakingHandler INSTANCE = new ZombieBlockBreakingHandler();
    @NotNull
    private static final Set<Block> breakableBlocks;
    @NotNull
    private static final Map<Zombie, Long> lastBreakTime;

    private ZombieBlockBreakingHandler() {
    }

    @SubscribeEvent
    public final void onZombieTick(@NotNull LivingEvent.LivingTickEvent event) {
        long lastTime;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Zombie) || entity.m_9236_().f_46443_) {
            return;
        }
        if (!StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypseActive() || StorylineOfMineyarg.INSTANCE.getDataManager().isApocalypsePaused()) {
            return;
        }
        if (!this.hasBlockBreakingEvolution((Zombie)entity)) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Long l = lastBreakTime.get(entity);
        long l2 = lastTime = l != null ? l : 0L;
        if (currentTime - lastTime < 10000L) {
            return;
        }
        Player nearestPlayer = entity.m_9236_().m_45930_((Entity)entity, 16.0);
        if (nearestPlayer == null || !entity.m_142582_((Entity)nearestPlayer)) {
            return;
        }
        if (!this.canReachPlayerDirectly((Zombie)entity, nearestPlayer) && this.tryBreakBlocksTowardsPlayer((Zombie)entity, nearestPlayer)) {
            Long l3 = currentTime;
            lastBreakTime.put((Zombie)entity, l3);
        }
    }

    private final boolean hasBlockBreakingEvolution(Zombie zombie) {
        return false;
    }

    private final boolean canReachPlayerDirectly(Zombie zombie, Player player) {
        BlockPos zombiePos = zombie.m_20183_();
        BlockPos playerPos = player.m_20183_();
        Level level = zombie.m_9236_();
        BlockHitResult rayTrace = level.m_45547_(new ClipContext(zombie.m_20182_(), player.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)zombie));
        return rayTrace.m_6662_() == HitResult.Type.MISS;
    }

    private final boolean tryBreakBlocksTowardsPlayer(Zombie zombie, Player player) {
        BlockPos zombiePos = zombie.m_20183_();
        BlockPos playerPos = player.m_20183_();
        for (int x = -2; x < 3; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = -2; z < 3; ++z) {
                    BlockPos checkPos = zombiePos.m_7918_(x, y, z);
                    BlockState blockState = zombie.m_9236_().m_8055_(checkPos);
                    Intrinsics.checkNotNull((Object)blockState);
                    if (!this.canBreakBlock(blockState)) continue;
                    Intrinsics.checkNotNull((Object)zombiePos);
                    Intrinsics.checkNotNull((Object)playerPos);
                    Intrinsics.checkNotNull((Object)checkPos);
                    if (!this.isBlockObstructingPath(zombiePos, playerPos, checkPos) || !(Random.Default.nextFloat() < 0.15f)) continue;
                    this.breakBlock(zombie, checkPos, blockState);
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean canBreakBlock(BlockState blockState) {
        return breakableBlocks.contains(blockState.m_60734_()) && !blockState.m_60795_();
    }

    private final boolean isBlockObstructingPath(BlockPos zombiePos, BlockPos playerPos, BlockPos blockPos) {
        BlockPos zombieToPlayer = playerPos.m_121996_((Vec3i)zombiePos);
        BlockPos zombieToBlock = blockPos.m_121996_((Vec3i)zombiePos);
        return zombieToBlock.m_123341_() * zombieToPlayer.m_123341_() >= 0 && zombieToBlock.m_123343_() * zombieToPlayer.m_123343_() >= 0 && (Math.abs(zombieToBlock.m_123341_()) <= Math.abs(zombieToPlayer.m_123341_()) || Math.abs(zombieToBlock.m_123343_()) <= Math.abs(zombieToPlayer.m_123343_()));
    }

    private final void breakBlock(Zombie zombie, BlockPos pos, BlockState blockState) {
        try {
            Level level = zombie.m_9236_();
            level.m_46961_(pos, true);
            if (StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) {
                System.out.println((Object)("[Storyline Of Mineyarg] DEBUG: \u0417\u043e\u043c\u0431\u0438 \u0441\u043b\u043e\u043c\u0430\u043b \u0431\u043b\u043e\u043a " + blockState.m_60734_().m_49954_().getString() + " \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 " + pos));
            }
        }
        catch (Exception e) {
            System.err.println("[Storyline Of Mineyarg] ERROR: \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043b\u043e\u043c\u0430\u043d\u0438\u0438 \u0431\u043b\u043e\u043a\u0430: " + e.getMessage());
        }
    }

    public final void cleanupZombie(@NotNull Zombie zombie) {
        Intrinsics.checkNotNullParameter((Object)zombie, (String)"zombie");
        lastBreakTime.remove(zombie);
    }

    static {
        Object[] objectArray = new Block[]{Blocks.f_50154_, Blocks.f_50484_, Blocks.f_50485_, Blocks.f_50486_, Blocks.f_50487_, Blocks.f_50488_, Blocks.f_50671_, Blocks.f_50672_, Blocks.f_50166_, Blocks.f_50216_, Blocks.f_50217_, Blocks.f_50218_, Blocks.f_50219_, Blocks.f_50220_, Blocks.f_50221_, Blocks.f_50663_, Blocks.f_50664_, Blocks.f_50376_, Blocks.f_50251_, Blocks.f_50252_, Blocks.f_50253_, Blocks.f_50254_, Blocks.f_50308_, Blocks.f_50309_, Blocks.f_50669_, Blocks.f_50670_, Blocks.f_50124_, Blocks.f_50710_, Blocks.f_50167_, Blocks.f_50168_, Blocks.f_50169_, Blocks.f_50170_, Blocks.f_50171_, Blocks.f_50172_, Blocks.f_50659_, Blocks.f_50660_, Blocks.f_50165_, Blocks.f_50326_, Blocks.f_50327_, Blocks.f_50709_, Blocks.f_50493_, Blocks.f_50546_, Blocks.f_50599_, Blocks.f_50440_, Blocks.f_49992_, Blocks.f_49993_, Blocks.f_49994_, Blocks.f_50129_, Blocks.f_50093_, Blocks.f_152481_, Blocks.f_50195_, Blocks.f_50135_, Blocks.f_50136_};
        breakableBlocks = SetsKt.setOf((Object[])objectArray);
        lastBreakTime = new LinkedHashMap();
    }
}

